/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.bom.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.bom.internal.BOMConverter;
import com.ibm.rules.res.xu.client.internal.XUWarning;
import com.ibm.rules.res.xu.client.internal.XUWarningListener;
import com.ibm.rules.res.xu.client.internal.jca.JCAWarning;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import ilog.rules.util.issue.IlrWarning;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public abstract class BOMConverterBase
implements BOMConverter {
    private final LogHandler log;

    protected BOMConverterBase(LogHandler log) {
        this.log = log;
    }

    @Override
    public final Map<String, Object> toXOMParameters(Map<String, String> bParams, BOMConverter.ObjectKind kind, XUWarningListener l) throws XUException {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(new XUSourceLogRecord.Entry(new Object[]{bParams, kind}));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : bParams.entrySet()) {
            String key = entry.getKey();
            String bomValue = entry.getValue();
            params.put(key, this.toXOM(key, bomValue, kind, l));
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(new XUSourceLogRecord.Exit(params));
        }
        return params;
    }

    @Override
    public final Map<String, String> toBOMParameters(Map<String, Object> params, List<String> filters, boolean roAtts, BOMConverter.ObjectKind kind, XUWarningListener l) throws XUException {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(new XUSourceLogRecord.Entry(new Object[]{params, filters, roAtts, kind}));
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : params.keySet()) {
            Object value = params.get(name);
            String bom = this.toBOM(name, value, filters, roAtts, kind, l);
            result.put(name, bom);
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(new XUSourceLogRecord.Exit(result));
        }
        return result;
    }

    private static XUWarning toXUWarning(IlrWarning warn) {
        return new JCAWarning(XUMessageCode.WARNING_BOM_CONVERSION, new String[]{warn.getMessage()}, null);
    }

    protected static void fireWarnings(Collection<IlrWarning> warnings, XUWarningListener l) {
        for (IlrWarning warn : warnings) {
            l.xuWarningRaised(BOMConverterBase.toXUWarning(warn));
        }
    }
}

