/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.client.internal;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.config.internal.PersistenceConfig;
import com.ibm.rules.res.xu.internal.XUException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.resource.spi.ManagedConnectionFactory;

class PersistenceConfigImpl
implements PersistenceConfig {
    protected ManagedConnectionFactory factory;

    PersistenceConfigImpl(ManagedConnectionFactory factory) {
        this.factory = factory;
    }

    @Override
    public File getDirectory() throws XUException {
        String str = this.getProperty("DIRECTORY");
        if (str == null) {
            return null;
        }
        return new File(str);
    }

    @Override
    public void setDirectory(File file) throws XUException {
        try {
            this.putProperty("DIRECTORY", file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_SET_PROPERTY_FAIL, new String[]{"directory"}, (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getProperties() throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("retrievePersistenceConfig", new Class[0]);
            return (Map)m.invoke((Object)this.factory, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_GET_PROPERTY_FAIL, new String[]{"persistenceConfig"}, (Throwable)e);
        }
    }

    @Override
    public void putProperty(String k, String v) throws XUException {
        Map<String, String> props = this.getProperties();
        if (props == null) {
            props = new HashMap<String, String>();
        }
        try {
            props.put(k, v);
            Method m = this.factory.getClass().getDeclaredMethod("setPersistenceConfig", Map.class);
            m.invoke((Object)this.factory, props);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_SET_PROPERTY_FAIL, new String[]{k}, (Throwable)e);
        }
    }

    @Override
    public String getProperty(String k) throws XUException {
        Map<String, String> props = this.getProperties();
        if (props != null) {
            return props.get(k);
        }
        return null;
    }

    @Override
    public void setType(String type) throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("setPersistenceType", String.class);
            m.invoke((Object)this.factory, type);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_SET_PROPERTY_FAIL, new String[]{"persistenceType"}, (Throwable)e);
        }
    }

    @Override
    public String getType() throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("getPersistenceType", new Class[0]);
            return (String)m.invoke((Object)this.factory, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_GET_PROPERTY_FAIL, new String[]{"persistenceType"}, (Throwable)e);
        }
    }

    @Override
    public boolean isConcurrentAccessEnabled() throws XUException {
        String str = this.getProperty("CONCURRENT_PERSISTENCE_ACCESS");
        if (str == null) {
            return false;
        }
        return Boolean.valueOf(str);
    }

    @Override
    public void setConcurrentAccessEnabled(boolean enabled) throws XUException {
        this.putProperty("CONCURRENT_PERSISTENCE_ACCESS", Boolean.toString(enabled));
    }
}

