/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.client.internal;

import com.ibm.rules.engine.connector.DataConnectorFactory;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.client.info.internal.XUInfo;
import com.ibm.rules.res.xu.client.info.internal.XUInfoWrapper;
import com.ibm.rules.res.xu.client.internal.XUConfigImpl;
import com.ibm.rules.res.xu.client.internal.XUManagementSession;
import com.ibm.rules.res.xu.client.internal.XURuleEngineSession;
import com.ibm.rules.res.xu.client.internal.jca.ResourceAdapterFactory;
import com.ibm.rules.res.xu.config.internal.XUConfig;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.util.lang.IlrClassPrivilegedAction;
import ilog.rules.res.xu.cci.IlrXUConnectionFactory;
import ilog.rules.res.xu.cci.IlrXUConnectionSpec;
import ilog.rules.res.xu.spi.IlrManagedXUConnectionFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ManagedConnectionFactory;

public class XUClient {
    private ConnectionFactory connFactory;
    private XUConfig cfg;
    protected static Constructor directSessionConstr;

    XUClient(ConnectionFactory connFactory) {
        this.connFactory = connFactory;
    }

    public final synchronized XUConfig getConfig() throws XUException {
        if (this.cfg == null) {
            this.cfg = new XUConfigImpl(this.getManagedConnectionFactory());
        }
        return this.cfg;
    }

    final ConnectionFactory getConnectionFactory() {
        return this.connFactory;
    }

    public static XUClient createXUClient(ConnectionFactory connFactory) throws XUException {
        if (!XUClient.isXUConnectionFactory(connFactory)) {
            throw new XUException("XU.ERROR.10902", null, null);
        }
        return new XUClient(connFactory);
    }

    public static XUClient createJ2SEXUClient(PrintWriter log) throws XUException {
        ResourceAdapterFactory raFactory = new ResourceAdapterFactory();
        try {
            ConnectionFactory connFactory = raFactory.createCCIFactory(log);
            return XUClient.createXUClient(connFactory);
        }
        catch (ResourceException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
    }

    public final XURuleEngineSession createRuleEngineSession(IlrPath rulesetPath, ClassLoader xomClassLoader, DataConnectorFactory dcFactory, Serializable userData, String callerVersion) throws XUException {
        if (rulesetPath == null) {
            throw new XUException("XU.ERROR.19000", null, null);
        }
        if (this.connFactory == null) {
            throw new XUException(XUMessageCode.ERROR_XU_DESTROYED);
        }
        IlrXUConnectionSpec spec = new IlrXUConnectionSpec();
        spec.setType((byte)0);
        spec.setRulesetPath(rulesetPath.toString());
        spec.setXOMClassLoader(xomClassLoader);
        spec.setUserData(userData);
        spec.setClientJRulesImplementationVersion(callerVersion);
        spec.setReconnectSupportEnabled(true);
        spec.setDataConnectorFactory(dcFactory);
        try {
            Connection conn = this.connFactory.getConnection((ConnectionSpec)spec);
            ClassLoader specCL = IlrClassPrivilegedAction.getClassLoader(spec.getClass());
            ClassLoader connCL = IlrClassPrivilegedAction.getClassLoader(conn.getClass());
            if (connCL == specCL) {
                return XUClient.createDirectXURuleEngineSession(conn, this.connFactory);
            }
            return new XURuleEngineSession(conn, this.connFactory);
        }
        catch (Exception e) {
            throw new XUException("XU.ERROR.10900", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final XURuleEngineSession createDirectXURuleEngineSession(Connection conn, ConnectionFactory factory) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<XUClient> clazz = XUClient.class;
        synchronized (XUClient.class) {
            if (directSessionConstr == null) {
                Class<?> sessClass = Class.forName("com.ibm.rules.res.xu.client.internal.DirectXURuleEngineSession");
                Class<?> connClass = Class.forName("ilog.rules.res.xu.cci.IlrXUConnection");
                directSessionConstr = sessClass.getConstructor(connClass, ConnectionFactory.class);
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return (XURuleEngineSession)directSessionConstr.newInstance(conn, factory);
        }
    }

    protected static final boolean isXUConnectionFactory(ConnectionFactory factory) throws XUException {
        if (factory == null) {
            return false;
        }
        try {
            ResourceAdapterMetaData factoryInfo = factory.getMetaData();
            return factoryInfo != null && factoryInfo.getAdapterName().equals(XUInfo.getName());
        }
        catch (ResourceException e) {
            throw new XUException("XU.ERROR.10902", e);
        }
    }

    public final XUManagementSession createManagementSession(String callerVersion) throws XUException {
        IlrXUConnectionSpec connectionSpec = new IlrXUConnectionSpec();
        connectionSpec.setType((byte)1);
        connectionSpec.setClientJRulesImplementationVersion(callerVersion);
        if (this.connFactory == null) {
            throw new XUException(XUMessageCode.ERROR_XU_DESTROYED);
        }
        try {
            return new XUManagementSession(this.connFactory.getConnection((ConnectionSpec)connectionSpec), this.connFactory);
        }
        catch (ResourceException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
    }

    public XUInfo getXUInfo() throws XUException {
        return XUClient.getXUInfo(this.getConnectionFactory());
    }

    public static XUInfo getXUInfo(ConnectionFactory factory) throws XUException {
        if (factory == null) {
            throw new XUException(XUMessageCode.ERROR_XU_DESTROYED);
        }
        try {
            if (factory instanceof IlrXUConnectionFactory) {
                return ((IlrXUConnectionFactory)factory).getXUInfo();
            }
            Method method = factory.getClass().getDeclaredMethod("getXUInfo", new Class[0]);
            Object info = method.invoke((Object)factory, new Object[0]);
            if (info instanceof XUInfo) {
                return (XUInfo)info;
            }
            return new XUInfoWrapper(info);
        }
        catch (NoSuchMethodException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
        catch (IllegalAccessException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
        catch (InvocationTargetException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
    }

    public String getShortDescription(Locale locale) throws XUException {
        if (this.connFactory == null) {
            throw new XUException(XUMessageCode.ERROR_XU_DESTROYED);
        }
        try {
            ResourceAdapterMetaData metaData = this.connFactory.getMetaData();
            Class<?> clazz = metaData.getClass();
            Method method = clazz.getMethod("getAdapterShortDescription", Locale.class);
            String str = (String)method.invoke((Object)metaData, locale);
            return str;
        }
        catch (ResourceException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
        catch (SecurityException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
        catch (NoSuchMethodException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
        catch (IllegalArgumentException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
        catch (IllegalAccessException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
        catch (InvocationTargetException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
    }

    ManagedConnectionFactory getManagedConnectionFactory() throws XUException {
        ConnectionFactory connFactory = this.getConnectionFactory();
        if (connFactory == null) {
            throw new XUException(XUMessageCode.ERROR_XU_DESTROYED);
        }
        try {
            Method m = connFactory.getClass().getMethod("getManagedConnectionFactory", new Class[0]);
            return (ManagedConnectionFactory)m.invoke((Object)connFactory, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException("XU.ERROR.10901", e);
        }
    }

    public final void stopXU() throws XUException {
        IlrXUConnectionFactory factory = (IlrXUConnectionFactory)this.getConnectionFactory();
        if (factory == null) {
            throw new XUException(XUMessageCode.ERROR_XU_ALREADY_DESTROYED);
        }
        IlrManagedXUConnectionFactory spiFactory = factory.getManagedConnectionFactory();
        spiFactory.getResourceAdapter().stop();
        this.connFactory = null;
        this.cfg = null;
    }
}

