/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.client.internal;

import com.ibm.rules.res.xu.client.internal.OperationListParameter;
import com.ibm.rules.res.xu.client.internal.OperationMapParameter;
import com.ibm.rules.res.xu.client.internal.OperationParameter;
import com.ibm.rules.res.xu.client.internal.RulesetExecutionListener;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.rules.res.xu.client.internal.XUSession;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.xu.cci.IlrRuleEngineInteractionSpec;
import ilog.rules.res.xu.cci.ruleset.IlrRulesetExecutionTrace;
import ilog.rules.res.xu.cci.ruleset.impl.IlrRulesetExecutionTraceImplWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;

public class XURuleEngineSession
extends XUSession {
    private static final IlrRuleEngineInteractionSpec engineExecuteInteractionSpec = new IlrRuleEngineInteractionSpec();
    private static final IlrRuleEngineInteractionSpec engineResetRuleflowInteractionSpec;
    private static final IlrRuleEngineInteractionSpec engineGetOutputInteractionSpec;
    private static final IlrRuleEngineInteractionSpec getInformationInteractionSpec;
    private static final IlrRuleEngineInteractionSpec engineSetParametersInteractionSpec;
    private static final IlrRuleEngineInteractionSpec engineIsRulesetUptodateInteractionSpec;

    XURuleEngineSession(Connection connection, ConnectionFactory factory) {
        super(connection, factory);
    }

    protected final boolean executeRuleEngineOperation(String fctName, OperationParameter in, OperationParameter out) throws XUException {
        IlrRuleEngineInteractionSpec spec = new IlrRuleEngineInteractionSpec();
        spec.setFunctionName(fctName);
        return this.executeOperation(spec, in, out);
    }

    public void loadUptodateRuleset() throws XUException {
        this.checkConnection();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_LOAD_UPTODATE_RULESET, null, null);
    }

    public ClassLoader getManagedXOMClassLoader() throws XUException {
        this.checkConnection();
        OperationMapParameter out = new OperationMapParameter();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_GET_RULESET_INFORMATION, null, out);
        return (ClassLoader)out.get("managedXOMClassLoader");
    }

    public ClassLoader getRulesetXOMClassLoader() throws XUException {
        this.checkConnection();
        OperationMapParameter out = new OperationMapParameter();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_GET_RULESET_INFORMATION, null, out);
        return (ClassLoader)out.get("rulesetXOMClassLoader");
    }

    public Map<String, Object> executeTask(String taskName) throws XUException {
        this.checkConnection();
        OperationListParameter input = new OperationListParameter(1);
        input.add(taskName);
        OperationMapParameter out = new OperationMapParameter();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EXECUTE_TASK, input, out);
        return out;
    }

    public Object executeMain(Object parameter) throws XUException {
        this.checkConnection();
        OperationListParameter in = new OperationListParameter(1);
        in.add(parameter);
        OperationListParameter out = new OperationListParameter();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EXECUTE_MAIN, in, out);
        return out.get(0);
    }

    public List<String> toXMLBOM(Object[] objs) throws XUException {
        this.checkConnection();
        OperationListParameter input = new OperationListParameter(objs.length);
        for (Object o : objs) {
            input.add(o);
        }
        OperationListParameter out = new OperationListParameter();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_OBJECTS_TO_BOM_STRINGS, input, out);
        return out;
    }

    public List<Object> toXMLObjects(String[] xmls) throws XUException {
        this.checkConnection();
        OperationListParameter input = new OperationListParameter(xmls.length);
        for (String o : xmls) {
            input.add(o);
        }
        OperationListParameter out = new OperationListParameter();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_XML_TO_XML_OBJECTS, input, out);
        return out;
    }

    public List<String> toJSONBOM(Object[] objs) throws XUException {
        this.checkConnection();
        OperationListParameter in = new OperationListParameter(objs.length);
        for (Object o : objs) {
            in.add(o);
        }
        OperationListParameter out = new OperationListParameter();
        IlrRuleEngineInteractionSpec spec = new IlrRuleEngineInteractionSpec();
        spec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_OBJECTS_TO_BOM_STRINGS);
        spec.setBOMParameterKind(1);
        this.executeOperation(spec, (OperationParameter)in, (OperationParameter)out);
        return out;
    }

    public Map<String, String> getParametersAsXMLBOM(byte direction, List<String> filters, boolean readOnlyParameterAttributes) throws XUException {
        return this.getParametersAsBOM(direction, filters, readOnlyParameterAttributes, 0);
    }

    public Map<String, String> getParametersAsJSONBOM(byte direction, List<String> filters, boolean readOnlyParameterAttributes) throws XUException {
        return this.getParametersAsBOM(direction, filters, readOnlyParameterAttributes, 1);
    }

    protected Map<String, String> getParametersAsBOM(byte dir, List<String> filters, boolean roAtts, int kind) throws XUException {
        this.checkConnection();
        String fctName = roAtts ? IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_BOM_PARAMETERS_WITH_READ_ONLY_FIELDS : IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_BOM_PARAMETERS;
        IlrRuleEngineInteractionSpec spec = new IlrRuleEngineInteractionSpec();
        spec.setFunctionName(fctName);
        spec.setParameterDirection(dir);
        spec.setBOMParametersExclusionFilters(filters);
        spec.setBOMParameterKind(kind);
        OperationMapParameter out = new OperationMapParameter();
        this.executeOperation(spec, null, (OperationParameter)out);
        return out;
    }

    public Map<String, Object> getXOMParameters(byte direction) throws XUException {
        this.checkConnection();
        IlrRuleEngineInteractionSpec spec = new IlrRuleEngineInteractionSpec();
        spec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_XOM_PARAMETERS);
        spec.setParameterDirection(direction);
        OperationMapParameter out = new OperationMapParameter();
        this.executeOperation(spec, null, (OperationParameter)out);
        return out;
    }

    public Map<String, Object> getParameters(byte direction) throws XUException {
        this.checkConnection();
        IlrRuleEngineInteractionSpec spec = new IlrRuleEngineInteractionSpec();
        spec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_PARAMETERS);
        spec.setParameterDirection(direction);
        OperationMapParameter out = new OperationMapParameter();
        this.executeOperation(spec, null, (OperationParameter)out);
        return out;
    }

    public Collection<XURulesetParameter> getRulesetParameters() throws XUException {
        this.checkConnection();
        IlrRuleEngineInteractionSpec spec = new IlrRuleEngineInteractionSpec();
        spec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_RULESET_PARAMETERS);
        OperationListParameter out = new OperationListParameter();
        this.executeOperation(spec, null, (OperationParameter)out);
        ArrayList<XURulesetParameter> params = new ArrayList<XURulesetParameter>();
        for (Map p : out) {
            params.add(new XURulesetParameter(p));
        }
        return params;
    }

    public String getOutput() throws XUException {
        this.checkConnection();
        OperationListParameter out = new OperationListParameter();
        this.executeOperation(engineGetOutputInteractionSpec, null, (OperationParameter)out);
        return (String)out.get(0);
    }

    public void setParameters(Map<String, Object> params) throws XUException {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        this.checkConnection();
        OperationMapParameter input = new OperationMapParameter();
        input.putAll(params);
        this.executeOperation(engineSetParametersInteractionSpec, (OperationParameter)input, null);
    }

    public void setParametersAsXMLBOM(Map<String, String> params) throws XUException {
        this.setParametersAsBOM(params, 0);
    }

    public void setParametersAsJSONBOM(Map<String, String> params) throws XUException {
        this.setParametersAsBOM(params, 1);
    }

    protected void setParametersAsBOM(Map<String, String> params, int kind) throws XUException {
        this.checkConnection();
        OperationMapParameter input = new OperationMapParameter();
        input.putAll(params);
        IlrRuleEngineInteractionSpec spec = new IlrRuleEngineInteractionSpec();
        spec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_SET_BOM_PARAMETERS);
        spec.setBOMParameterKind(kind);
        this.executeOperation(spec, (OperationParameter)input, null);
    }

    public IlrRulesetExecutionTrace getRulesetExecutionTrace() throws XUException {
        this.checkConnection();
        OperationListParameter result = new OperationListParameter();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_GET_RULESET_EXECUTION_TRACE, null, result);
        Object o = result.get(0);
        if (o instanceof IlrRulesetExecutionTrace) {
            return (IlrRulesetExecutionTrace)o;
        }
        return new IlrRulesetExecutionTraceImplWrapper((Map)o);
    }

    public int getFiredRulesCount() throws XUException {
        this.checkConnection();
        OperationListParameter result = new OperationListParameter();
        this.executeOperation(getInformationInteractionSpec, null, (OperationParameter)result);
        return (Integer)result.get(0);
    }

    public void enableRulesetExecutionInformation(int filter, Properties filterProperties) throws XUException {
        this.checkConnection();
        IlrRuleEngineInteractionSpec spec = new IlrRuleEngineInteractionSpec();
        spec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_ENABLE_RULESET_EXECUTION_INFORMATION);
        spec.setRulesetExecutionInformationFilter(filter);
        OperationMapParameter input = new OperationMapParameter();
        if (filterProperties != null) {
            input.putAll(filterProperties);
        }
        this.executeOperation(spec, (OperationParameter)input, null);
    }

    public void insert(Object object) throws XUException {
        this.checkConnection();
        this.insert(object, IlrRuleEngineInteractionSpec.OBJECT_KIND_JAVA);
    }

    public void update(Object object) throws XUException {
        this.checkConnection();
        OperationListParameter input = new OperationListParameter(1);
        input.add(object);
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_UPDATE, input, null);
    }

    public void updateById(Object id) throws XUException {
        this.checkConnection();
        OperationListParameter input = new OperationListParameter(1);
        input.add(id);
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_UPDATE_BY_ID, input, null);
    }

    public void retract(Object object) throws XUException {
        this.checkConnection();
        OperationListParameter input = new OperationListParameter(1);
        input.add(object);
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RETRACT, input, null);
    }

    public void insert(Object object, Integer type) throws XUException {
        this.checkConnection();
        OperationListParameter input = new OperationListParameter(2);
        input.add(type);
        input.add(object);
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_INSERT, input, null);
    }

    public void insert(List<Object> list) throws XUException {
        this.checkConnection();
        OperationListParameter input = new OperationListParameter(list.size());
        input.addAll(list);
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_INSERT_WITH_ID, input, null);
    }

    public void asynchronousExecute(RulesetExecutionListener listener) throws XUException {
        this.checkConnection();
        IlrRuleEngineInteractionSpec spec = new IlrRuleEngineInteractionSpec();
        spec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_ASYNCHRONOUS_EXECUTE);
        spec.setRulesetExecutionListener(listener);
        this.executeOperation(spec, null, null);
    }

    public Map<String, Object> execute() throws XUException {
        this.checkConnection();
        OperationMapParameter out = new OperationMapParameter();
        this.executeOperation(engineExecuteInteractionSpec, null, (OperationParameter)out);
        return out;
    }

    public void reset() throws XUException {
        this.checkConnection();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RESET, null, null);
    }

    public Map<Object, Object> getWorkingMemoryById() throws XUException {
        this.checkConnection();
        OperationMapParameter out = new OperationMapParameter();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_WORKING_MEMORY_WITH_ID, null, out);
        return out;
    }

    public Map<String, String> getRulesetArchiveProperties() throws XUException {
        this.checkConnection();
        OperationMapParameter out = new OperationMapParameter();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_GET_RULESET_INFORMATION, null, out);
        return (Map)out.get("properties");
    }

    public String getCanonicalRulesetPath() throws XUException {
        this.checkConnection();
        OperationMapParameter out = new OperationMapParameter();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_GET_RULESET_INFORMATION, null, out);
        return (String)out.get("path.canonical");
    }

    public List<Object> getWorkingMemory() throws XUException {
        this.checkConnection();
        OperationListParameter out = new OperationListParameter();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_WORKING_MEMORY, null, out);
        return out;
    }

    public void retractById(Serializable id) throws XUException {
        this.checkConnection();
        OperationListParameter in = new OperationListParameter(1);
        in.add(id);
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RETRACT_BY_ID, in, null);
    }

    public void resetRuleflow() throws XUException {
        this.checkConnection();
        this.executeOperation(engineResetRuleflowInteractionSpec, null, null);
    }

    public boolean isRulesetUptodate() throws XUException {
        this.checkConnection();
        OperationListParameter out = new OperationListParameter();
        this.executeOperation(engineIsRulesetUptodateInteractionSpec, null, (OperationParameter)out);
        return (Boolean)out.get(0);
    }

    public final void resetRulesetExecutionTrace() throws XUException {
        this.checkConnection();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULESET_EXECUTION_TRACE_RESET, null, null);
    }

    public final Object invokeFunction(String name, Object ... args) throws XUException {
        this.checkConnection();
        OperationListParameter out = new OperationListParameter();
        IlrRuleEngineInteractionSpec spec = new IlrRuleEngineInteractionSpec();
        spec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_INVOKE_FUNCTION);
        spec.setRulesetFunctionName(name);
        spec.setRulesetFunctionArguments(args);
        this.executeOperation(spec, null, (OperationParameter)out);
        return out.get(0);
    }

    public List<Object> toNodes(List<Object> xom) throws XUException {
        this.checkConnection();
        OperationListParameter input = new OperationListParameter(xom.size());
        for (Object o : xom) {
            input.add(o);
        }
        OperationListParameter output = new OperationListParameter();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_XOM_TO_NODES, input, output);
        return output;
    }

    public List<Object> nodesToXOMObjects(List<Object> nodes) throws XUException {
        this.checkConnection();
        OperationListParameter input = new OperationListParameter(nodes.size());
        for (Object o : nodes) {
            input.add(o);
        }
        OperationListParameter output = new OperationListParameter();
        this.executeRuleEngineOperation(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_NODES_TO_XOM_OBJECTS, input, output);
        return output;
    }

    static {
        engineExecuteInteractionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EXECUTE);
        engineResetRuleflowInteractionSpec = new IlrRuleEngineInteractionSpec();
        engineResetRuleflowInteractionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RULEFLOW_RESET);
        engineGetOutputInteractionSpec = new IlrRuleEngineInteractionSpec();
        engineGetOutputInteractionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_OUTPUT);
        getInformationInteractionSpec = new IlrRuleEngineInteractionSpec();
        getInformationInteractionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_GET_INFORMATION);
        engineSetParametersInteractionSpec = new IlrRuleEngineInteractionSpec();
        engineSetParametersInteractionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_SET_PARAMETERS);
        engineIsRulesetUptodateInteractionSpec = new IlrRuleEngineInteractionSpec();
        engineIsRulesetUptodateInteractionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_IS_RULESET_UPTODATE);
    }
}

