/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.client.internal.jca;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.client.internal.RulesetExecutionListener;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.rules.res.xu.client.internal.jca.XUInteractionSpec;
import com.ibm.rules.res.xu.engine.internal.EngineManager;
import com.ibm.rules.res.xu.internal.LocalizedResourceException;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetImpl;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.res.xu.cci.IlrInteractionExtension;
import ilog.rules.res.xu.cci.IlrRuleEngineInteractionSpec;
import ilog.rules.res.xu.cci.IlrXUConnection;
import ilog.rules.res.xu.cci.IlrXUManagementInteractionSpec;
import ilog.rules.res.xu.ruleset.archive.internal.IlrXURulesetArchiveInformation;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationImpl;
import ilog.rules.res.xu.spi.IlrManagedConnectionContext;
import ilog.rules.xml.IlrXmlObject;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;

public final class XUInteraction
implements Interaction {
    private static final byte STATE_ACTIVE = 0;
    private static final byte STATE_CLOSED = 1;
    private IlrXUConnection conn;
    private final LogHandler logger;
    private byte state = 0;
    private final boolean isFinestLoggable;

    public XUInteraction(IlrXUConnection connection) {
        this.conn = connection;
        this.logger = connection.getLogHandler();
        this.isFinestLoggable = connection.isFinestLoggable();
    }

    public final Connection getConnection() {
        return this.conn;
    }

    private boolean dispatchExecution(String fct, InteractionSpec spec, Record in, Record out) throws XUException {
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EXECUTE) {
            return this.engineExecute(out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_PARAMETERS) {
            return this.engineGetParameters(out, spec);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_BOM_PARAMETERS) {
            return this.engineGetParametersAsBOM(spec, out, false);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_BOM_PARAMETERS_WITH_READ_ONLY_FIELDS) {
            return this.engineGetParametersAsBOM(spec, out, true);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EXECUTE_MAIN) {
            return this.engineExecuteMain(in, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EXECUTE_TASK) {
            return this.engineExecuteTask(in, out, spec);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_SET_PARAMETERS) {
            return this.engineSetParameters(in, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_SET_BOM_PARAMETERS) {
            return this.engineSetParametersAsBOM(spec, in);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_INSERT) {
            return this.engineInsert(in, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_INSERT_WITH_ID) {
            return this.engineInsertWithId(in, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RETRACT) {
            return this.engineRetract(in, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RETRACT_BY_ID) {
            return this.engineRetractById(in, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_UPDATE) {
            return this.engineUpdate(in, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_UPDATE_BY_ID) {
            return this.engineUpdateById(in, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_OUTPUT) {
            return this.engineGetOutput(in, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RESET) {
            return this.engineReset();
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RULEFLOW_RESET) {
            return this.engineRuleflowReset();
        }
        if (fct == IlrXUManagementInteractionSpec.FUNCTION_NAME_START_PROFILING_SESSION) {
            return this.startProfilingSession(spec, in, out);
        }
        if (fct == IlrXUManagementInteractionSpec.FUNCTION_NAME_STOP_PROFILING_SESSION) {
            return this.stopProfilingSession(spec, in, out);
        }
        if (fct == IlrXUManagementInteractionSpec.FUNCTION_NAME_GET_CONNECTION_ID) {
            return this.getConnectionId(out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_GET_RULESET_INFORMATION) {
            return this.getRulesetInformation(out);
        }
        if (fct == IlrXUManagementInteractionSpec.FUNCTION_NAME_SOLVE_RULESET_PATH) {
            return this.solveRulesetPath(spec, out);
        }
        if (fct == IlrXUManagementInteractionSpec.FUNCTION_NAME_RULESET_ARCHIVE_CHANGED) {
            return this.notifyRulesetArchiveChanged(spec, in, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_WORKING_MEMORY) {
            return this.engineGetWorkingMemory(out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_WORKING_MEMORY_WITH_ID) {
            return this.engineGetWorkingMemoryWithId(out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_GET_INFORMATION) {
            return this.engineGetFiredRulesCount(out);
        }
        if (fct == IlrXUManagementInteractionSpec.FUNCTION_NAME_WRITE_LOG) {
            return this.writeLog(in);
        }
        if (fct == IlrXUManagementInteractionSpec.FUNCTION_NAME_SET_USER_DATA) {
            return this.setUserData(in);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_ENABLE_RULESET_EXECUTION_INFORMATION) {
            return this.enableRulesetExecutionInformation(spec, in);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_GET_RULESET_EXECUTION_TRACE) {
            return this.getExecutionTrace(out);
        }
        if (fct == IlrXUManagementInteractionSpec.FUNCTION_NAME_GET_CONNECTOR_CONFIG_PROPERTIES) {
            return this.getConnectorConfigProperties(out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_LOAD_UPTODATE_RULESET) {
            return this.loadUptodateRuleset();
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_ASYNCHRONOUS_EXECUTE) {
            return this.engineAsyncExecute(spec);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULESET_EXECUTION_TRACE_RESET) {
            return this.resetRulesetExecutionTrace(spec);
        }
        if (fct == IlrXUManagementInteractionSpec.FUNCTION_NAME_GET_RULESET_USAGE_INFORMATION) {
            return this.getRulesetUsageInformation(spec, out);
        }
        if (fct == IlrXUManagementInteractionSpec.FUNCTION_NAME_START_MAINTENANCE_TASKS) {
            return this.startMaintenanceTasks();
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_RULESET_PARAMETERS) {
            return this.contextGetRulesetParameters(out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_OBJECTS_TO_BOM_STRINGS) {
            return this.engineToBOM(spec, in, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_IS_RULESET_UPTODATE) {
            return this.engineIsRulesetUptodate(out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_INVOKE_FUNCTION) {
            return this.engineInvokeFunction(spec, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_XML_TO_XML_OBJECTS) {
            return this.engineToXMLObjects(in, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_XOM_PARAMETERS) {
            return this.engineGetXOMParameters(out, spec);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_XOM_TO_NODES) {
            return this.engineToNodes(in, out);
        }
        if (fct == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_NODES_TO_XOM_OBJECTS) {
            return this.engineNodesToXOMObjects(in, out);
        }
        return this.executeInteractionExtension(spec, in, out);
    }

    private boolean getExecutionTrace(Record out) throws XUException {
        if (out instanceof IndexedRecord) {
            IndexedRecord l = (IndexedRecord)out;
            l.add((Object)this.conn.getRulesetExecutionTrace());
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineIsRulesetUptodate(Record out) throws XUException {
        if (out instanceof IndexedRecord) {
            IndexedRecord l = (IndexedRecord)out;
            l.add(this.conn.isRulesetUptodate());
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean executeInteractionExtension(InteractionSpec spec, Record in, Record out) throws XUException {
        String name;
        IlrInteractionExtension[] exts;
        for (IlrInteractionExtension ext : exts = this.conn.getInteractionExtensions()) {
            if (!ext.isSupported(spec)) continue;
            boolean r = this.conn.executeInteractionExtension(ext, spec, in, out);
            if (!r) {
                String name2;
                try {
                    name2 = XUInteractionSpec.getFunctionName(spec);
                }
                catch (XUException e) {
                    name2 = null;
                }
                this.logger.severe(XUMessageCode.ERROR_PLUGIN_OPERATION_RETURNS_FALSE, null, new Object[]{name2}, null);
            }
            return r;
        }
        try {
            name = XUInteractionSpec.getFunctionName(spec);
        }
        catch (XUException e) {
            name = null;
        }
        throw new XUException(XUMessageCode.ERROR_OPERATION_NAME_NOT_SUPPORTED, new Object[]{name}, null);
    }

    private void logFinest(String msg, IlrXUContext ctx) {
        this.logger.finest(this.getClass().getName() + msg, null, ctx);
    }

    public final boolean execute(InteractionSpec spec, Record in, Record out) throws ResourceException, RuntimeException {
        boolean result = false;
        String fct = null;
        try {
            if (this.isFinestLoggable) {
                this.logFinest(".execute " + spec, null);
            }
            if (this.state == 1) {
                throw new XUException("XU.ERROR.10501");
            }
            fct = XUInteractionSpec.getFunctionName(spec);
            result = this.dispatchExecution(fct, spec, in, out);
        }
        catch (Throwable e) {
            ResourceException re;
            IlrManagedConnectionContext ctx = this.conn != null && this.conn.getManagedConnection() != null ? this.conn.getManagedConnection().getManagedConnectionContext(this.conn) : null;
            if (e instanceof ResourceException) {
                re = (ResourceException)e;
            } else if (e instanceof XUException) {
                XUException xe = (XUException)e;
                re = new LocalizedResourceException(xe.getMessageCode(), xe.getMessageParameters(), xe.getCause());
            } else {
                re = new LocalizedResourceException("XU.ERROR.10001", new Object[]{fct}, e);
            }
            this.logger.severe("XU.ERROR.10001", re, new Object[]{fct}, ctx);
            throw re;
        }
        return result;
    }

    public final Record execute(InteractionSpec spec, Record in) throws ResourceException {
        throw new NotSupportedException();
    }

    public final void close() throws ResourceException {
        if (this.isFinestLoggable) {
            this.logFinest(".close ", this.getXUContext());
        }
        if (this.state == 1) {
            LocalizedResourceException e = new LocalizedResourceException("XU.ERROR.10500");
            this.logger.severe("XU.ERROR.10502", (Throwable)((Object)e), null, null);
            throw e;
        }
        this.state = 1;
        this.conn = null;
    }

    public final ResourceWarning getWarnings() throws ResourceException {
        if (this.isFinestLoggable) {
            this.logFinest(".getWarnings " + this.conn.getWarnings(), this.getXUContext());
        }
        return this.conn.getWarnings();
    }

    public final void clearWarnings() throws ResourceException {
        if (this.isFinestLoggable) {
            this.logFinest(".clearWarnings", this.getXUContext());
        }
        this.conn.clearWarnings();
    }

    private boolean notifyRulesetArchiveChanged(InteractionSpec spec, Record input, Record output) throws XUException {
        String p = XUInteraction.getCanonicalRulesetPath(spec);
        if (p != null) {
            this.conn.notifyRulesetArchiveChanged(p);
            return true;
        }
        throw new XUException("XU.ERROR.10012", new String[]{spec.toString()});
    }

    private boolean solveRulesetPath(InteractionSpec spec, Record out) throws XUException {
        String p = XUInteraction.getRulesetPath(spec);
        if (p == null) {
            throw new XUException("XU.ERROR.10012", new String[]{spec.toString()});
        }
        if (out == null || !(out instanceof IndexedRecord)) {
            throw new XUException("XU.ERROR.10013");
        }
        ((IndexedRecord)out).add((Object)this.conn.solveRulesetPath(p));
        return true;
    }

    private boolean startProfilingSession(InteractionSpec spec, Record in, Record out) throws XUException {
        if (in != null && in instanceof MappedRecord) {
            MappedRecord map = (MappedRecord)in;
            Properties props = new Properties();
            props.putAll((Map<?, ?>)map);
            this.conn.startProfilingSession(props);
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean stopProfilingSession(InteractionSpec spec, Record in, Record out) throws XUException {
        if (in != null && in instanceof MappedRecord) {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)((MappedRecord)in));
            this.conn.stopProfilingSession(props);
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean enableRulesetExecutionInformation(InteractionSpec spec, Record in) throws XUException {
        if (!(in instanceof MappedRecord)) {
            throw new XUException("XU.ERROR.10013");
        }
        int filter = XUInteraction.getRulesetExecutionInformationFilter(spec);
        this.conn.enableRulesetExecutionInformation(filter, (Map<String, String>)((MappedRecord)in));
        return true;
    }

    private boolean writeLog(Record in) throws XUException {
        if (in instanceof IndexedRecord) {
            IndexedRecord list = (IndexedRecord)in;
            int n = list.size();
            String[] strs = new String[n];
            for (int i = 0; i < n; ++i) {
                strs[i] = list.get(i).toString();
            }
            this.conn.writeLog(strs);
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean setUserData(Record in) throws XUException {
        IndexedRecord list;
        Object data;
        if (in instanceof IndexedRecord && (data = (list = (IndexedRecord)in).get(0)) instanceof Serializable) {
            this.conn.setUserData((Serializable)data);
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineGetFiredRulesCount(Record output) throws XUException {
        if (output instanceof IndexedRecord) {
            ((IndexedRecord)output).add((Object)this.conn.engineGetFiredRulesCount());
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineAsyncExecute(InteractionSpec spec) throws XUException {
        this.conn.engineAsyncExecute(XUInteraction.getRulesetExecutionListener(spec));
        return true;
    }

    private boolean engineExecute(Record out) throws XUException {
        if (out instanceof Map) {
            this.conn.engineExecute((Map)out);
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineGetParameters(Record out, InteractionSpec spec) throws XUException {
        if (out instanceof Map) {
            byte dir = XUInteraction.getParameterDirection(spec);
            this.conn.engineGetParameters(dir, (Map)out);
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineGetXOMParameters(Record out, InteractionSpec spec) throws XUException {
        if (out instanceof Map) {
            byte dir = XUInteraction.getParameterDirection(spec);
            this.conn.engineGetXOMParameters(dir, (Map)out);
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean contextGetRulesetParameters(Record output) throws XUException {
        if (output instanceof IndexedRecord) {
            XURulesetParameter[] params;
            for (XURulesetParameter p : params = this.conn.getRulesetParameters()) {
                ((IndexedRecord)output).add(p.toMap());
            }
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean getConnectorConfigProperties(Record output) throws XUException {
        if (output instanceof MappedRecord) {
            ((MappedRecord)output).putAll(this.conn.getXUProperties());
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineGetParametersAsBOM(InteractionSpec spec, Record out, boolean roAtts) throws XUException {
        if (out instanceof MappedRecord) {
            List<String> filters = XUInteraction.getBOMParametersExclusionFilters(spec);
            byte dir = XUInteraction.getParameterDirection(spec);
            int kind = XUInteraction.getBOMParameterKind(spec);
            MappedRecord map = (MappedRecord)out;
            map.putAll(this.conn.engineGetParametersAsBOM(dir, filters, roAtts, kind));
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean getConnectionId(Record output) throws XUException {
        if (output instanceof IndexedRecord) {
            ((IndexedRecord)output).add((Object)this.conn.getId());
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean getRulesetInformation(Record out) throws XUException {
        if (!(out instanceof MappedRecord)) {
            throw new XUException("XU.ERROR.10013");
        }
        Map map = (Map)out;
        map.put("path", this.conn.getSpec().getRulesetPath());
        IlrXURulesetArchiveInformation rulesetArchiveInformation = this.conn.getXURulesetArchiveInformation();
        map.put("path.canonical", rulesetArchiveInformation.getCanonicalPath().toString());
        map.put("properties", rulesetArchiveInformation.getProperties());
        EngineManager mgr = this.conn.getManagedConnection().getEngineManager(this.conn, false);
        XURulesetImpl ruleset = mgr.getRuleset();
        map.put("managedXOMClassLoader", ruleset.getManagedXOMClassLoader());
        map.put("rulesetXOMClassLoader", ruleset.getRulesetXOMClassLoader());
        if (this.isFinestLoggable) {
            this.logFinest(".getRulesetInformation: " + map, null);
        }
        return true;
    }

    private boolean engineExecuteMain(Record in, Record out) throws XUException {
        if (!(in instanceof List) || !(out instanceof List)) {
            throw new XUException("XU.ERROR.10013");
        }
        List inL = (List)in;
        List outL = (List)out;
        Object param = inL.size() == 1 ? inL.get(0) : null;
        outL.add(this.conn.engineExecuteMain(param));
        return true;
    }

    private boolean engineExecuteTask(Record input, Record output, InteractionSpec spec) throws XUException {
        IndexedRecord indexedRecord;
        if (input instanceof IndexedRecord && output instanceof MappedRecord && (indexedRecord = (IndexedRecord)input).size() == 1) {
            Object objTaskName = indexedRecord.get(0);
            if (objTaskName instanceof String) {
                String taskName = (String)objTaskName;
                this.conn.engineExecuteTask(taskName, (Map)output);
            }
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineSetParameters(Record input, Record output) throws XUException {
        HashMap parameters = null;
        if (input != null && input instanceof MappedRecord) {
            if (input instanceof HashMap) {
                parameters = (HashMap)input;
            } else if (input instanceof Map) {
                parameters = new HashMap();
                parameters.putAll((Map)input);
            }
        }
        if (parameters != null) {
            this.conn.engineSetParameters(parameters);
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineSetParametersAsBOM(InteractionSpec spec, Record in) throws XUException {
        HashMap params = null;
        if (in != null && in instanceof MappedRecord) {
            if (in instanceof HashMap) {
                params = (HashMap)in;
            } else if (in instanceof Map) {
                params = new HashMap();
                params.putAll((Map)in);
            }
        }
        if (params != null) {
            int kind = XUInteraction.getBOMParameterKind(spec);
            this.conn.engineSetParametersAsBOM(params, kind);
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineToBOM(InteractionSpec spec, Record in, Record out) throws XUException {
        if (in instanceof IndexedRecord && out instanceof IndexedRecord) {
            String[] strs;
            int kind = XUInteraction.getBOMParameterKind(spec);
            for (String s : strs = this.conn.engineToBOM((List)in, kind)) {
                ((IndexedRecord)out).add((Object)s);
            }
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineToXMLObjects(Record in, Record out) throws XUException {
        if (in instanceof IndexedRecord && out instanceof IndexedRecord) {
            IlrXmlObject[] objs;
            for (IlrXmlObject s : objs = this.conn.engineToXMLObjects((List)in)) {
                ((IndexedRecord)out).add((Object)s);
            }
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineInsert(Record input, Record output) throws XUException {
        if (input instanceof IndexedRecord && ((List)input).size() % 2 == 0) {
            this.conn.engineInsert((List)input);
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineInsertWithId(Record input, Record output) throws XUException {
        if (input instanceof IndexedRecord && ((List)input).size() % 3 == 0) {
            this.conn.engineInsertWithId((List)input);
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineRetract(Record input, Record output) throws XUException {
        if (input instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)input;
            this.conn.engineRetract(indexedRecord.toArray());
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineRetractById(Record input, Record output) throws XUException {
        if (input instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)input;
            this.conn.engineRetractById(indexedRecord.toArray());
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineUpdate(Record input, Record output) throws XUException {
        if (input instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)input;
            this.conn.engineUpdate(indexedRecord.toArray());
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineUpdateById(Record input, Record output) throws XUException {
        if (input instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)input;
            this.conn.engineUpdateById(indexedRecord.toArray());
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineInvokeFunction(InteractionSpec spec, Record output) throws XUException {
        if (output instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)output;
            indexedRecord.add(this.conn.engineInvokeFunction(XUInteraction.getRulesetFunctionName(spec), XUInteraction.getRulesetFunctionArguments(spec)));
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineGetWorkingMemory(Record output) throws XUException {
        if (output instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)output;
            indexedRecord.addAll(Arrays.asList(this.conn.engineGetWorkingMemory()));
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineGetWorkingMemoryWithId(Record output) throws XUException {
        if (output instanceof MappedRecord) {
            MappedRecord mappedRecord = (MappedRecord)output;
            mappedRecord.putAll(this.conn.engineGetWorkingMemoryWithId());
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineGetOutput(Record input, Record output) throws XUException {
        if (output instanceof IndexedRecord) {
            IndexedRecord indexedOutput = (IndexedRecord)output;
            indexedOutput.add((Object)this.conn.engineGetOutput());
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean loadUptodateRuleset() throws XUException {
        this.conn.loadUptodateRuleset();
        return true;
    }

    private boolean getRulesetUsageInformation(InteractionSpec spec, Record output) throws XUException {
        String canonicalRulesetPath = XUInteraction.getCanonicalRulesetPath(spec);
        if (output instanceof MappedRecord && canonicalRulesetPath != null) {
            IlrRulesetUsageInformationImpl info = this.conn.getRulesetUsageInformation(canonicalRulesetPath);
            if (info != null) {
                MappedRecord result = (MappedRecord)output;
                info.toMap((Map<String, Object>)result);
            }
            return true;
        }
        throw new XUException("XU.ERROR.10012", new String[]{spec.toString()});
    }

    private boolean startMaintenanceTasks() throws XUException {
        this.conn.startMaintenanceTasks();
        return true;
    }

    private boolean engineReset() throws XUException {
        this.conn.engineReset();
        return true;
    }

    private boolean resetRulesetExecutionTrace(InteractionSpec spec) throws XUException {
        this.conn.resetRulesetExecutionTrace();
        return true;
    }

    private boolean engineRuleflowReset() throws XUException {
        this.conn.engineRuleflowReset();
        return true;
    }

    static String getCanonicalRulesetPath(InteractionSpec spec) throws XUException {
        try {
            if (spec instanceof IlrXUManagementInteractionSpec) {
                return ((IlrXUManagementInteractionSpec)spec).getCanonicalRulesetPath();
            }
            Class<?> clazz = spec.getClass();
            Method method = clazz.getMethod("getCanonicalRulesetPath", new Class[0]);
            return (String)method.invoke((Object)spec, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException("XU.ERROR.10012", new String[]{spec.toString()}, (Throwable)e);
        }
    }

    static Object[] getRulesetFunctionArguments(InteractionSpec spec) throws XUException {
        try {
            Class<?> clazz = spec.getClass();
            Method method = clazz.getMethod("getRulesetFunctionArguments", new Class[0]);
            return (Object[])method.invoke((Object)spec, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException("XU.ERROR.10012", new String[]{spec.toString()}, (Throwable)e);
        }
    }

    static String getRulesetFunctionName(InteractionSpec spec) throws XUException {
        try {
            Class<?> clazz = spec.getClass();
            Method method = clazz.getMethod("getRulesetFunctionName", new Class[0]);
            return (String)method.invoke((Object)spec, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException("XU.ERROR.10012", new String[]{spec.toString()}, (Throwable)e);
        }
    }

    static int getRulesetExecutionInformationFilter(InteractionSpec spec) throws XUException {
        try {
            if (spec instanceof IlrRuleEngineInteractionSpec) {
                return ((IlrRuleEngineInteractionSpec)spec).getRulesetExecutionInformationFilter();
            }
            Class<?> clazz = spec.getClass();
            Method method = clazz.getMethod("getRulesetExecutionInformationFilter", new Class[0]);
            return (Integer)method.invoke((Object)spec, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException("XU.ERROR.10012", new String[]{spec.toString()}, (Throwable)e);
        }
    }

    static String getRulesetPath(InteractionSpec spec) throws XUException {
        try {
            if (spec instanceof IlrXUManagementInteractionSpec) {
                return ((IlrXUManagementInteractionSpec)spec).getRulesetPath();
            }
            Class<?> clazz = spec.getClass();
            Method method = clazz.getMethod("getRulesetPath", new Class[0]);
            return (String)method.invoke((Object)spec, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException("XU.ERROR.10012", new String[]{spec.toString()}, (Throwable)e);
        }
    }

    private static List<String> getBOMParametersExclusionFilters(InteractionSpec spec) throws XUException {
        try {
            if (spec instanceof IlrRuleEngineInteractionSpec) {
                return ((IlrRuleEngineInteractionSpec)spec).getBOMParametersExclusionFilters();
            }
            Class<?> clazz = spec.getClass();
            Method method = clazz.getMethod("getBOMParametersExclusionFilters", new Class[0]);
            return (List)method.invoke((Object)spec, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException("XU.ERROR.10012", new String[]{spec.toString()}, (Throwable)e);
        }
    }

    private static int getBOMParameterKind(InteractionSpec spec) throws XUException {
        try {
            if (spec instanceof IlrRuleEngineInteractionSpec) {
                return ((IlrRuleEngineInteractionSpec)spec).getBOMParameterKind();
            }
            Class<?> clazz = spec.getClass();
            Method method = clazz.getMethod("getBOMParameterKind", new Class[0]);
            return (Integer)method.invoke((Object)spec, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException("XU.ERROR.10012", new String[]{spec.toString()}, (Throwable)e);
        }
    }

    private static byte getParameterDirection(InteractionSpec spec) throws XUException {
        try {
            if (spec instanceof IlrRuleEngineInteractionSpec) {
                return ((IlrRuleEngineInteractionSpec)spec).getParameterDirection();
            }
            Class<?> clazz = spec.getClass();
            Method method = clazz.getMethod("getParameterDirection", new Class[0]);
            return (Byte)method.invoke((Object)spec, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException("XU.ERROR.10012", new String[]{spec.toString()}, (Throwable)e);
        }
    }

    private static RulesetExecutionListener getRulesetExecutionListener(InteractionSpec spec) throws XUException {
        try {
            if (spec instanceof IlrRuleEngineInteractionSpec) {
                return ((IlrRuleEngineInteractionSpec)spec).getRulesetExecutionListener();
            }
            Class<?> clazz = spec.getClass();
            Method method = clazz.getMethod("getRulesetExecutionListener", new Class[0]);
            return (RulesetExecutionListener)method.invoke((Object)spec, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException("XU.ERROR.10012", new String[]{spec.toString()}, (Throwable)e);
        }
    }

    private IlrXUContext getXUContext() {
        return this.conn != null ? this.conn.getContext() : null;
    }

    private boolean engineToNodes(Record in, Record out) throws XUException {
        if (in instanceof IndexedRecord && out instanceof IndexedRecord) {
            List<Object> objs = this.conn.engineToNodes((List)in);
            ((IndexedRecord)out).addAll(objs);
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }

    private boolean engineNodesToXOMObjects(Record in, Record out) throws XUException {
        if (in instanceof IndexedRecord && out instanceof IndexedRecord) {
            List<Object> objs = this.conn.engineNodesToXOMObjects((List)in);
            ((IndexedRecord)out).addAll(objs);
            return true;
        }
        throw new XUException("XU.ERROR.10013");
    }
}

