/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.engine.cre.internal;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.bom.internal.BOMConverter;
import com.ibm.rules.res.xu.bom.internal.DocumentBuilderPool;
import com.ibm.rules.res.xu.bom.internal.TransformerPool;
import com.ibm.rules.res.xu.client.internal.ChannelMessageImpl;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.rules.res.xu.engine.cre.internal.CREBOMConverter;
import com.ibm.rules.res.xu.engine.internal.BaseEngineManager;
import com.ibm.rules.res.xu.engine.xml.internal.XMLObjectService;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetImpl;
import ilog.rules.bres.xu.event.IlrProfilingRuleEngineEvent;
import ilog.rules.bres.xu.profiling.IlrProfilingHelper;
import ilog.rules.engine.IlrContext;
import ilog.rules.engine.IlrNoSuchFunctionException;
import ilog.rules.engine.IlrNotifyChannelHandler;
import ilog.rules.engine.IlrParameterMap;
import ilog.rules.engine.IlrTool;
import ilog.rules.engine.IlrToolConnectionException;
import ilog.rules.engine.IlrUserRuntimeException;
import ilog.rules.factory.IlrReflectListener;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.xu.event.internal.IlrRuleEngineEventImpl;
import ilog.rules.res.xu.ruleset.trace.internal.IlrCRERulesetExecutionTraceTool;
import ilog.rules.res.xu.ruleset.trace.internal.IlrRulesetExecutionTraceTool;
import ilog.rules.res.xu.spi.IlrManagedConnectionContext;
import ilog.rules.res.xu.spi.IlrManagedXUConnection;
import ilog.rules.res.xu.spi.IlrRuleEngineEventHandler;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CREManager
extends BaseEngineManager
implements IlrNotifyChannelHandler {
    private IlrContext context;
    private IlrRuleEngineEventHandler evtHandler;
    private transient DocumentBuilderPool bomPool;
    private transient TransformerPool trFactoryPool;

    public CREManager(XURulesetImpl executableRuleset, IlrContext context, IlrManagedXUConnection connection, DocumentBuilderPool bomPool, TransformerPool trFactoryPool) {
        super(executableRuleset, connection);
        this.context = context;
        this.bomPool = bomPool;
        this.trFactoryPool = trFactoryPool;
        context.addNotifyChannelHandler((IlrNotifyChannelHandler)this);
        context.out = new PrintWriter(this.engineOutputWriter);
    }

    public final IlrManagedConnectionContext getContext() {
        return this.xuContext;
    }

    public final IlrContext getCREEngine() {
        return this.context;
    }

    @Override
    public final void start(IlrManagedConnectionContext xuContext) throws XUException {
        super.start(xuContext);
        IlrRulesetArchiveProperties props = this.getRuleset().getRulesetArchiveProperties();
        if (this.isFinestLoggable) {
            this.finest(".start: debugger activation: " + props.isDebugEnabled());
            this.finest(".start: trace enabled: " + props.isTraceEnabled());
        }
        if (props.isDebugEnabled()) {
            if (this.isFinestLoggable) {
                this.finest(".start: debugger activation");
            }
            this.context.setDebuggerActivation(true);
        }
        this.context.initForPool();
    }

    @Override
    public final void enableEngineTrace() throws XUException {
        super.enableEngineTrace();
        try {
            IlrPath path = IlrPath.parsePath(this.getRuleset().getCanonicalRulesetPath());
            this.evtHandler = new IlrRuleEngineEventHandler(this.context, path, this.evtDispatcher, this.xuContext, this);
            this.evtHandler.setToolId(this.context.connectTool((IlrTool)this.evtHandler));
        }
        catch (IlrToolConnectionException e) {
            throw new XUException("XU.ERROR.10041", null, (Throwable)e);
        }
        catch (IlrFormatException e) {
            throw new XUException("XU.ERROR.10041", null, (Throwable)e);
        }
    }

    @Override
    public final synchronized void performExecute(Map<String, Object> outParams) throws XUException {
        IlrProfilingHelper profiling = this.connection.getProfiling();
        String path = this.getRuleset().getCanonicalRulesetPath();
        IlrProfilingRuleEngineEvent evt = profiling.startRuleEngineMeasure(1, this.context, path, true, this.xuContext);
        try {
            Map<String, Object> params = this.toMap(this.context.execute());
            XMLObjectService xmlSrv = this.executableRuleset.getXMLObjectService();
            Map<String, Object> result = xmlSrv.toMap(params);
            profiling.stopRuleEngineMeasure(evt);
            profiling.sendRuleEngineEvent(evt);
            outParams.putAll(result);
        }
        catch (InterruptedException e) {
            throw new XUException("XU.ERROR.10403", null, (Throwable)e);
        }
        catch (IlrUserRuntimeException e) {
            throw new XUException("XU.ERROR.10411", null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, Object> getXOMParameters(byte dir) throws XUException {
        if (this.isFinestLoggable) {
            this.finest(".getXOMParameters: dir=" + dir);
        }
        IlrContext ilrContext = this.context;
        synchronized (ilrContext) {
            XURulesetParameter[] sig = this.executableRuleset.getRulesetParameters();
            HashMap<String, Object> result = new HashMap<String, Object>(sig.length);
            for (XURulesetParameter p : sig) {
                byte sdir = p.getDirection();
                if (sdir != 4 && (dir & sdir) <= 0) continue;
                String name = p.getName();
                result.put(name, this.context.getParameterValue(name));
            }
            if (this.isFinestLoggable) {
                this.finest(".getXOMParameters: result.size=" + result.size());
                this.finest(".getXOMParameters: result=" + result);
            }
            return result;
        }
    }

    private void finest(String msg) {
        this.finest(this.getClass(), msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Object executeMain(Object param) throws XUException {
        try {
            Object result;
            IlrProfilingRuleEngineEvent evt;
            IlrProfilingHelper profiling = this.connection.getProfiling();
            IlrContext ilrContext = this.context;
            synchronized (ilrContext) {
                evt = profiling.startRuleEngineMeasure(3, this.context, this.getRuleset().getCanonicalRulesetPath(), true, this.xuContext);
                result = this.context.executeMain(param);
                profiling.stopRuleEngineMeasure(evt);
            }
            profiling.sendRuleEngineEvent(evt);
            return result;
        }
        catch (IlrNoSuchFunctionException e) {
            throw new XUException("XU.ERROR.10016", null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final synchronized void performExecuteTask(String taskName, Map<String, Object> outParams) throws XUException {
        try {
            IlrProfilingRuleEngineEvent evt;
            IlrProfilingHelper profiling = this.connection.getProfiling();
            String path = this.getRuleset().getCanonicalRulesetPath();
            XMLObjectService xmlSrv = this.executableRuleset.getXMLObjectService();
            IlrContext ilrContext = this.context;
            synchronized (ilrContext) {
                evt = profiling.startRuleEngineMeasure(4, this.context, path, true, this.xuContext);
                Map<String, Object> params = this.toMap(this.context.execute(taskName));
                Map<String, Object> result = xmlSrv.toMap(params);
                outParams.putAll(result);
                profiling.stopRuleEngineMeasure(evt);
            }
            profiling.sendRuleEngineEvent(evt);
        }
        catch (InterruptedException e) {
            throw new XUException("XU.ERROR.10403", (String[])null, (Throwable)e);
        }
    }

    @Override
    protected final BOMConverter createDefaultBOMConverter() throws XUException {
        return CREBOMConverter.createBOMConverter(this.context, this.bomPool, this.trFactoryPool, this.logger);
    }

    @Override
    public final void setParameters(Map<String, Object> parameters) throws XUException {
        IlrProfilingHelper profiling = this.connection.getProfiling();
        IlrProfilingRuleEngineEvent evt = profiling.startRuleEngineMeasure(8, this.context, this.getRuleset().getCanonicalRulesetPath(), false, this.xuContext);
        super.setParameters(parameters);
        profiling.stopRuleEngineMeasure(evt);
        profiling.sendRuleEngineEvent(evt);
    }

    @Override
    protected final void setXOMParameters(Map<String, Object> params) throws XUException {
        if (this.isFinestLoggable) {
            this.finest(".setXOMParameters: " + params);
        }
        this.context.setParameters(new IlrParameterMap(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void insert(List<Object> objects) throws XUException {
        IlrProfilingRuleEngineEvent evt;
        IlrProfilingHelper profiling = this.connection.getProfiling();
        String path = this.getRuleset().getCanonicalRulesetPath();
        IlrContext ilrContext = this.context;
        synchronized (ilrContext) {
            evt = profiling.startRuleEngineMeasure(5, this.context, path, false, this.xuContext);
            Iterator<Object> it = objects.iterator();
            while (it.hasNext()) {
                this.insertObject(null, (Integer)it.next(), it.next());
            }
            profiling.stopRuleEngineMeasure(evt);
        }
        profiling.sendRuleEngineEvent(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void insertWithId(List<Object> list) throws XUException {
        IlrProfilingRuleEngineEvent evt;
        IlrProfilingHelper profiling = this.connection.getProfiling();
        String path = this.getRuleset().getCanonicalRulesetPath();
        IlrContext ilrContext = this.context;
        synchronized (ilrContext) {
            evt = profiling.startRuleEngineMeasure(5, this.context, path, false, this.xuContext);
            Iterator<Object> it = list.iterator();
            while (it.hasNext()) {
                this.insertObject(it.next(), (Integer)it.next(), it.next());
            }
            profiling.stopRuleEngineMeasure(evt);
        }
        profiling.sendRuleEngineEvent(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void retract(Object[] objects) throws XUException {
        IlrProfilingRuleEngineEvent evt;
        IlrProfilingHelper profiling = this.connection.getProfiling();
        String path = this.getRuleset().getCanonicalRulesetPath();
        IlrContext ilrContext = this.context;
        synchronized (ilrContext) {
            evt = profiling.startRuleEngineMeasure(6, this.context, path, false, this.xuContext);
            for (Object o : objects) {
                this.retract(o);
            }
            profiling.stopRuleEngineMeasure(evt);
        }
        profiling.sendRuleEngineEvent(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void retractById(Object[] ids) throws XUException {
        IlrProfilingRuleEngineEvent evt;
        IlrProfilingHelper profiling = this.connection.getProfiling();
        String path = this.getRuleset().getCanonicalRulesetPath();
        IlrContext ilrContext = this.context;
        synchronized (ilrContext) {
            evt = profiling.startRuleEngineMeasure(6, this.context, path, false, this.xuContext);
            Map map = this.assertedObjects;
            synchronized (map) {
                for (Object id : ids) {
                    Object o = this.assertedObjects.get(id);
                    if (this.isFinestLoggable) {
                        this.logger.finest("CREManager: retract id=" + id + ", object=" + o + ", all objects=" + this.assertedObjects);
                    }
                    this.retract(o);
                    this.assertedObjects.remove(id);
                }
            }
            profiling.stopRuleEngineMeasure(evt);
        }
        profiling.sendRuleEngineEvent(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void update(Object[] objects) {
        IlrProfilingRuleEngineEvent evt;
        String path = this.getRuleset().getCanonicalRulesetPath();
        IlrProfilingHelper profiling = this.connection.getProfiling();
        IlrContext ilrContext = this.context;
        synchronized (ilrContext) {
            evt = profiling.startRuleEngineMeasure(7, this.context, path, false, this.xuContext);
            for (Object o : objects) {
                this.update(o);
            }
            profiling.stopRuleEngineMeasure(evt);
        }
        profiling.sendRuleEngineEvent(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateById(Object[] ids) {
        IlrProfilingRuleEngineEvent evt;
        IlrProfilingHelper profiling = this.connection.getProfiling();
        String path = this.getRuleset().getCanonicalRulesetPath();
        IlrContext ilrContext = this.context;
        synchronized (ilrContext) {
            evt = profiling.startRuleEngineMeasure(7, this.context, path, false, this.xuContext);
            Map map = this.assertedObjects;
            synchronized (map) {
                for (Object id : ids) {
                    this.update(this.assertedObjects.get(id));
                }
            }
            profiling.stopRuleEngineMeasure(evt);
        }
        profiling.sendRuleEngineEvent(evt);
    }

    @Override
    public final void reset() {
        if (this.isFinestLoggable) {
            this.finest(".reset(): " + this.context);
        }
        this.context.resetForPool();
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void resetRuleflow() throws XUException {
        if (this.isFinestLoggable) {
            this.finest(".resetRuleflow()");
        }
        IlrContext ilrContext = this.context;
        synchronized (ilrContext) {
            this.context.resetRuleflow();
        }
    }

    @Override
    public final void cleanup() {
        IlrRuleEngineEventImpl evt;
        if (this.engineTraceEnabled) {
            evt = new IlrRuleEngineEventImpl(24, this.context, new Object[0], this.getRuleset().getCanonicalRulesetPath(), this.xuContext);
            this.evtDispatcher.ruleEngineEventRaised(evt);
        }
        if (this.evtHandler != null || this.getRuleset().getRulesetArchiveProperties().isDebugEnabled() || this.rulesetExecutionTraceEnabled) {
            this.context.disconnectTools();
            this.context.removeNotifyChannelHandler((IlrNotifyChannelHandler)((IlrCRERulesetExecutionTraceTool)this.rulesetExecutionTool));
            this.context.setDebuggerActivation(false);
            this.evtHandler = null;
            this.rulesetExecutionTool = null;
        }
        super.cleanup();
        if (this.engineTraceEnabled) {
            evt = new IlrRuleEngineEventImpl(25, this.context, new Object[0], this.getRuleset().getCanonicalRulesetPath(), this.xuContext);
            this.evtDispatcher.ruleEngineEventRaised(evt);
        }
    }

    @Override
    public final void destroy() {
        if (this.isFinestLoggable) {
            if (this.context == null) {
                this.finest(".destroy(): engine has already been destroyed: " + this);
            } else {
                this.finest(".destroy(): " + this);
            }
        }
        this.destroy(this.context);
        this.context = null;
        super.destroy();
    }

    private void destroy(IlrContext context) {
        this.evtHandler = null;
        context.disconnectTools();
        context.setDebuggerActivation(false);
        context.getRuleset().getReflect().removeListener((IlrReflectListener)context.eventDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object[] getWorkingMemory() {
        IlrContext ilrContext = this.context;
        synchronized (ilrContext) {
            return this.context.getObjects(Object.class, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getFiredRulesCount() {
        IlrContext ilrContext = this.context;
        synchronized (ilrContext) {
            return this.context.getFiredRulesCount();
        }
    }

    @Override
    protected final void insertObject(Object object) {
        this.context.insert(object);
    }

    @Override
    public final void retract(Object object) throws XUException {
        if (this.isFinestLoggable) {
            this.finest(".retract(): " + object);
        }
        this.context.retract(object);
    }

    @Override
    public final void update(Object object) {
        this.context.update(object);
    }

    private Map<String, Object> toMap(IlrParameterMap map) {
        Map result = map.getMap();
        result.remove("ilog.rules.firedRulesCount");
        return result;
    }

    @Override
    protected final IlrRulesetExecutionTraceTool createRulesetExecutionTraceTool(LogHandler logger) {
        return new IlrCRERulesetExecutionTraceTool(logger, this.getRuleset().getRules(), this.getRuleset().getTasks());
    }

    @Override
    protected final void connectRulesetExecutionTraceTool(IlrRulesetExecutionTraceTool tool) throws XUException {
        try {
            IlrContext ctx = this.getCREEngine();
            ctx.connectTool((IlrTool)((IlrCRERulesetExecutionTraceTool)tool));
            ctx.addNotifyChannelHandler((IlrNotifyChannelHandler)((IlrCRERulesetExecutionTraceTool)tool));
        }
        catch (IlrToolConnectionException e) {
            XUException ex = new XUException("XU.ERROR.10412", null, (Throwable)e);
            throw ex;
        }
    }

    public final void notifyChannel(IlrContext context, Object message, String channel) {
        ChannelMessageImpl msg = new ChannelMessageImpl(channel, (Serializable)message);
        this.channelMessageEmitted(this, msg);
    }

    @Override
    public final Object invokeFunction(String name, Object[] objects) throws XUException {
        IlrContext ilrContext = this.context;
        synchronized (ilrContext) {
            try {
                return this.context.invokeFunction(name, objects);
            }
            catch (IlrNoSuchFunctionException e) {
                throw new XUException(XUMessageCode.ERROR_INVOKE_FUNCTION, new String[]{name}, (Throwable)e);
            }
        }
    }
}

