/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.engine.cre.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.xu.engine.cre.internal.RulesetParseException;
import com.ibm.rules.res.xu.log.internal.XULogRecordFactory;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.engine.IlrRuleset;
import ilog.rules.engine.IlrRulesetArchiveParser;
import ilog.rules.factory.IlrReflect;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.util.engine.IlrRulesetOptimConfig;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RulesetParser {
    public static IlrRuleset parseArchive(String canonicalPath, IlrRuleset ruleset, IlrRulesetArchiveProperties rulesetProps, IlrReflect reflect, ClassLoader xomCL, IlrRulesetArchive archiveLoader, Collection<String> warnings, Logger log) throws RulesetParseException {
        boolean result;
        if (log != null && log.isLoggable(Level.FINEST)) {
            log.log(new XUSourceLogRecord(Level.FINEST, "ruleset " + canonicalPath + " is business: " + archiveLoader.isBusiness(), new Object[0]));
            log.log(new XUSourceLogRecord(Level.FINEST, "BOM support enabled: " + rulesetProps.isBOMSupportEnabled(), new Object[0]));
        }
        if (rulesetProps.isBOMSupportEnabled()) {
            archiveLoader.setBusinessDataXmlServiceEnable(true);
        }
        IlrRulesetArchiveParser parser = new IlrRulesetArchiveParser();
        parser.setRuleset(ruleset);
        if (reflect != null) {
            parser.setExecutionReflect(reflect);
        }
        if (log != null && log.isLoggable(Level.INFO)) {
            log.log(XULogRecordFactory.createXULogRecord(Level.INFO, "XU.FINE.5100", null, new Object[]{canonicalPath, rulesetProps}, null));
        }
        if (!(result = parser.parseArchive(archiveLoader))) {
            if (log != null && log.isLoggable(Level.INFO)) {
                log.log(XULogRecordFactory.createXULogRecord(Level.INFO, "XU.FINE.5102", null, new String[]{canonicalPath, Boolean.toString(result)}, null));
            }
            throw RulesetParser.createRulesetParseException(canonicalPath, parser.getErrors());
        }
        if (log != null && log.isLoggable(Level.INFO)) {
            log.log(XULogRecordFactory.createXULogRecord(Level.INFO, "XU.FINE.5101", null, new String[]{canonicalPath, Boolean.toString(result)}, null));
        }
        if (rulesetProps.isOptimizationEnabled()) {
            RulesetParser.optimizeRuleset(ruleset, rulesetProps);
        }
        String[] warningStrs = parser.getWarnings();
        for (int i = 0; i < warningStrs.length; ++i) {
            warnings.add(warningStrs[i]);
        }
        return ruleset;
    }

    private static void optimizeRuleset(IlrRuleset ruleset, IlrRulesetArchiveProperties props) {
        String[] names = IlrRulesetOptimConfig.getAttributeNames();
        Properties optimProps = new Properties();
        for (String name : names) {
            String value = (String)props.get(name);
            if (value == null) continue;
            optimProps.put(name, value);
        }
        ruleset.optimize(IlrRulesetOptimConfig.createConfiguration(optimProps));
    }

    private static RulesetParseException createRulesetParseException(String rulesetPath, String[] errors) {
        StringBuffer errorMessage = new StringBuffer();
        for (int i = 0; i < errors.length; ++i) {
            if (i > 0) {
                errorMessage.append('\n');
            }
            errorMessage.append(errors[i]);
        }
        return new RulesetParseException("XU.ERROR.10014", new String[]{rulesetPath, errorMessage.toString()});
    }
}

