/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.engine.de.internal;

import com.ibm.rules.engine.runtime.Engine;
import com.ibm.rules.engine.runtime.dataio.BusinessDataXmlService;
import com.ibm.rules.res.xu.bom.internal.BOMConverter;
import com.ibm.rules.res.xu.bom.internal.BOMConverterBase;
import com.ibm.rules.res.xu.client.internal.XUWarningListener;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import ilog.rules.util.issue.IlrErrorException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public final class DEBOMConverter
extends BOMConverterBase {
    private BusinessDataXmlService service;
    private final Engine engine;

    private DEBOMConverter(LogHandler log, Engine engine) {
        super(log);
        this.engine = engine;
    }

    public static final BOMConverter createBOMConverter(Engine engine, LogHandler log) throws XUException {
        return new DEBOMConverter(log, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String toBOM(String name, Object o, List<String> filters, boolean includeROFields, BOMConverter.ObjectKind kind, XUWarningListener l) throws XUException {
        if (kind != BOMConverter.ObjectKind.KIND_XML) {
            throw new UnsupportedOperationException();
        }
        BusinessDataXmlService srv = this.getBusinessDataXmlService();
        StringWriter writer = new StringWriter();
        try {
            Object object = srv;
            synchronized (object) {
                srv.write(o, (Writer)writer, includeROFields);
                DEBOMConverter.fireWarnings(srv.getWarnings(), l);
            }
            object = writer.toString();
            return object;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object toXOM(String name, String bomString, BOMConverter.ObjectKind kind, XUWarningListener l) throws XUException {
        if (kind != BOMConverter.ObjectKind.KIND_XML) {
            throw new UnsupportedOperationException();
        }
        BusinessDataXmlService srv = this.getBusinessDataXmlService();
        StringReader reader = null;
        try {
            Object ret;
            reader = new StringReader(bomString);
            Object object = srv;
            synchronized (object) {
                ret = srv.read((Reader)reader, "bomParameter");
                DEBOMConverter.fireWarnings(srv.getWarnings(), l);
            }
            object = ret;
            return object;
        }
        catch (IlrErrorException e) {
            throw new XUException("XU.ERROR.10400", new String[]{name}, (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized BusinessDataXmlService getBusinessDataXmlService() throws XUException {
        if (this.service == null) {
            Class<BusinessDataXmlService> c;
            Class<BusinessDataXmlService> clazz = c = BusinessDataXmlService.class;
            synchronized (clazz) {
                this.service = (BusinessDataXmlService)this.engine.getService(c);
                if (this.service == null) {
                    throw new XUException("XU.ERROR.10409", null, null);
                }
            }
        }
        return this.service;
    }
}

