/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.engine.de.internal;

import com.ibm.rules.engine.migration.classdriver.runtime.XmlBindingService;
import com.ibm.rules.engine.ruledef.runtime.Rule;
import com.ibm.rules.engine.ruledef.runtime.RuleInstance;
import com.ibm.rules.engine.ruleflow.runtime.ExecutionNameTask;
import com.ibm.rules.engine.ruleflow.runtime.Task;
import com.ibm.rules.engine.runtime.EngineDefinition;
import com.ibm.rules.engine.runtime.EngineSignature;
import com.ibm.rules.engine.runtime.InoutModifier;
import com.ibm.rules.engine.runtime.impl.EngineSignatureImpl;
import com.ibm.rules.engine.util.CustomProperties;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.bom.IlrObjectModel;
import ilog.rules.bom.IlrType;
import ilog.rules.bom.serializer.IlrSyntaxError;
import ilog.rules.factory.IlrReflect;
import ilog.rules.util.IlrIdConverter;
import ilog.rules.xml.IlrXmlObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class DEEngine {
    public static IlrType getXMLType(EngineSignature.Parameter p, EngineDefinition def) {
        IlrReflect xom = ((XmlBindingService)def.getService(XmlBindingService.class)).getXOM();
        String name = ((EngineSignatureImpl.ParameterImpl)p).getXmlParameterTypeName();
        return xom.getType(name);
    }

    public static byte getDir(EngineSignature.Parameter p) {
        if (p.getModifier().equals((Object)InoutModifier.IN)) {
            return 1;
        }
        if (p.getModifier().equals((Object)InoutModifier.OUT)) {
            return 2;
        }
        if (p.getModifier().equals((Object)InoutModifier.INOUT)) {
            return 4;
        }
        return 0;
    }

    public static byte getKind(EngineSignature.Parameter p) {
        String typeName = p.getParameterTypeName();
        if (typeName.equals(IlrXmlObject.class.getName())) {
            return 1;
        }
        return 0;
    }

    public static String getXMLTypeAsString(EngineSignature.Parameter p, EngineDefinition def) {
        return DEEngine.getXMLType(p, def).getFullyQualifiedName();
    }

    public static String toTechnicalName(Task task) {
        if (task instanceof ExecutionNameTask) {
            return ((ExecutionNameTask)task).getExecutionTaskName();
        }
        return IlrIdConverter.getEngineIdentifier(task.getName());
    }

    public static final String toTechnicalName(RuleInstance instance) {
        CustomProperties props = instance.getRule().getProperties();
        String ruleName = (String)props.get("ruleExecutionName");
        if (ruleName == null) {
            ruleName = IlrIdConverter.getEngineIdentifier(instance.getRuleName());
        }
        if (DEEngine.isDTRule(props)) {
            StringBuffer result = new StringBuffer(ruleName);
            String actionName = instance.getRuleAction().getName();
            if (actionName == null || actionName.isEmpty()) {
                throw new IllegalArgumentException();
            }
            long dtLine = Long.parseLong(actionName);
            result.append('_');
            result.append(dtLine - 1L);
            return result.toString();
        }
        return ruleName;
    }

    public static final boolean isDTRule(RuleInstance rule) {
        return DEEngine.isDTRule(rule.getRule());
    }

    public static final boolean isDTRule(Rule rule) {
        return DEEngine.isDTRule(rule.getProperties());
    }

    public static final boolean isDTRule(CustomProperties props) {
        String v = (String)props.get("ilog.rules.dt");
        return v != null && !v.isEmpty();
    }

    public static IlrReflect getBOMReflect(EngineDefinition engineDefinition) throws XUException {
        ClassLoader classLoader = engineDefinition.getClass().getClassLoader();
        InputStream bStream = classLoader.getResourceAsStream("com.ibm.ia.engine.bom");
        if (bStream == null) {
            throw new XUException(XUMessageCode.ERROR_NO_BOM_REFLECT);
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(bStream, "UTF-8");
            IlrReflect bReflect = new IlrReflect(IlrObjectModel.Kind.BUSINESS);
            bReflect.loadPath(new Reader[]{reader});
            IlrReflect ilrReflect = bReflect;
            return ilrReflect;
        }
        catch (IOException e) {
            throw new XUException(XUMessageCode.ERROR_BOM_REFLECT_CREATION, e);
        }
        catch (IlrSyntaxError e) {
            throw new XUException(XUMessageCode.ERROR_BOM_REFLECT_CREATION, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (bStream != null) {
                try {
                    bStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

