/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.engine.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.security.internal.SystemPropertiesPrivilegedAction;
import com.ibm.rules.res.xu.bom.internal.BOMConverter;
import com.ibm.rules.res.xu.client.internal.ChannelMessage;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.rules.res.xu.client.internal.XUWarningListener;
import com.ibm.rules.res.xu.engine.internal.AuthorizationProvider;
import com.ibm.rules.res.xu.engine.internal.ChannelMessageListener;
import com.ibm.rules.res.xu.engine.internal.EngineListener;
import com.ibm.rules.res.xu.engine.internal.EngineManager;
import com.ibm.rules.res.xu.engine.internal.EngineManagerListener;
import com.ibm.rules.res.xu.event.RuleEvent;
import com.ibm.rules.res.xu.event.TaskEvent;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetImpl;
import com.ibm.rules.res.xu.util.internal.WeakMap;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.session.ruleset.IlrRuleInformation;
import ilog.rules.res.session.ruleset.IlrTaskInformation;
import ilog.rules.res.xu.cci.IlrConnectionId;
import ilog.rules.res.xu.cci.ruleset.IlrRulesetExecutionTrace;
import ilog.rules.res.xu.cci.ruleset.impl.IlrRulesetExecutionTraceImpl;
import ilog.rules.res.xu.event.internal.IlrRuleEngineEventImpl;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationImpl;
import ilog.rules.res.xu.ruleset.trace.internal.IlrRulesetExecutionTraceTool;
import ilog.rules.res.xu.spi.IlrManagedConnectionContext;
import ilog.rules.res.xu.spi.IlrManagedXUConnection;
import ilog.rules.xml.IlrXmlErrorException;
import ilog.rules.xml.IlrXmlObject;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;

public abstract class BaseEngineManager
implements EngineManager,
ChannelMessageListener,
EngineListener {
    protected LogHandler logger;
    protected boolean uptodate = true;
    protected byte state = 1;
    protected XURulesetImpl executableRuleset;
    protected IlrManagedConnectionContext xuContext;
    protected boolean engineTraceEnabled = false;
    protected IlrXUEventDispatcher evtDispatcher;
    protected IlrManagedXUConnection connection;
    protected boolean rulesetExecutionTraceEnabled = false;
    protected int rulesetExecutionTraceFilter = 0;
    protected IlrRulesetExecutionTraceTool rulesetExecutionTool;
    protected Map<String, String> rulesetExecutionTraceFilterProperties;
    protected final StringWriter engineOutputWriter = new StringWriter();
    protected boolean isFinestLoggable = false;
    protected BOMConverter bomConverter;
    protected List<ChannelMessage> channelMsgs = new ArrayList<ChannelMessage>();
    protected List<EngineManagerListener> listeners = new ArrayList<EngineManagerListener>();
    protected List<ChannelMessageListener> channelListeners = new ArrayList<ChannelMessageListener>();
    protected List<EngineListener> engineListeners = new ArrayList<EngineListener>();
    protected final IlrPath canonicalRulesetPath;
    protected AuthorizationProvider authProvider;
    private final IlrRulesetUsageInformationImpl rulesetUsageInformation;
    protected Map<Object, Object> assertedObjects = new WeakMap<Object, Object>();

    public BaseEngineManager(XURulesetImpl ruleset, IlrManagedXUConnection connection) {
        this.executableRuleset = ruleset;
        this.setManagedConnection(connection);
        try {
            this.canonicalRulesetPath = IlrPath.parsePath(ruleset.getCanonicalRulesetPath());
        }
        catch (IlrFormatException e) {
            throw new IllegalArgumentException(e);
        }
        this.rulesetUsageInformation = ruleset.getRulesetUsageInformation();
    }

    @Override
    public IlrRulesetUsageInformationImpl getRulesetUsageInformation() {
        return this.rulesetUsageInformation;
    }

    @Override
    public IlrPath getCanonicalRulesetPath() {
        return this.canonicalRulesetPath;
    }

    @Override
    public final XURulesetParameter[] getRulesetParameters() {
        return this.getRuleset().getRulesetParameters();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized BOMConverter getBOMConverter() throws XUException {
        if (this.bomConverter == null) {
            String propReuse;
            IlrRulesetArchiveProperties props = this.executableRuleset.getRulesetArchiveProperties();
            BOMConverter conv = this.createBOMConverter(props);
            if (this.isFinestLoggable) {
                this.logger.log(new XUSourceLogRecord(Level.FINEST, BOMConverter.class.getSimpleName() + " has been created.", new Object[0]));
            }
            if ((propReuse = (String)props.get("ruleset.bom.converter.reuse")) != null && !Boolean.parseBoolean(propReuse)) return conv;
            this.bomConverter = conv;
            return this.bomConverter;
        } else {
            if (!this.isFinestLoggable) return this.bomConverter;
            this.logger.log(new XUSourceLogRecord(Level.FINEST, BOMConverter.class.getSimpleName() + " has been reused.", new Object[0]));
        }
        return this.bomConverter;
    }

    private BOMConverter createBOMConverter(IlrRulesetArchiveProperties rulesetProps) throws XUException {
        String str = (String)rulesetProps.get("ruleset.bom.converter.class");
        if (str != null && !str.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(str);
                return (BOMConverter)clazz.newInstance();
            }
            catch (Exception e) {
                throw new XUException(XUMessageCode.ERROR_BOM_CONVERTER_CREATION_ERROR, null, (Throwable)e);
            }
        }
        return this.createDefaultBOMConverter();
    }

    protected abstract BOMConverter createDefaultBOMConverter() throws XUException;

    @Override
    public synchronized void resetRulesetExecutionTrace() {
        if (this.rulesetExecutionTraceEnabled && this.rulesetExecutionTool != null) {
            this.rulesetExecutionTool.reset();
        }
    }

    protected abstract IlrRulesetExecutionTraceTool createRulesetExecutionTraceTool(LogHandler var1);

    protected abstract void connectRulesetExecutionTraceTool(IlrRulesetExecutionTraceTool var1) throws XUException;

    @Override
    public synchronized void enableRulesetExecutionTrace(int filter, Map<String, String> props) throws XUException {
        this.rulesetExecutionTraceEnabled = true;
        this.rulesetExecutionTraceFilter = filter;
        this.rulesetExecutionTraceFilterProperties = props;
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord.Entry(filter, props));
        }
        if (this.rulesetExecutionTool == null) {
            this.rulesetExecutionTool = this.createRulesetExecutionTraceTool(this.logger);
            this.rulesetExecutionTool.setFilter(filter, props);
            this.connectRulesetExecutionTraceTool(this.rulesetExecutionTool);
        } else {
            this.rulesetExecutionTool.setFilter(filter, props);
        }
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord.Exit());
        }
    }

    @Override
    public void reset() {
        this.resetRulesetExecutionTrace();
    }

    @Override
    public synchronized IlrRulesetExecutionTrace getRulesetExecutionTrace() throws XUException {
        Set<String> tasksNotExecuted;
        Set<IlrRuleInformation> rulesNotFired;
        Map<String, IlrRuleInformation> allRuleInfos;
        if (this.rulesetExecutionTool == null) {
            throw new XUException("XU.ERROR.10410", null, null);
        }
        IlrRulesetExecutionTraceImpl trace = new IlrRulesetExecutionTraceImpl();
        int filter = this.rulesetExecutionTraceFilter;
        BaseEngineManager mgr = this;
        if ((0x400 & filter) > 0) {
            trace.setTotalRulesFired(this.rulesetExecutionTool.getTotalRulesFired());
        }
        if ((0x10 & filter) > 0 || (0x40 & filter) > 0) {
            allRuleInfos = mgr.getRuleset().getRules();
            rulesNotFired = this.rulesetExecutionTool.getRulesNotFired(allRuleInfos);
            if ((0x10 & filter) > 0) {
                trace.setTotalRulesNotFired(rulesNotFired.size());
            }
            if ((0x40 & filter) > 0) {
                trace.setRulesNotFired(rulesNotFired);
            }
        } else {
            allRuleInfos = null;
            rulesNotFired = null;
        }
        if ((1 & filter) > 0) {
            trace.setTotalTasksExecuted(this.rulesetExecutionTool.getNumberOfTasksExecuted());
        }
        if ((0x20 & filter) > 0 || (0x80 & filter) > 0) {
            tasksNotExecuted = this.rulesetExecutionTool.getTasksNotExecuted(mgr.getRuleset());
            if ((0x20 & filter) > 0) {
                trace.setTotalTasksNotExecuted(tasksNotExecuted.size());
            }
            if ((0x80 & filter) > 0) {
                trace.setTasksNotExecuted(tasksNotExecuted);
            }
        } else {
            tasksNotExecuted = null;
        }
        if ((0x200 & filter) > 0) {
            trace.setWorkingMemory(this.rulesetExecutionTool.getWorkingMemory(mgr));
        }
        if ((4 & filter) > 0) {
            if (allRuleInfos == null) {
                allRuleInfos = mgr.getRuleset().getRules();
            }
            trace.setAllRules(allRuleInfos);
        }
        if ((8 & filter) > 0) {
            trace.setAllTasks(mgr.getRuleset().getTasks());
        }
        if ((2 & filter) > 0) {
            trace.setExecutionEvents(this.rulesetExecutionTool.getExecutionEvents());
        }
        if ((0x800 & filter) > 0) {
            if (allRuleInfos == null) {
                allRuleInfos = mgr.getRuleset().getRules();
            }
            HashMap<String, IlrRuleInformation> ruleInfos = new HashMap<String, IlrRuleInformation>();
            if ((0x40 & filter) > 0) {
                for (IlrRuleInformation rInfo : rulesNotFired) {
                    ruleInfos.put(rInfo.getName(), rInfo);
                }
            }
            if ((2 & filter) > 0) {
                Set<String> firedRules = this.rulesetExecutionTool.getFiredRules();
                for (String n : firedRules) {
                    ruleInfos.put(n, allRuleInfos.get(n));
                }
            }
            trace.setRuleInformations(ruleInfos);
        }
        if ((0x1000 & filter) > 0) {
            Map<String, IlrTaskInformation> rulesetTaskInfos = mgr.getRuleset().getTasks();
            HashMap<String, IlrTaskInformation> taskInfos = new HashMap<String, IlrTaskInformation>();
            if ((2 & filter) > 0) {
                Set<String> taskNames = this.rulesetExecutionTool.getTasksExecuted();
                for (String n : taskNames) {
                    taskInfos.put(n, rulesetTaskInfos.get(n));
                }
            }
            if ((0x80 & filter) > 0) {
                for (String n : tasksNotExecuted) {
                    taskInfos.put(n, rulesetTaskInfos.get(n));
                }
            }
            trace.setTaskInformations(taskInfos);
        }
        if ((0x2000 & filter) > 0) {
            trace.setSystemProperties(SystemPropertiesPrivilegedAction.getProperties());
        }
        if ((0x4000 & filter) > 0) {
            try {
                trace.setInetAddress(InetAddress.getLocalHost());
            }
            catch (UnknownHostException e) {
                throw new XUException(XUMessageCode.ERROR_FAILED_DNS_LOOKUP, new String[]{"localhost"}, (Throwable)e);
            }
        }
        if ((0x8000 & filter) > 0) {
            trace.setMessages(this.rulesetExecutionTool.getMessages());
        }
        return trace;
    }

    @Override
    public void enableEngineTrace() throws XUException {
        this.engineTraceEnabled = true;
    }

    protected abstract void setXOMParameters(Map<String, Object> var1) throws XUException;

    protected final void finest(Class<?> clazz, String msg) {
        if (this.isFinestLoggable) {
            this.logger.finest(clazz + msg);
        }
    }

    @Override
    public synchronized void setParameters(Map<String, Object> parameters) throws XUException {
        long startTime = this.listeners.isEmpty() ? 0L : System.nanoTime();
        try {
            if (this.isFinestLoggable) {
                this.logger.log(new XUSourceLogRecord(Level.FINEST, "Converting XML objects.", new Object[0]));
            }
            Map<String, Object> params = this.executableRuleset.getXMLObjectService().toParameterMap(parameters, this.xuContext);
            if (this.isFinestLoggable) {
                this.logger.log(new XUSourceLogRecord(Level.FINEST, "XML objects conversion done.", new Object[0]));
            }
            this.setXOMParameters(params);
            if (this.isFinestLoggable) {
                this.logger.log(new XUSourceLogRecord(Level.FINEST, "setXOMParameters done.", new Object[0]));
            }
            if (this.engineTraceEnabled) {
                IlrRuleEngineEventImpl evt = new IlrRuleEngineEventImpl(23, this, new Object[]{parameters}, this.getRuleset().getCanonicalRulesetPath(), this.xuContext);
                this.evtDispatcher.ruleEngineEventRaised(evt);
            }
        }
        catch (InterruptedException e) {
            throw new XUException("XU.ERROR.10403", null, (Throwable)e);
        }
        if (!this.listeners.isEmpty()) {
            long duration = System.nanoTime() - startTime;
            for (EngineManagerListener l : this.listeners) {
                l.setParametersPerformed(this, duration);
            }
        }
    }

    protected abstract Map<String, Object> getXOMParameters(byte var1) throws XUException;

    @Override
    public void getXOMParameters(byte dir, Map<String, Object> map) throws XUException {
        map.putAll(this.getXOMParameters(dir));
    }

    protected final void performGetParameters(byte direction, Map<String, Object> params) throws XUException {
        try {
            params.putAll(this.executableRuleset.getXMLObjectService().toMap(this.getXOMParameters(direction)));
        }
        catch (InterruptedException e) {
            throw new XUException("XU.ERROR.10403", null, (Throwable)e);
        }
    }

    @Override
    public synchronized void getParameters(byte direction, Map<String, Object> params) throws XUException {
        long startTime = this.listeners.isEmpty() ? 0L : System.nanoTime();
        this.performGetParameters(direction, params);
        if (!this.listeners.isEmpty()) {
            long duration = System.nanoTime() - startTime;
            for (EngineManagerListener listener : this.listeners) {
                listener.getParametersPerformed(this, duration);
            }
        }
    }

    @Override
    public synchronized void addEngineManagerListener(EngineManagerListener listener) {
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord.Entry(listener));
        }
        this.listeners.add(listener);
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord.Exit());
        }
    }

    @Override
    public synchronized XURulesetImpl getRuleset() {
        return this.executableRuleset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void cleanup() {
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord.Entry(new Object[0]));
        }
        Map<Object, Object> map = this.assertedObjects;
        synchronized (map) {
            this.assertedObjects.clear();
        }
        this.reset();
        this.resetOutput();
        this.state = 1;
        for (EngineManagerListener l : this.listeners) {
            l.cleanupPerformed(this);
        }
        this.clearChannelMessages();
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord.Exit());
        }
    }

    @Override
    public synchronized void destroy() {
        this.state = (byte)3;
        this.xuContext = null;
        for (EngineManagerListener l : this.listeners) {
            l.destroyPerformed(this);
        }
        this.logger = null;
        this.executableRuleset = null;
        this.assertedObjects = null;
        this.channelMsgs = null;
    }

    protected void resetOutput() {
        this.engineOutputWriter.flush();
        StringBuffer buffer = this.engineOutputWriter.getBuffer();
        buffer.delete(0, buffer.length());
    }

    @Override
    public synchronized String getOutput(boolean clear) {
        StringBuffer buffer = this.engineOutputWriter.getBuffer();
        String result = buffer.toString();
        if (clear && buffer.length() > 0) {
            buffer.delete(0, buffer.length());
        }
        return result;
    }

    @Override
    public synchronized boolean isUptodate() {
        return this.uptodate;
    }

    @Override
    public synchronized void setUptodate(boolean uptodate) {
        this.uptodate = uptodate;
    }

    @Override
    public synchronized void start(IlrManagedConnectionContext xuContext) throws XUException {
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord.Entry(xuContext));
        }
        this.state = (byte)2;
        this.xuContext = xuContext;
        if (this.getRuleset().getRulesetArchiveProperties().isTraceEnabled()) {
            this.enableEngineTrace();
        }
        for (EngineManagerListener l : this.listeners) {
            l.startPerformed(this);
        }
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord.Exit());
        }
    }

    @Override
    public synchronized byte getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectId(Object obj) {
        Map<Object, Object> map = this.assertedObjects;
        synchronized (map) {
            for (Map.Entry<Object, Object> entry : this.assertedObjects.entrySet()) {
                if (entry.getValue() != obj) continue;
                return entry.getKey();
            }
            UUID uuid = UUID.randomUUID();
            this.assertedObjects.put(uuid, obj);
            return uuid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Object, Object> getWorkingMemoryWithId() {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Map<Object, Object> map = this.assertedObjects;
        synchronized (map) {
            Object[] wm;
            for (Object obj : wm = this.getWorkingMemory()) {
                result.put(this.getObjectId(obj), obj);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void insertObject(Object id, int type, Object pobject) throws XUException {
        Object object = pobject;
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord.Entry(id, type, pobject));
        }
        if (object instanceof String && type == 1) {
            try {
                object = this.executableRuleset.getXMLObjectService().toXMLObject((String)object, null, null);
            }
            catch (IlrXmlErrorException e) {
                throw new XUException("XU.ERROR.10401", new String[]{id.toString(), new Integer(type).toString(), object.toString()}, (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new XUException("XU.ERROR.10403", null, (Throwable)e);
            }
        }
        if (id != null) {
            Map<Object, Object> map = this.assertedObjects;
            synchronized (map) {
                this.assertedObjects.put(id, object);
            }
        }
        this.insertObject(object);
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord.Exit());
        }
    }

    protected abstract void insertObject(Object var1) throws XUException;

    @Override
    public synchronized void setManagedConnection(IlrManagedXUConnection connection) {
        this.connection = connection;
        this.evtDispatcher = connection.getEventDispatcher();
        this.logger = connection.getLogHandler();
        this.isFinestLoggable = this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public synchronized Map<String, String> getParametersAsBOM(byte dir, List<String> filters, boolean roAtts, BOMConverter.ObjectKind kind, XUWarningListener l) throws XUException {
        long startTime = this.listeners.isEmpty() ? 0L : System.nanoTime();
        Map<String, Object> params = this.getXOMParameters(dir);
        BOMConverter conv = this.getBOMConverter();
        Map<String, String> result = conv.toBOMParameters(params, filters, roAtts, kind, l);
        if (!this.listeners.isEmpty()) {
            long duration = System.nanoTime() - startTime;
            for (EngineManagerListener listener : this.listeners) {
                listener.getParametersPerformed(this, duration);
            }
        }
        return result;
    }

    @Override
    public synchronized String[] toBOM(List<Object> objs, BOMConverter.ObjectKind kind, XUWarningListener l) throws XUException {
        int n = objs.size();
        String[] ret = new String[n];
        BOMConverter conv = this.getBOMConverter();
        for (int i = 0; i < n; ++i) {
            ret[i] = conv.toBOM(null, objs.get(i), null, true, kind, l);
            if (!this.isFinestLoggable) continue;
            this.logger.log(new XUSourceLogRecord(Level.FINEST, "BOM conversion: " + objs.get(i) + " to " + ret[i], new Object[0]));
        }
        return ret;
    }

    @Override
    public synchronized void setParametersAsBOM(Map<String, String> bomParams, BOMConverter.ObjectKind kind, XUWarningListener l) throws XUException {
        BOMConverter bomService = this.getBOMConverter();
        Map<String, Object> params = bomService.toXOMParameters(bomParams, kind, l);
        this.setXOMParameters(params);
    }

    protected abstract void performExecute(Map<String, Object> var1) throws XUException;

    protected void checkExecutionAllowed(String taskName) throws XUException {
        boolean allowed = this.authProvider.isRulesetExecutionAllowed(null, this.canonicalRulesetPath, this.getRuleset().getRulesetArchiveProperties(), this.getUserData(), this.getRuleset().getRules());
        if (!allowed) {
            throw new XUException(XUMessageCode.ERROR_RULESET_EXECUTION_NOT_ALLOWED);
        }
    }

    @Override
    public synchronized void execute(Map<String, Object> outParams) throws XUException {
        long startTime;
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord.Entry(outParams));
        }
        if (this.authProvider != null) {
            this.checkExecutionAllowed(null);
        }
        if (this.listeners.isEmpty()) {
            startTime = 0L;
        } else {
            startTime = System.nanoTime();
            for (EngineManagerListener l : this.listeners) {
                l.executeStarted(this);
            }
        }
        try {
            this.performExecute(outParams);
        }
        catch (XUException e) {
            if (!this.listeners.isEmpty()) {
                long duration = System.nanoTime() - startTime;
                for (EngineManagerListener l : this.listeners) {
                    l.executeFailed(this, duration);
                }
            }
            throw e;
        }
        if (!this.listeners.isEmpty()) {
            long duration = System.nanoTime() - startTime;
            for (EngineManagerListener l : this.listeners) {
                l.executeEnded(this, duration);
            }
        }
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord.Exit(outParams));
        }
    }

    protected abstract void performExecuteTask(String var1, Map<String, Object> var2) throws XUException;

    @Override
    public synchronized void executeTask(String taskName, Map<String, Object> params) throws XUException {
        long startTime;
        if (this.authProvider != null) {
            this.checkExecutionAllowed(taskName);
        }
        if (this.listeners.isEmpty()) {
            startTime = 0L;
        } else {
            startTime = System.nanoTime();
            for (EngineManagerListener l : this.listeners) {
                l.executeTaskStarted(taskName, this);
            }
        }
        try {
            this.performExecuteTask(taskName, params);
        }
        catch (XUException e) {
            if (!this.listeners.isEmpty()) {
                long duration = System.nanoTime() - startTime;
                for (EngineManagerListener l : this.listeners) {
                    l.executeTaskFailed(taskName, this, duration);
                }
            }
            throw e;
        }
        if (!this.listeners.isEmpty()) {
            long duration = System.nanoTime() - startTime;
            for (EngineManagerListener l : this.listeners) {
                l.executeTaskEnded(taskName, this, duration);
            }
        }
    }

    @Override
    public synchronized void clearChannelMessages() {
        this.channelMsgs.clear();
    }

    @Override
    public synchronized List<ChannelMessage> getChannelMessages() {
        return Collections.unmodifiableList(this.channelMsgs);
    }

    @Override
    public synchronized void channelMessageEmitted(EngineManager engine, ChannelMessage msg) {
        this.channelMsgs.add(msg);
        this.fireChannelMessageEmitted(msg);
    }

    @Override
    public synchronized IlrConnectionId getConnectionId() {
        return this.xuContext.getConnectionContext().getConnectionInformation().getConnectionId();
    }

    @Override
    public synchronized Object getUserData() {
        return this.xuContext.getConnectionContext().getConnectionInformation().getConnectionSpec().getUserData();
    }

    @Override
    public synchronized void addChannelMessageListener(ChannelMessageListener l) {
        this.channelListeners.add(l);
    }

    protected synchronized void fireChannelMessageEmitted(ChannelMessage msg) {
        for (ChannelMessageListener l : this.channelListeners) {
            l.channelMessageEmitted(this, msg);
        }
    }

    @Override
    public synchronized void addEngineListener(EngineListener l) {
        this.engineListeners.add(l);
    }

    @Override
    public synchronized void taskCompleted(TaskEvent evt) {
        for (EngineListener l : this.engineListeners) {
            l.taskCompleted(evt);
        }
    }

    @Override
    public synchronized void taskStarted(TaskEvent evt) {
        for (EngineListener l : this.engineListeners) {
            l.taskStarted(evt);
        }
    }

    @Override
    public synchronized void ruleExecutionCompleted(RuleEvent evt) {
        for (EngineListener l : this.engineListeners) {
            l.ruleExecutionCompleted(evt);
        }
    }

    @Override
    public synchronized void ruleExecutionStarted(RuleEvent evt) {
        for (EngineListener l : this.engineListeners) {
            l.ruleExecutionStarted(evt);
        }
    }

    @Override
    public void setAuthorizationProvider(AuthorizationProvider authProvider) {
        this.authProvider = authProvider;
    }

    @Override
    public IlrXmlObject[] toXMLObjects(List<String> xmls) throws XUException {
        int n = xmls.size();
        IlrXmlObject[] result = new IlrXmlObject[n];
        for (int i = 0; i < n; ++i) {
            String xml = xmls.get(i);
            try {
                result[i] = this.executableRuleset.getXMLObjectService().toXMLObject(xml, null, null);
                continue;
            }
            catch (Exception e) {
                throw new XUException("XU.ERROR.10401", new String[]{null, null, xml}, (Throwable)e);
            }
        }
        return result;
    }
}

