/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.engine.xml.internal;

import com.ibm.rules.engine.migration.classdriver.runtime.XmlBindingService;
import com.ibm.rules.engine.runtime.EngineDefinition;
import com.ibm.rules.engine.runtime.EngineSignature;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.rules.res.xu.engine.de.internal.DEEngine;
import com.ibm.rules.res.xu.engine.xml.internal.XMLObjectTransformer;
import com.ibm.rules.res.xu.engine.xml.internal.XMLObjectTransformerPool;
import com.ibm.rules.res.xu.engine.xml.internal.XMLTransformException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.pool.internal.ObjectFactory;
import com.ibm.rules.res.xu.pool.internal.PoolImpl;
import com.ibm.rules.res.xu.ruleset.internal.DERulesetImpl;
import com.ibm.rules.res.xu.ruleset.internal.RulesetParameterException;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetImpl;
import ilog.rules.bom.IlrClass;
import ilog.rules.bom.IlrType;
import ilog.rules.engine.IlrRulesetParameter;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.res.xu.pool.IlrPoolException;
import ilog.rules.xml.IlrXmlDataDriver;
import ilog.rules.xml.IlrXmlErrorException;
import ilog.rules.xml.IlrXmlObject;
import ilog.rules.xml.IlrXmlSchemaDriver;
import ilog.rules.xml.binding.IlrXmlDefaultSchemaDriver;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class XMLObjectService {
    protected int poolMaxSize;
    protected long reserveTimeout;
    protected XURulesetImpl ruleset = null;
    protected XMLDocumentDriverFactory xmlDocumentDriverFactory = null;
    protected PoolImpl<XMLObjectTransformer> xmlDocumentDriverPool = null;
    protected LogHandler logger = null;

    public XMLObjectService(XURulesetImpl ruleset, int poolMaxSize, long reserveTimeout, LogHandler logger) {
        this.ruleset = ruleset;
        this.reserveTimeout = reserveTimeout;
        this.poolMaxSize = poolMaxSize;
        this.logger = logger;
    }

    public int getXMLDocumentDriverPoolSize() {
        return this.xmlDocumentDriverPool == null ? -1 : this.xmlDocumentDriverPool.getMaxSize();
    }

    public Map<String, Object> toMap(Map<String, Object> params) throws RulesetParameterException, InterruptedException, IlrPoolException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            int kind;
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value != null && (kind = this.getParamKind(name)) != 0) {
                try {
                    value = this.toString((IlrXmlObject)value);
                }
                catch (IlrXmlErrorException e) {
                    throw new RulesetParameterException("XU.ERROR.10400", new String[]{name}, (Throwable)e);
                }
            }
            result.put(name, value);
        }
        return result;
    }

    public Map<String, Object> toParameterMap(Map<String, Object> parameters, IlrXUContext xuContext) throws RulesetParameterException, InterruptedException, IlrPoolException, XMLTransformException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            int kind;
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value != null && (kind = this.getParamKind(name)) != 0 && value instanceof String) {
                try {
                    IlrType type = this.getParamType(name);
                    value = this.toXMLObject((String)value, (IlrClass)type, xuContext);
                }
                catch (XMLTransformException e) {
                    String code = "XU.ERROR.10400";
                    throw new RulesetParameterException(code, new String[]{name}, (Throwable)e);
                }
                catch (IlrXmlErrorException e) {
                    String code = "XU.ERROR.10400";
                    throw new RulesetParameterException(code, new String[]{name}, (Throwable)e);
                }
            }
            result.put(name, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(IlrXmlObject object) throws IlrPoolException, IlrXmlErrorException, InterruptedException, IlrPoolException {
        XMLObjectTransformer transformer = this.getXMLObjectTransformer();
        try {
            String string = transformer.toString(object);
            return string;
        }
        finally {
            if (this.poolMaxSize != 0) {
                this.getXMLDocumentDriverPool().release(transformer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlrXmlObject toXMLObject(String string, IlrClass type, IlrXUContext xuContext) throws IlrXmlErrorException, InterruptedException, IlrPoolException, XMLTransformException {
        XMLObjectTransformer transformer = this.getXMLObjectTransformer();
        try {
            IlrXmlObject ilrXmlObject = transformer.toXMLObject(string, type, xuContext);
            return ilrXmlObject;
        }
        finally {
            if (this.poolMaxSize != 0) {
                this.getXMLDocumentDriverPool().release(transformer);
            }
        }
    }

    public XMLObjectTransformer getXMLObjectTransformer() throws IlrPoolException, IlrXmlErrorException {
        if (this.poolMaxSize == 0) {
            return this.getXMLDocumentDriverFactory().create();
        }
        return (XMLObjectTransformer)this.getXMLDocumentDriverPool().get();
    }

    protected synchronized XMLDocumentDriverFactory getXMLDocumentDriverFactory() throws IlrXmlErrorException {
        if (this.xmlDocumentDriverFactory == null) {
            this.xmlDocumentDriverFactory = this.createXMLDocumentDriverFactory();
        }
        return this.xmlDocumentDriverFactory;
    }

    protected synchronized XMLDocumentDriverFactory createXMLDocumentDriverFactory() throws IlrXmlErrorException {
        XMLDocumentDriverFactory factory = null;
        if (this.ruleset instanceof DERulesetImpl) {
            EngineDefinition def = ((DERulesetImpl)this.ruleset).getRuleset();
            XmlBindingService s = (XmlBindingService)def.createEngine().getService(XmlBindingService.class);
            IlrXmlDataDriver dataDriver = s.getDataDriver();
            factory = new XMLDocumentDriverFactory((IlrXmlSchemaDriver)dataDriver);
        } else {
            IlrXmlDefaultSchemaDriver driver = new IlrXmlDefaultSchemaDriver(this.ruleset.getCRERuleset().getReflect());
            factory = new XMLDocumentDriverFactory((IlrXmlSchemaDriver)driver);
        }
        return factory;
    }

    protected synchronized PoolImpl<XMLObjectTransformer> getXMLDocumentDriverPool() throws IlrXmlErrorException {
        if (this.xmlDocumentDriverPool == null) {
            this.xmlDocumentDriverPool = new XMLObjectTransformerPool();
            this.xmlDocumentDriverPool.setLogger(this.logger.getLogger());
            this.xmlDocumentDriverPool.initialize(this.reserveTimeout, this.poolMaxSize, this.getXMLDocumentDriverFactory());
        }
        return this.xmlDocumentDriverPool;
    }

    protected int getParamKind(String parameterName) throws RulesetParameterException {
        if (this.ruleset instanceof DERulesetImpl) {
            return this.getDEParamKind(parameterName);
        }
        return this.getCREParamKind(parameterName);
    }

    protected int getDEParamKind(String name) throws RulesetParameterException {
        EngineSignature sig = ((DERulesetImpl)this.ruleset).getRuleset().getSignature();
        Collection params = sig.getAllParameters();
        for (EngineSignature.Parameter p : params) {
            if (!p.getName().equals(name)) continue;
            if (p.getParameterTypeName().equals(IlrXmlObject.class.getName())) {
                return 1;
            }
            return 0;
        }
        if (name.equals("ilog.rules.firedRulesCount")) {
            return 0;
        }
        throw new RulesetParameterException(XUMessageCode.ERROR_RULESET_PARAMETER_DOES_NOT_EXIST, new String[]{name, this.ruleset.getCanonicalRulesetPath()}, null);
    }

    protected int getCREParamKind(String name) throws RulesetParameterException {
        Map<String, XURulesetParameter> params = this.ruleset.getRulesetParametersMap();
        XURulesetParameter p = params.get(name);
        if (p != null) {
            return p.getKind();
        }
        if (name.equals("ilog.rules.firedRulesCount")) {
            return 0;
        }
        throw new RulesetParameterException(XUMessageCode.ERROR_RULESET_PARAMETER_DOES_NOT_EXIST, new String[]{name, this.ruleset.getCanonicalRulesetPath()}, null);
    }

    protected IlrType getParamType(String name) throws RulesetParameterException {
        if (this.ruleset instanceof DERulesetImpl) {
            return this.getDEParamType(name);
        }
        return this.getCREParamType(name);
    }

    protected IlrType getCREParamType(String name) throws RulesetParameterException {
        IlrRulesetParameter[] params = this.ruleset.getCRERuleset().getRulesetSignature();
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].getName().equals(name)) continue;
            return params[i].getType();
        }
        throw new RulesetParameterException("XU.ERROR.10400", new String[]{name}, null);
    }

    private IlrType getDEParamType(String name) throws RulesetParameterException {
        DERulesetImpl deRuleset = (DERulesetImpl)this.ruleset;
        EngineDefinition def = deRuleset.getRuleset();
        Collection params = def.getSignature().getAllParameters();
        for (EngineSignature.Parameter parameter : params) {
            if (!parameter.getName().equals(name)) continue;
            return DEEngine.getXMLType(parameter, def);
        }
        throw new RulesetParameterException("XU.ERROR.10400", new String[]{name}, null);
    }

    protected static IlrPoolException createPoolException(String code, String[] params, Exception cause) {
        return new IlrPoolException(code, (Object[])params, (Throwable)cause);
    }

    class XMLDocumentDriverFactory
    implements ObjectFactory<XMLObjectTransformer> {
        protected IlrXmlSchemaDriver schemaDriver = null;

        public XMLDocumentDriverFactory(IlrXmlSchemaDriver schemaDriver) {
            this.schemaDriver = schemaDriver;
        }

        @Override
        public XMLObjectTransformer create() throws IlrPoolException {
            try {
                return new XMLObjectTransformer(this.schemaDriver.createDocumentDriver(), XMLObjectService.this.logger);
            }
            catch (IlrXmlErrorException e) {
                throw XMLObjectService.createPoolException("XU.ERROR.10402", null, (Exception)((Object)e));
            }
        }
    }
}

