/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.engine.xml.internal;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.engine.xml.internal.XMLTransformException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import ilog.rules.bom.IlrClass;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.xml.IlrXmlDocumentDriver;
import ilog.rules.xml.IlrXmlError;
import ilog.rules.xml.IlrXmlErrorException;
import ilog.rules.xml.IlrXmlObject;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

final class XMLObjectTransformer {
    private final IlrXmlDocumentDriver documentDriver;
    private final LogHandler logger;

    XMLObjectTransformer(IlrXmlDocumentDriver documentDriver, LogHandler logger) {
        this.documentDriver = documentDriver;
        this.logger = logger;
    }

    synchronized IlrXmlObject toXMLObject(String string, IlrClass type, IlrXUContext xuContext) throws XMLTransformException, IlrXmlErrorException {
        if ((string = string.trim()).isEmpty()) {
            throw new XMLTransformException(XUMessageCode.ERROR_INVALID_EMPTY_XML, null, null);
        }
        IlrXmlObject xmlObject = type == null ? this.documentDriver.readObject((Reader)new StringReader(string)) : this.documentDriver.readObject((Reader)new StringReader(string), type);
        IlrXmlError[] errors = this.documentDriver.getWarnings();
        if (errors != null && xuContext != null && this.logger != null) {
            for (int i = 0; i < errors.length; ++i) {
                this.logger.warning(XUMessageCode.WARNING_XML_BINDING, null, new String[]{errors[i].getMessage()}, this, xuContext, true);
            }
        }
        return xmlObject;
    }

    synchronized String toString(IlrXmlObject object) throws IlrXmlErrorException {
        StringWriter writer = new StringWriter();
        this.documentDriver.writeObject(object, (Writer)writer);
        return writer.toString();
    }
}

