/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.info.internal;

import com.ibm.rules.res.persistence.internal.PersistencePropertiesConverter;
import com.ibm.rules.res.xu.client.info.internal.EventListenerInfo;
import com.ibm.rules.res.xu.client.info.internal.RulesetCacheEntryInfo;
import com.ibm.rules.res.xu.client.info.internal.RulesetParsingWorkInfo;
import com.ibm.rules.res.xu.client.info.internal.SPIConnectionInfo;
import com.ibm.rules.res.xu.client.info.internal.SolvedRulesetPathInfo;
import com.ibm.rules.res.xu.client.info.internal.XUInfo;
import com.ibm.rules.res.xu.info.internal.Converter;
import com.ibm.rules.res.xu.info.internal.RulesetCacheEntryInfoImpl;
import com.ibm.rules.res.xu.info.internal.SPIConnectionInfoImpl;
import com.ibm.rules.res.xu.info.internal.SystemInfo;
import com.ibm.rules.res.xu.info.internal.XML;
import com.ibm.rules.res.xu.info.internal.XMLObjectServiceInfo;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationImpl;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class XMLConverter
extends Converter {
    public static final String toXML(XUInfo info, Locale locale, LogHandler logger) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version='1.0' encoding='utf-8'?>\n");
        buf.append("<?xml-stylesheet href='xuinfo.xsl' type='text/xsl'?>\n");
        buf.append("<xu-info format-version='1.0'>\n");
        buf.append("<wodm-version>");
        buf.append("8.7.1.0");
        buf.append("</wodm-version>\n");
        buf.append("<wodm-build-date>");
        buf.append("2015-04-17 13:41:58");
        buf.append("</wodm-build-date>\n");
        buf.append("<date>");
        DateFormat format = DateFormat.getDateTimeInstance(0, 0, locale);
        String strDate = format.format(info.getDate());
        buf.append(strDate);
        buf.append("</date>\n");
        SystemInfo.appendXML(buf, logger);
        XML.append(buf, XMLConverter.obfuscateXUProperties(info.getSPIFactoryProperties()));
        buf.append("<cci-reconnection-pool-size>");
        buf.append(info.getCCIReconectionPoolSize());
        buf.append("</cci-reconnection-pool-size>\n");
        buf.append("<ruleset-cache>\n");
        buf.append("<rulesets>\n");
        XMLConverter.appendRulesetCacheEntries(buf, info.getRulesetCacheEntryInfos());
        buf.append("</rulesets>\n");
        buf.append("<deprecated-rulesets>\n");
        XMLConverter.appendRulesetCacheEntries(buf, info.getRulesetCacheDeprecatedEntryInfos());
        buf.append("</deprecated-rulesets>\n");
        buf.append("</ruleset-cache>\n");
        XMLConverter.appendSolvedRulesetPathCache(buf, info.getSolvedRulesetPathCache());
        buf.append("<persistence>\n");
        buf.append("<class-name>");
        buf.append(info.getRulesetArchiveProviderClass());
        buf.append("</class-name>\n");
        buf.append("<is-concurrent>");
        buf.append(info.isConcurrentPersistence());
        buf.append("</is-concurrent>\n");
        if (info.getRulesetArchiveProviderProperties() != null) {
            Map<String, String> obfuscatedProps = PersistencePropertiesConverter.obfuscate(info.getRulesetArchiveProviderProperties());
            XML.append(buf, obfuscatedProps);
        }
        buf.append("</persistence>\n");
        buf.append("<spi-connection-pool>\n");
        for (SPIConnectionInfo sPIConnectionInfo : info.getSPIConnectionInfos()) {
            XMLConverter.append(sPIConnectionInfo, buf);
        }
        buf.append("</spi-connection-pool>\n");
        buf.append("<event-listeners>\n");
        for (EventListenerInfo eventListenerInfo : info.getEventListeners()) {
            buf.append("<event-listener mask='" + eventListenerInfo.getMask() + "'" + " object-ref='" + eventListenerInfo.getRef() + "'/>\n");
        }
        buf.append("</event-listeners>\n");
        buf.append("<works>\n");
        for (RulesetParsingWorkInfo rulesetParsingWorkInfo : info.getRulesetParsingWorkInfos()) {
            buf.append("<ruleset-loader-work path='" + rulesetParsingWorkInfo.getRulesetPath() + "'" + " state='" + rulesetParsingWorkInfo.getState() + "'/>\n");
        }
        buf.append("</works>\n");
        buf.append("<ruleset-archive-information-cache>\n");
        for (String string : info.getRulesetArchiveInformationCacheInfo().getRulesetPaths()) {
            buf.append("<ruleset path='" + string + "'/>\n");
        }
        for (String string : info.getRulesetArchiveInformationCacheInfo().getDeprecatedRulesetPaths()) {
            buf.append("<deprecated-ruleset path='" + string + "'/>\n");
        }
        buf.append("</ruleset-archive-information-cache>\n");
        buf.append("<rulesets-usage-information>");
        for (Map.Entry entry : info.getRulesetUsageInformation().entrySet()) {
            String canonicalPath = (String)entry.getKey();
            Map<String, Object> rinfo = ((IlrRulesetUsageInformationImpl)entry.getValue()).toMap();
            buf.append("<ruleset-usage-information canonical-path='" + canonicalPath + "'>\n");
            buf.append("<properties>");
            for (Map.Entry<String, Object> entries : rinfo.entrySet()) {
                buf.append("<property>\n");
                buf.append("<name>");
                buf.append(entries.getKey());
                buf.append("</name>\n");
                buf.append("<value>");
                if (entries.getKey().equals("lastUsageTime") && entries.getValue() != null && entries.getValue() instanceof Long) {
                    Date lastUsageDate = new Date((Long)entries.getValue());
                    buf.append(format.format(lastUsageDate));
                } else {
                    buf.append(entries.getValue());
                }
                buf.append("</value>\n");
                buf.append("</property>\n");
            }
            buf.append("</properties>");
            buf.append("</ruleset-usage-information>\n");
        }
        buf.append("</rulesets-usage-information>\n");
        if (info.getMemoryDump() != null) {
            buf.append(info.getMemoryDump());
        }
        buf.append("</xu-info>\n");
        return buf.toString();
    }

    protected static final void appendRulesetCacheEntries(StringBuffer buffer, Collection<RulesetCacheEntryInfo> entries) {
        for (RulesetCacheEntryInfo entry : entries) {
            XMLConverter.appendRulesetCacheEntry(buffer, entry);
        }
    }

    protected static final void appendRulesetCacheEntry(StringBuffer buffer, RulesetCacheEntryInfo entry) {
        XMLObjectServiceInfo service = ((RulesetCacheEntryInfoImpl)entry).getXMLObjectService();
        buffer.append("<ruleset canonical-path='" + entry.getCanonicalRulesetPath() + "'" + " is-weak-ref='" + entry.isWeakReferenced() + "'" + " ref='" + entry.getRulesetRef() + "'" + " is-de-ruleset='" + entry.isDERuleset() + "'>\n");
        if (entry.getRulesetRef() != null) {
            buffer.append("<xml-converter-pool size='" + service.getPoolSize() + "'" + " max-size='" + service.getPoolMaxSize() + "'" + " timeout='" + service.getReserveTimeout() + "' />\n");
        }
        buffer.append("</ruleset>\n");
    }

    protected static final void appendSolvedRulesetPathCache(StringBuffer buffer, Collection<SolvedRulesetPathInfo> cache) {
        buffer.append("<solved-rulesetpath-cache>");
        for (SolvedRulesetPathInfo entry : cache) {
            buffer.append("<solved-rulesetpath-cache-entry rulesetpath='" + entry.getRulesetPath() + "'" + " canonical-rulesetpath='" + entry.getCanonicalRulesetPath() + "'/>\n");
        }
        buffer.append("</solved-rulesetpath-cache>\n");
    }

    protected static final void append(SPIConnectionInfo conn, StringBuffer buf) {
        buf.append("<spi-connection>");
        buf.append("<path>");
        buf.append(conn.getRulesetPath());
        buf.append("</path>\n");
        buf.append("<id>");
        buf.append(conn.getId());
        buf.append("</id>\n");
        buf.append("<state>");
        buf.append(SPIConnectionInfoImpl.stateToString(conn.getState()));
        buf.append("</state>\n");
        buf.append("<type>");
        buf.append(SPIConnectionInfoImpl.typeToString(conn.getType()));
        buf.append("</type>\n");
        buf.append("<ref>");
        buf.append(conn.getRef());
        buf.append("</ref>\n");
        buf.append("<free-engines-count>");
        buf.append(conn.getFreeEngineManagersCount());
        buf.append("</free-engines-count>\n");
        buf.append("<comment>");
        buf.append(conn.getEnginesInfo());
        buf.append("</comment>\n");
        buf.append("</spi-connection>\n");
    }
}

