/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.info.internal;

import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import com.ibm.rules.res.xu.client.info.internal.EventListenerInfo;
import com.ibm.rules.res.xu.client.info.internal.RulesetArchiveInformationCacheInfo;
import com.ibm.rules.res.xu.client.info.internal.RulesetCacheEntryInfo;
import com.ibm.rules.res.xu.client.info.internal.RulesetParsingWorkInfo;
import com.ibm.rules.res.xu.client.info.internal.SPIConnectionInfo;
import com.ibm.rules.res.xu.client.info.internal.SolvedRulesetPathInfo;
import com.ibm.rules.res.xu.client.info.internal.XUInfo;
import com.ibm.rules.res.xu.engine.internal.EngineManager;
import com.ibm.rules.res.xu.info.internal.EventListenerInfoImpl;
import com.ibm.rules.res.xu.info.internal.JSONConverter;
import com.ibm.rules.res.xu.info.internal.RulesetArchiveInformationCacheInfoImpl;
import com.ibm.rules.res.xu.info.internal.RulesetCacheEntryInfoImpl;
import com.ibm.rules.res.xu.info.internal.RulesetParsingWorkInfoImpl;
import com.ibm.rules.res.xu.info.internal.SPIConnectionInfoImpl;
import com.ibm.rules.res.xu.info.internal.SolvedRulesetPathInfoImpl;
import com.ibm.rules.res.xu.info.internal.XMLConverter;
import com.ibm.rules.res.xu.info.internal.XMLObjectServiceInfo;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.xu.cci.IlrConnectionId;
import ilog.rules.res.xu.cci.IlrXUConnection;
import ilog.rules.res.xu.ruleset.IlrRulesetUsageInformation;
import ilog.rules.res.xu.spi.IlrConnectionContextManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class XUInfoImpl
extends XUInfo {
    protected Collection<SPIConnectionInfo> spiConnections = new ArrayList<SPIConnectionInfo>();
    protected Collection<RulesetParsingWorkInfo> rulesetParsingWorkInfos = new ArrayList<RulesetParsingWorkInfo>();
    protected Date date = null;
    protected Properties spiFactoryProperties = null;
    protected int cciReconnectionPoolSize = 0;
    protected String persistenceClass;
    protected Map<String, String> persistenceProps;
    protected boolean concurrentPersistence;
    protected ArrayList<RulesetCacheEntryInfo> rulesetCache = new ArrayList();
    protected ArrayList<RulesetCacheEntryInfo> deprecatedRulesetCache = new ArrayList();
    protected ArrayList<EventListenerInfo> eventListeners = new ArrayList();
    protected ArrayList<SolvedRulesetPathInfo> solvedRulesetPaths = new ArrayList();
    protected RulesetArchiveInformationCacheInfo rulesetArchiveInformationCacheInfo = new RulesetArchiveInformationCacheInfoImpl();
    protected Map<String, IlrRulesetUsageInformation> rulesetUsageInformation = new HashMap<String, IlrRulesetUsageInformation>();
    protected String memoryDump = null;
    protected LogHandler logger = null;

    public XUInfoImpl(LogHandler logger) {
        this.logger = logger;
    }

    public final void setMemoryDump(String memoryDump) {
        this.memoryDump = memoryDump;
    }

    public final void addRulesetUsageInformation(String canonicalRulesetPath, IlrRulesetUsageInformation info) {
        this.rulesetUsageInformation.put(canonicalRulesetPath, info);
    }

    public final void addSolvedRulesetPath(String rulesetPath, String canonicalRulesetPath) {
        this.solvedRulesetPaths.add(new SolvedRulesetPathInfoImpl(rulesetPath, canonicalRulesetPath));
    }

    public final void addEventListener(String mask, Object ref) {
        this.eventListeners.add(new EventListenerInfoImpl(mask, ref));
    }

    public final void addRulesetCacheEntry(String canonicalRulesetPath, Object rulesetRef, boolean isWeakReferenced, int poolSize, int poolMaxSize, long reserveTimeout, boolean isDERuleset) {
        RulesetCacheEntryInfoImpl e = new RulesetCacheEntryInfoImpl(canonicalRulesetPath, rulesetRef, isWeakReferenced, new XMLObjectServiceInfo(poolSize, poolMaxSize, reserveTimeout), isDERuleset);
        this.rulesetCache.add(e);
    }

    public final void addDeprecatedRulesetCacheEntry(String canonicalRulesetPath, Object rulesetRef, boolean isWeakReferenced, int poolSize, int poolMaxSize, long reserveTimeout, boolean isDERuleset) {
        XMLObjectServiceInfo info = new XMLObjectServiceInfo(poolSize, poolMaxSize, reserveTimeout);
        RulesetCacheEntryInfoImpl e = new RulesetCacheEntryInfoImpl(canonicalRulesetPath, rulesetRef, isWeakReferenced, info, isDERuleset);
        this.deprecatedRulesetCache.add(e);
    }

    public final void setPersistenceInfo(String persistenceClass, Map<String, String> persistenceProps, boolean concurrentPersistence) {
        this.persistenceClass = persistenceClass;
        this.persistenceProps = persistenceProps;
        this.concurrentPersistence = concurrentPersistence;
    }

    public final void setCCIReconnectionPoolSize(int cciReconnectionPoolSize) {
        this.cciReconnectionPoolSize = cciReconnectionPoolSize;
    }

    @Override
    public final int getCCIReconectionPoolSize() {
        return this.cciReconnectionPoolSize;
    }

    public final void setSPIFactoryProperties(Properties spiFactoryProperties) {
        this.spiFactoryProperties = spiFactoryProperties;
    }

    @Override
    public final Date getDate() {
        return this.date;
    }

    public final void setDate(Date date) {
        this.date = date;
    }

    public final void addSPIConnection(IlrConnectionId id, String rulesetPath, byte type, byte state, List<EngineManager> freeEngines, IlrConnectionContextManager ctxManager, String connStr) {
        int freeEnginesSize = -1;
        if (freeEngines != null) {
            freeEnginesSize = freeEngines.size();
        }
        StringBuffer info = new StringBuffer();
        if (ctxManager != null) {
            int i = 0;
            for (IlrXUConnection conn : ctxManager.getConnections()) {
                info.append("n.");
                info.append(i);
                EngineManager mgr = conn.getEngineManager();
                if (mgr != null) {
                    IlrRulesetArchiveProperties props = mgr.getRuleset().getRulesetArchiveProperties();
                    info.append("  properties: ");
                    if (props != null) {
                        info.append(props.toString());
                    }
                }
                info.append("\n");
                ++i;
            }
        }
        this.spiConnections.add(new SPIConnectionInfoImpl(rulesetPath, state, id == null ? "N/A" : id.toString(), type, connStr, freeEnginesSize, info.toString()));
    }

    public final void addRulestParsingWorkInfo(String rulesetPath, byte state) {
        this.rulesetParsingWorkInfos.add(new RulesetParsingWorkInfoImpl(rulesetPath, state));
    }

    @Override
    public final String toJSONString() {
        return JSONConverter.toJSON(this, this.logger);
    }

    @Override
    public final String toXMLString(Locale locale) {
        return XMLConverter.toXML(this, locale, this.logger);
    }

    @Override
    public final Collection<SPIConnectionInfo> getSPIConnectionInfos() {
        return this.spiConnections;
    }

    @Override
    public final Collection<RulesetParsingWorkInfo> getRulesetParsingWorkInfos() {
        return this.rulesetParsingWorkInfos;
    }

    @Override
    public final RulesetArchiveInformationCacheInfo getRulesetArchiveInformationCacheInfo() {
        return this.rulesetArchiveInformationCacheInfo;
    }

    @Override
    public final Map<String, IlrRulesetUsageInformation> getRulesetUsageInformation() {
        return this.rulesetUsageInformation;
    }

    @Override
    public final Collection<RulesetCacheEntryInfo> getRulesetCacheEntryInfos() {
        return this.rulesetCache;
    }

    @Override
    public final Collection<RulesetCacheEntryInfo> getRulesetCacheDeprecatedEntryInfos() {
        return this.deprecatedRulesetCache;
    }

    @Override
    public final Properties getSPIFactoryProperties() {
        return this.spiFactoryProperties;
    }

    @Override
    public final Collection<SolvedRulesetPathInfo> getSolvedRulesetPathCache() {
        return this.solvedRulesetPaths;
    }

    @Override
    public final String getRulesetArchiveProviderClass() {
        return this.persistenceClass;
    }

    @Override
    public final boolean isConcurrentPersistence() {
        return this.concurrentPersistence;
    }

    @Override
    public final Map<String, String> getRulesetArchiveProviderProperties() {
        return this.persistenceProps;
    }

    @Override
    public final ArrayList<EventListenerInfo> getEventListeners() {
        return this.eventListeners;
    }

    @Override
    public final String getMemoryDump() {
        return this.memoryDump;
    }

    @Override
    public final String getResourceAdapterName() {
        return MetaData.getResourceAdapterName();
    }

    @Override
    public final String getShortDescription(Locale locale) {
        return MetaData.getShortDescription(locale);
    }

    @Override
    public final String getVendorName() {
        return MetaData.getVendorName();
    }

    @Override
    public final String getVersion() {
        return MetaData.getVersion();
    }

    @Override
    public final String getResourceAdapterSpecVersion() {
        return MetaData.getResourceAdapterSpecVersion();
    }

    @Override
    public final String getProductName() {
        return MetaData.getProductName();
    }

    public static final class MetaData {
        public static final String getResourceAdapterName() {
            return XUInfo.getName();
        }

        public static final String getShortDescription(Locale locale) {
            return LocalizedMessageHelper.getLocalizedMessage("com.ibm.rules.res.xu.messages", "XU.INFO.8100", null, locale, null);
        }

        public static final String getVendorName() {
            return "IBM";
        }

        public static final String getVersion() {
            return "8.7.1.0";
        }

        public static final String getProductName() {
            return "Decision Server";
        }

        public static final String getResourceAdapterSpecVersion() {
            return "1.5";
        }
    }
}

