/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.info.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.xu.info.internal.XUInfoImpl;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.xu.spi.IlrManagedXUConnectionFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.logging.Logger;
import javax.resource.spi.work.Work;

final class XUInfoSchedulerWork
implements Work {
    protected long interval = 10000L;
    protected long lastDumpTime = 0L;
    protected boolean workEnabled = true;
    protected WeakReference<IlrManagedXUConnectionFactory> spiFactory = null;
    protected File dir = new File("xudumps");
    private final Logger log;

    XUInfoSchedulerWork(long interval, IlrManagedXUConnectionFactory spiFactory) {
        this.interval = interval;
        this.spiFactory = new WeakReference<IlrManagedXUConnectionFactory>(spiFactory);
        this.log = spiFactory.getLogHandler().getLogger();
    }

    public void run() {
        this.log.log(new XUSourceLogRecord.Entry(new Object[0]));
        try {
            if (!this.dir.exists()) {
                this.dir.mkdir();
            }
            while (this.isEnabled()) {
                long t = this.getInterval();
                Thread.sleep(t);
                long time = System.currentTimeMillis();
                if (this.lastDumpTime + t >= time) continue;
                IlrManagedXUConnectionFactory factory = (IlrManagedXUConnectionFactory)this.spiFactory.get();
                if (factory != null) {
                    try {
                        this.saveXUDump(factory.getXUDump());
                    }
                    catch (IOException e) {
                        factory.getLogHandler().severe("XU.ERROR.11000", e, null, null);
                    }
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
        }
        catch (XUException e) {
            IlrManagedXUConnectionFactory factory = (IlrManagedXUConnectionFactory)this.spiFactory.get();
            factory.getLogHandler().severe("XU.ERROR.11000", e, null, null);
        }
        this.log.log(new XUSourceLogRecord.Exit());
    }

    public final synchronized boolean isEnabled() {
        return this.workEnabled;
    }

    public final synchronized long getInterval() {
        return this.interval;
    }

    public final synchronized void setInterval(long interval) {
        this.interval = interval;
    }

    public synchronized void release() {
        this.log.log(new XUSourceLogRecord.Entry(new Object[0]));
        this.workEnabled = false;
        this.log.log(new XUSourceLogRecord.Exit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveXUDump(XUInfoImpl dump) throws IOException {
        this.log.log(new XUSourceLogRecord.Entry(dump));
        String strDump = dump.toXMLString(Locale.getDefault());
        long dumpDate = dump.getDate().getTime();
        File file = new File(this.dir, "xd" + dumpDate + ".xml");
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file), 96000);
            writer.write(strDump);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
            this.log.log(new XUSourceLogRecord.Exit());
        }
    }
}

