/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.io.internal;

import com.ibm.rules.engine.util.CustomProperties;
import ilog.rules.factory.IlrPropertyList;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SerializableUtil {
    public static final Serializable toSerializable(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Serializable) {
            return (Serializable)object;
        }
        return object.toString();
    }

    public static final Serializable[] toSerializableArray(Object[] objects) {
        if (objects == null) {
            return null;
        }
        Serializable[] result = new Serializable[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            result[i] = SerializableUtil.toSerializable(objects[i]);
        }
        return result;
    }

    public static final Map<?, Serializable> toSerializableMap(Map<?, ?> map) {
        HashMap result = new HashMap();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            result.put(e.getKey(), SerializableUtil.toSerializable(e.getValue()));
        }
        return result;
    }

    public static final Map<?, Serializable> toSerializableMap(Properties props) {
        HashMap<Object, Serializable> result = new HashMap<Object, Serializable>();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            result.put(key, SerializableUtil.toSerializable(props.get(key)));
        }
        return result;
    }

    public static final Map<String, Serializable> toSerializableMap(CustomProperties props) {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        for (String k : props) {
            result.put(k, SerializableUtil.toSerializable(props.get(k)));
        }
        return result;
    }

    public static final Map<String, Serializable> toSerializableMap(IlrPropertyList props) {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        Enumeration entries = props.elements();
        while (entries.hasMoreElements()) {
            IlrPropertyList.Entry e = (IlrPropertyList.Entry)entries.nextElement();
            result.put(e.getKey(), SerializableUtil.toSerializable(e.getValue()));
        }
        return result;
    }
}

