/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.log.internal;

import com.ibm.rules.res.logging.internal.XULogRecord;
import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.io.internal.SerializableUtil;
import com.ibm.rules.res.xu.log.internal.LogListener;
import com.ibm.rules.res.xu.log.internal.XULogRecordFactory;
import com.ibm.rules.res.xu.log.internal.XULogger;
import com.ibm.rules.res.xu.security.internal.SystemPrivilegedAction;
import ilog.rules.bres.xu.event.IlrErrorEvent;
import ilog.rules.bres.xu.event.IlrLocalTransactionEvent;
import ilog.rules.bres.xu.event.IlrLocalTransactionEventListener;
import ilog.rules.bres.xu.event.IlrProfilingConnectionEvent;
import ilog.rules.bres.xu.event.IlrProfilingConnectionEventListener;
import ilog.rules.bres.xu.event.IlrProfilingManagedConnectionEvent;
import ilog.rules.bres.xu.event.IlrProfilingManagedConnectionEventListener;
import ilog.rules.bres.xu.event.IlrProfilingRuleEngineEvent;
import ilog.rules.bres.xu.event.IlrProfilingRuleEngineEventListener;
import ilog.rules.bres.xu.event.IlrProfilingRulesetEvent;
import ilog.rules.bres.xu.event.IlrProfilingRulesetEventListener;
import ilog.rules.bres.xu.event.IlrProfilingRulesetInformationProviderEvent;
import ilog.rules.bres.xu.event.IlrProfilingRulesetInformationProviderEventListener;
import ilog.rules.bres.xu.event.IlrProfilingSessionEvent;
import ilog.rules.bres.xu.event.IlrProfilingSessionEventListener;
import ilog.rules.bres.xu.event.IlrWarningEvent;
import ilog.rules.bres.xu.measure.IlrMeasure;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.res.xu.event.IlrRuleEngineEvent;
import ilog.rules.res.xu.event.IlrRuleEngineEventListener;
import ilog.rules.res.xu.event.internal.IlrRuleEngineEventImpl;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class LogHandler
implements IlrProfilingRulesetEventListener,
IlrProfilingRuleEngineEventListener,
IlrProfilingSessionEventListener,
IlrProfilingConnectionEventListener,
IlrProfilingManagedConnectionEventListener,
IlrProfilingRulesetInformationProviderEventListener,
IlrRuleEngineEventListener,
IlrLocalTransactionEventListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IlrXUEventDispatcher eventDispatcher;
    private transient List<LogListener> listeners = new ArrayList<LogListener>();
    private transient XULogger ulogger;

    public LogHandler(IlrXUEventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
        this.ulogger = new XULogger();
        this.logLoggingStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LogListener l) {
        List<LogListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    private static Level getLevel(Logger logger) {
        Level l;
        while ((l = logger.getLevel()) == null) {
            if ((logger = logger.getParent()) != null) continue;
            return null;
        }
        return l;
    }

    public boolean isLoggable(Level level) {
        return this.ulogger.isLoggable(level);
    }

    public boolean isJdkLoggingEnabled() {
        return this.ulogger.isJDKLoggingEnabled();
    }

    public void setJDKLoggingEnabled(boolean jdkLoggingEnabled) {
        this.ulogger.setJDKLoggingEnabled(jdkLoggingEnabled);
        this.info(XUMessageCode.INFO_LOGGER_JDK_LOGGING_ENABLED, new Object[]{jdkLoggingEnabled});
    }

    public void setAutoFlush(boolean autoFlush) {
        this.ulogger.setAutoFlush(autoFlush);
    }

    public boolean isAutoFlush() {
        return this.ulogger.isAutoFlush();
    }

    public void setLevel(Level level) throws PrivilegedActionException {
        this.getLogger().log(new XUSourceLogRecord.Entry(level));
        this.ulogger.setJCALoggerLevel(level);
        this.getLogger().log(new XUSourceLogRecord.Exit());
    }

    public Level getLevel() {
        return this.ulogger.getJCALoggerLevel();
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.ulogger.setJCALoggerWriter(logWriter);
    }

    public PrintWriter getLogWriter() {
        return this.ulogger.getJCALoggerWriter();
    }

    public void finest(String key, Object[] variableValues) {
        this.finest(key, variableValues, null);
    }

    public void finest(String key) {
        this.finest(key, null, null);
    }

    public void finest(String key, Object variableValue) {
        this.finest(key, new Object[]{variableValue});
    }

    public void finest(String key, Object[] variableValues, IlrXUContext xuContext) {
        this.write(this.ulogger, Level.FINEST, key, null, variableValues, xuContext);
    }

    public void finer(String msgKey, Object[] msgParams, IlrXUContext xuContext) {
        this.write(this.ulogger, Level.FINE, msgKey, null, msgParams, xuContext);
    }

    public void warning(String msgKey, Throwable throwable, Object[] variableValues, Object source, IlrXUContext xuContext, boolean log) {
        if (log) {
            this.write(this.ulogger, Level.WARNING, msgKey, throwable, variableValues, xuContext);
        }
        if (this.eventDispatcher != null && this.eventDispatcher.isEventFired(4L)) {
            IlrWarningEvent event = new IlrWarningEvent(source, throwable, msgKey, SerializableUtil.toSerializableArray(variableValues), xuContext);
            this.eventDispatcher.warningRaised(event);
        }
    }

    public void severe(String msgKey, Throwable throwable, Object[] variableValues, IlrXUContext xuContext) {
        this.write(this.ulogger, Level.SEVERE, msgKey, throwable, variableValues, xuContext);
        if (this.eventDispatcher != null && this.eventDispatcher.isEventFired(2L)) {
            IlrErrorEvent event = new IlrErrorEvent(-1, this, throwable, msgKey, SerializableUtil.toSerializableArray(variableValues), xuContext);
            this.eventDispatcher.errorRaised(event);
        }
    }

    public void fine(String msgKey, Object[] variableValues, IlrXUContext xuContext) {
        this.write(this.ulogger, Level.FINE, msgKey, null, variableValues, xuContext);
    }

    public void fine(String msgKey, Throwable t, Object[] variableValues, IlrXUContext xuContext) {
        this.write(this.ulogger, Level.FINE, msgKey, t, variableValues, xuContext);
    }

    public void info(String code, Object[] variableValues) {
        this.info(code, code, variableValues, null);
    }

    public void info(String code, String msgKey, Object[] variableValues, IlrXUContext xuContext) {
        this.write(this.ulogger, Level.INFO, msgKey, null, variableValues, xuContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LogRecord rec) {
        if (this.ulogger.isLoggable(rec.getLevel())) {
            this.ulogger.log(rec);
            List<LogListener> list = this.listeners;
            synchronized (list) {
                for (LogListener l : this.listeners) {
                    l.recordLogged(rec);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Logger plogger, Level level, String key, Throwable throwable, Object[] params, IlrXUContext xuContext) {
        if (plogger.isLoggable(level)) {
            XULogRecord rec = XULogRecordFactory.createXULogRecord(level, key, throwable, params, xuContext);
            plogger.log(rec);
            List<LogListener> list = this.listeners;
            synchronized (list) {
                for (LogListener l : this.listeners) {
                    l.recordLogged(rec);
                }
            }
        }
    }

    @Override
    public void ruleEngineEventRaised(IlrRuleEngineEvent event) {
        if (this.isLoggable(Level.FINE)) {
            Object[] parameters = ((IlrRuleEngineEventImpl)event).getParameters();
            Object[] variableValues = new Object[parameters.length + 3];
            variableValues[0] = event.getEngine();
            variableValues[1] = event.getCanonicalRulesetPath();
            variableValues[2] = event.getUserData();
            System.arraycopy(parameters, 0, variableValues, 3, parameters.length);
            this.fine(((IlrRuleEngineEventImpl)event).getMessageCode(), variableValues, ((IlrRuleEngineEventImpl)event).getXUContext());
        }
    }

    @Override
    public void profilingRulesetActionPerformed(IlrProfilingRulesetEvent event) {
        if (this.isLoggable(Level.FINE)) {
            Map<Long, IlrMeasure> measures = event.getMeasures();
            Object[] variableValues = new Object[]{event.getCanonicalRulesetPath(), this.measuresToProperties(measures)};
            this.fine(event.getMessageCode(), variableValues, event.getXUContext());
        }
    }

    @Override
    public void profilingRuleEngineActionPerformed(IlrProfilingRuleEngineEvent event) {
        if (this.isLoggable(Level.FINE)) {
            Map<Long, IlrMeasure> measures = event.getMeasures();
            Object[] variableValues = new Object[]{event.getCanonicalRulesetPath(), this.measuresToProperties(measures)};
            this.fine(event.getMessageCode(), variableValues, event.getXUContext());
        }
    }

    @Override
    public void profilingSessionActionPerformed(IlrProfilingSessionEvent event) {
        if (this.isLoggable(Level.FINE)) {
            Object[] variableValues = new Object[]{event.getProperties()};
            this.fine(event.getMessageCode(), variableValues, event.getXUContext());
        }
    }

    @Override
    public void profilingConnectionActionPerformed(IlrProfilingConnectionEvent event) {
        if (this.isLoggable(Level.FINE)) {
            Map<Long, IlrMeasure> measures = event.getMeasures();
            Object[] variableValues = new Object[]{this.measuresToProperties(measures)};
            this.fine(event.getMessageCode(), variableValues, event.getXUContext());
        }
    }

    @Override
    public void profilingManagedConnectionActionPerformed(IlrProfilingManagedConnectionEvent event) {
        if (this.isLoggable(Level.FINE)) {
            Map<Long, IlrMeasure> measures = event.getMeasures();
            Object[] variableValues = new Object[]{event.getCanonicalRulesetPath(), this.measuresToProperties(measures)};
            this.fine(event.getMessageCode(), variableValues, event.getXUContext());
        }
    }

    @Override
    public void profilingRulesetInformationProviderActionPerformed(IlrProfilingRulesetInformationProviderEvent event) {
        if (this.isLoggable(Level.FINE)) {
            Map<Long, IlrMeasure> measures = event.getMeasures();
            Object[] variableValues = new Object[]{event.getRulesetArchiveInformationProvider().getClass(), event.getCanonicalRulesetPath(), this.measuresToProperties(measures)};
            this.fine(event.getMessageCode(), variableValues, event.getXUContext());
        }
    }

    @Override
    public void localTransactionEventRaised(IlrLocalTransactionEvent event) {
        if (this.isLoggable(Level.FINEST)) {
            switch (event.getCode()) {
                case 0: {
                    this.finer("XU.FINER.4002", new Object[]{event.getManagedConnection()}, null);
                    break;
                }
                case 1: {
                    this.finer("XU.FINER.4012", new Object[]{event.getManagedConnection()}, null);
                    break;
                }
                case 2: {
                    this.finer("XU.FINER.4022", new Object[]{event.getManagedConnection()}, null);
                }
            }
        }
    }

    protected Properties measuresToProperties(Map<Long, IlrMeasure> measures) {
        Properties props = new Properties();
        for (IlrMeasure measure : measures.values()) {
            String messageCode = measure.getMessageCode();
            StringBuffer buffer = new StringBuffer();
            buffer.append(LocalizedMessageHelper.getLocalizedMessage("com.ibm.rules.res.xu.messages", messageCode, null, null, null));
            buffer.append('(');
            buffer.append(measure.getUnitDisplayValue());
            buffer.append(')');
            props.put(buffer.toString(), measure.getValue());
        }
        return props;
    }

    private void logLoggingStarted() {
        Logger l = this.ulogger.getJDKLogger();
        this.write(l, Level.INFO, XUMessageCode.INFO_LOGGING_STARTED, null, new Object[]{"Decision Server", "8.7.1.0", "2015-04-17 13:41:58"}, null);
        this.write(l, Level.INFO, XUMessageCode.INFO_LOGGER_JDK_LOGGING_LEVEL, null, new Object[]{LogHandler.getLevel(l)}, null);
        String osName = SystemPrivilegedAction.getProperty("os.name");
        String osArch = SystemPrivilegedAction.getProperty("os.arch");
        String osVersion = SystemPrivilegedAction.getProperty("os.version");
        String vmVersion = SystemPrivilegedAction.getProperty("java.vm.version");
        String vmVendor = SystemPrivilegedAction.getProperty("java.vm.vendor");
        String vmName = SystemPrivilegedAction.getProperty("java.vm.name");
        String clPath = SystemPrivilegedAction.getProperty("java.class.path");
        this.write(l, Level.INFO, XUMessageCode.INFO_OS, null, new Object[]{osName, osArch, osVersion}, null);
        this.write(l, Level.INFO, XUMessageCode.INFO_JVM, null, new Object[]{vmVersion, vmVendor, vmName}, null);
        this.write(l, Level.INFO, XUMessageCode.INFO_CLASSPATH, null, new Object[]{clPath}, null);
    }

    public Logger getLogger() {
        return this.ulogger;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, PrivilegedActionException {
        this.listeners = new ArrayList<LogListener>();
        in.defaultReadObject();
        this.ulogger = new XULogger();
        this.ulogger.setAutoFlush(in.readBoolean());
        this.ulogger.setJCALoggerLevel((Level)in.readObject());
        this.ulogger.setJDKLoggingEnabled(in.readBoolean());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.ulogger.isAutoFlush());
        out.writeObject(this.ulogger.getJCALoggerLevel());
        out.writeBoolean(this.ulogger.isJDKLoggingEnabled());
    }
}

