/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.log.internal;

import com.ibm.rules.res.logging.internal.RESFormatter;
import com.ibm.rules.res.logging.internal.XULogRecord;
import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.log.internal.WriterHandler;
import com.ibm.rules.res.xu.log.internal.XULogRecordFactory;
import com.ibm.rules.res.xu.security.internal.HandlerPrivilegedAction;
import com.ibm.rules.res.xu.security.internal.LoggerPrivilegedExceptionAction;
import java.io.PrintWriter;
import java.security.PrivilegedActionException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

final class XULogger
extends Logger {
    private static final String LOGGER_NAME = "com.ibm.rules.res.execution";
    private boolean autoFlush = false;
    private transient Logger jcaLogger;
    private Level jcaLevel = Level.FINE;
    private transient PrintWriter jcaWriter;
    private boolean jdkLoggingEnabled;
    private transient Logger jdkLogger;
    private transient Logger logger;

    XULogger() {
        super(null, "com.ibm.rules.res.xu.messages");
        this.setUseParentHandlers(false);
        this.initJDKLogger();
        this.initJCALogger();
        this.setJDKLoggingEnabled(false);
    }

    synchronized boolean isJDKLoggingEnabled() {
        return this.jdkLoggingEnabled;
    }

    synchronized void setJDKLoggingEnabled(boolean jdkLoggingEnabled) {
        this.jdkLoggingEnabled = jdkLoggingEnabled;
        this.logger = jdkLoggingEnabled ? this.jdkLogger : this.jcaLogger;
        this.setLevel(this.logger.getLevel());
    }

    private void initJDKLogger() {
        LogManager mgr = LogManager.getLogManager();
        this.jdkLogger = mgr.getLogger(LOGGER_NAME);
        if (this.jdkLogger == null) {
            this.jdkLogger = Logger.getLogger(LOGGER_NAME, "com.ibm.rules.res.xu.messages");
        }
    }

    private void initJCALogger() {
        this.jcaLogger = Logger.getAnonymousLogger("com.ibm.rules.res.xu.messages");
        this.jcaLogger.setUseParentHandlers(false);
        try {
            this.setJCALoggerLevel(this.jcaLevel);
        }
        catch (PrivilegedActionException e) {
            XULogRecord rec = XULogRecordFactory.createXULogRecord(Level.SEVERE, "XU.ERROR.10600", e, null, null);
            this.jcaLogger.log(rec);
        }
        this.setJCALoggerWriter(null);
    }

    Logger getJDKLogger() {
        return this.jdkLogger;
    }

    Logger getJCALogger() {
        return this.jcaLogger;
    }

    synchronized void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    synchronized boolean isAutoFlush() {
        return this.autoFlush;
    }

    synchronized void setJCALoggerWriter(PrintWriter jcaWriter) {
        this.jcaWriter = jcaWriter;
        Handler[] handlers = this.jcaLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            this.jcaLogger.removeHandler(handlers[i]);
        }
        if (jcaWriter != null) {
            WriterHandler handler = new WriterHandler(jcaWriter);
            HandlerPrivilegedAction.setFormatter(handler, new RESFormatter());
            this.jcaLogger.addHandler(handler);
            XULogRecord rec = XULogRecordFactory.createXULogRecord(Level.INFO, XUMessageCode.INFO_LOGGING_STARTED, null, new Object[]{"Decision Server", "8.7.1.0", "2015-04-17 13:41:58"}, null);
            this.jcaLogger.log(rec);
        }
    }

    synchronized PrintWriter getJCALoggerWriter() {
        return this.jcaWriter;
    }

    synchronized void setJCALoggerLevel(Level jcaLevel) throws PrivilegedActionException {
        this.jcaLogger.log(new XUSourceLogRecord.Entry(jcaLevel));
        this.jcaLevel = jcaLevel;
        LoggerPrivilegedExceptionAction.setLevel(this.jcaLogger, jcaLevel);
        if (!this.isJDKLoggingEnabled()) {
            this.setLevel(jcaLevel);
        }
        for (Handler h : this.jcaLogger.getHandlers()) {
            h.setLevel(jcaLevel);
        }
        this.jcaLogger.log(new XUSourceLogRecord.Exit());
    }

    synchronized Level getJCALoggerLevel() {
        return this.jcaLevel;
    }

    @Override
    public boolean isLoggable(Level l) {
        return this.logger.isLoggable(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        Handler[] handlers;
        XULogger xULogger = this;
        synchronized (xULogger) {
            handlers = this.logger.getHandlers();
        }
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].flush();
        }
    }

    @Override
    public void log(LogRecord rec) {
        this.logger.log(rec);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public synchronized Logger getLogger() {
        return this.logger;
    }
}

