/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.management;

import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.management.XUMonitoringPlugin;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.xu.management.IlrXUMonitoringMBean;
import java.util.Properties;

public class XUManagementPlugin
extends XUMonitoringPlugin {
    public void notifyRulesetArchiveChanged(String canonicalRulesetPath) throws XUException {
        try {
            this.notifyRulesetArchiveChanged(IlrPath.parsePath(canonicalRulesetPath));
        }
        catch (IlrFormatException e) {
            throw new XUException("XU.ERROR.10048", e);
        }
    }

    @Override
    protected IlrXUMonitoringMBean createMBean() {
        return this.mbeanFactory.createXUManagementMBean(this);
    }

    @Override
    protected String getMBeanType() {
        return "IlrXUManagement";
    }

    @Override
    protected Properties getMBeanProperties() {
        Properties props = new Properties();
        props.setProperty("xuId", "IlrXU");
        props.setProperty("xuType", "management");
        props.setProperty("xuVersion", "8.7.1.0");
        props.setProperty("xuUpdate", "1");
        if (this.xuName != null) {
            props.setProperty("xuName", this.xuName);
        }
        return props;
    }
}

