/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.plugin.internal;

import com.ibm.rules.res.xu.event.ConnectionEvent;
import com.ibm.rules.res.xu.event.RuleEvent;
import com.ibm.rules.res.xu.event.RulesetArchiveEvent;
import com.ibm.rules.res.xu.event.TaskEvent;
import com.ibm.rules.res.xu.plugin.EventPlugin;
import com.ibm.rules.res.xu.plugin.PluginException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Map;

public class EventLoggerPlugin
extends EventPlugin {
    protected PrintWriter out;

    @Override
    public void start(Map<String, String> props) throws PluginException {
        String path = props.get("path");
        if (path != null && !path.trim().isEmpty()) {
            try {
                this.out = new PrintWriter(new FileOutputStream(path, true));
            }
            catch (FileNotFoundException e) {
                throw new PluginException("XU.ERROR.10020", new Object[]{this.getClass().getName()}, (Throwable)e);
            }
        } else {
            this.out = new PrintWriter(System.out);
        }
        this.out.println("Plugin " + this.getClass().getName() + " started");
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskCompleted(TaskEvent evt) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.print(evt.getConnectionId().toString());
            this.out.print(' ');
            this.out.print(evt.getCanonicalRulesetPath());
            this.out.print(" taskCompleted ");
            this.out.println(evt.getName());
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskStarted(TaskEvent evt) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.print(evt.getConnectionId().toString());
            this.out.print(' ');
            this.out.print(evt.getCanonicalRulesetPath());
            this.out.print(" taskStarted ");
            this.out.println(evt.getName());
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ruleExecutionCompleted(RuleEvent evt) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.print(evt.getConnectionId().toString());
            this.out.print(' ');
            this.out.print(evt.getCanonicalRulesetPath());
            this.out.print(" ruleExecutionCompleted ");
            this.out.println(evt.getName());
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ruleExecutionStarted(RuleEvent evt) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.print(evt.getConnectionId().toString());
            this.out.print(' ');
            this.out.print(evt.getCanonicalRulesetPath());
            this.out.print(" ruleExecutionStarted ");
            this.out.println(evt.getName());
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionOpened(ConnectionEvent evt) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.print(evt.getConnectionId().toString());
            this.out.println(" connectionOpened");
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ConnectionEvent evt) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.print(evt.getConnectionId().toString());
            this.out.println(" connectionClosed");
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rulesetArchiveChanged(RulesetArchiveEvent evt) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.print(evt.getCanonicalRulesetPath());
            this.out.println(" rulesetArchiveChanged");
            this.out.flush();
        }
    }
}

