/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.pool.internal;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.pool.internal.ObjectFactory;
import ilog.rules.res.xu.pool.IlrPool;
import ilog.rules.res.xu.pool.IlrPoolException;
import ilog.rules.res.xu.pool.IlrPoolListener;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Logger;

public abstract class BasePoolImpl<T>
implements IlrPool<T> {
    protected ObjectFactory<T> factory;
    protected ArrayList<IlrPoolListener<T>> listeners = new ArrayList();
    protected String displayName;
    protected Logger log;

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.getClass().getSimpleName();
        }
        return this.displayName;
    }

    @Override
    public void setLogger(Logger log) {
        this.log = log;
    }

    @Override
    public synchronized void addPoolEventListener(IlrPoolListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removePoolEventListener(IlrPoolListener<T> listener) {
        this.listeners.remove(listener);
    }

    public synchronized void sendObjectRemovedEvent(T removedObject) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            IlrPoolListener<T> listener = this.listeners.get(i);
            listener.objectRemoved(removedObject);
        }
    }

    public synchronized T get() throws IlrPoolException, UnsupportedOperationException {
        T result;
        this.waitNotFull();
        if (!this.isFull()) {
            Set objs = this.getFreeObjects();
            if (objs.isEmpty()) {
                result = this.factory.create();
                this.add(result);
            } else {
                result = objs.iterator().next();
            }
        } else {
            throw new IlrPoolException(XUMessageCode.ERROR_POOL_FULL, null);
        }
        this.use(result);
        return result;
    }

    public synchronized void initialize(ObjectFactory<T> factory) {
        this.factory = factory;
    }
}

