/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.pool.internal;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.log.internal.XULogRecordFactory;
import com.ibm.rules.res.xu.pool.internal.ObjectFactory;
import com.ibm.rules.res.xu.pool.internal.SizedPool;
import com.ibm.rules.res.xu.pool.internal.SizedPoolImpl;
import ilog.rules.res.xu.pool.IlrPoolException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class PoolImpl<T>
extends SizedPoolImpl<T>
implements SizedPool<T> {
    protected int freeObjectsCount = 0;
    public static final long DEFAULT_WAIT_TIMEOUT = -1L;
    public static final String PROPERTY_KEY_WAIT_TIMEOUT = "pool.waitTimeout";
    protected long waitTimeout = -1L;
    protected Object[] freeObjects = null;
    protected Set<T> freeObjectsSet = null;
    protected Set<T> usedObjects = null;

    @Override
    public synchronized int getFreeObjectsCount() {
        return this.freeObjectsCount;
    }

    @Override
    public synchronized int getUsedObjectsCount() {
        return this.usedObjects.size();
    }

    @Override
    public synchronized void add(T object) {
        if (this.usedObjects.size() == this.maxPoolSize) {
            return;
        }
        if (this.freeObjectsCount + this.usedObjects.size() == this.maxPoolSize) {
            Object removedObject = this.freeObjects[0];
            for (int i = 1; i < this.freeObjectsCount; ++i) {
                this.freeObjects[i - 1] = this.freeObjects[i];
            }
            this.freeObjects[this.freeObjectsCount - 1] = object;
            this.freeObjectsSet.remove(removedObject);
            this.freeObjectsSet.add(object);
            this.sendObjectRemovedEvent(removedObject);
        } else {
            this.freeObjects[this.freeObjectsCount++] = object;
            this.freeObjectsSet.add(object);
        }
    }

    @Override
    public synchronized Set<T> getFreeObjects() {
        return this.freeObjectsSet;
    }

    @Override
    public synchronized void use(T object) {
        for (int i = 0; i < this.freeObjectsCount; ++i) {
            Object freeObject = this.freeObjects[i];
            if (freeObject != object) continue;
            this.usedObjects.add(freeObject);
            System.arraycopy(this.freeObjects, i + 1, this.freeObjects, i, this.freeObjectsCount - i - 1);
            --this.freeObjectsCount;
            this.freeObjectsSet.remove(object);
            return;
        }
    }

    @Override
    public synchronized void release(T object) {
        if (this.usedObjects.remove(object)) {
            this.freeObjects[this.freeObjectsCount++] = object;
            this.freeObjectsSet.add(object);
            this.notifyAll();
        }
    }

    @Override
    public synchronized boolean remove(T object) {
        for (int i = 0; i < this.freeObjectsCount; ++i) {
            Object freeObject = this.freeObjects[i];
            if (freeObject != object) continue;
            for (int j = i + 1; j < this.freeObjectsCount; ++j) {
                this.freeObjects[j - 1] = this.freeObjects[j];
            }
            --this.freeObjectsCount;
            this.freeObjectsSet.remove(object);
            this.sendObjectRemovedEvent(object);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isFull() {
        return this.usedObjects.size() == this.maxPoolSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitNotFull() throws IlrPoolException, UnsupportedOperationException {
        PoolImpl poolImpl = this;
        synchronized (poolImpl) {
            long start;
            if (this.waitTimeout < 0L) {
                if (this.isFull()) {
                    throw new IlrPoolException(XUMessageCode.ERROR_POOL_FULL, null);
                }
                return;
            }
            long l = start = this.waitTimeout == 0L ? 0L : System.currentTimeMillis();
            while (this.isFull()) {
                if (this.waitTimeout > 0L && System.currentTimeMillis() - start > this.waitTimeout) {
                    throw new IlrPoolException(XUMessageCode.ERROR_POOL_FULL_TIMEOUT_REACHED, new Object[]{this.waitTimeout});
                }
                try {
                    this.wait(this.waitTimeout);
                }
                catch (InterruptedException e) {
                    throw new IlrPoolException(XUMessageCode.ERROR_POOL, null);
                }
            }
            return;
        }
    }

    @Override
    public void initialize(Map<String, String> properties) {
        this.initialize(properties, null);
    }

    @Override
    public void initialize(Map<String, String> properties, ObjectFactory<T> factory) {
        String p;
        if (properties != null && (p = properties.get(PROPERTY_KEY_WAIT_TIMEOUT)) != null) {
            this.waitTimeout = Integer.parseInt(p);
        }
        super.initialize(properties, factory);
        this.init();
    }

    public void initialize(long waitTimeout, int maxPoolSize, ObjectFactory<T> factory) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(PROPERTY_KEY_WAIT_TIMEOUT, Long.toString(waitTimeout));
        props.put("pool.maxSize", Integer.toString(maxPoolSize));
        this.initialize(props, factory);
    }

    protected void init() {
        this.log.log(XULogRecordFactory.createXULogRecord(Level.INFO, XUMessageCode.INFO_POOL_WAIT_TIMEOUT, null, new Object[]{this.waitTimeout}, null));
        this.freeObjectsCount = 0;
        this.freeObjects = new Object[this.maxPoolSize];
        this.usedObjects = new HashSet<T>(this.maxPoolSize);
        this.freeObjectsSet = new HashSet<T>(this.maxPoolSize);
    }
}

