/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.ruleset.internal;

import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.rules.res.xu.engine.cre.internal.CREEngine;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.io.internal.SerializableUtil;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetImpl;
import ilog.rules.engine.IlrRule;
import ilog.rules.engine.IlrRuleset;
import ilog.rules.engine.IlrRulesetParameter;
import ilog.rules.engine.IlrTask;
import ilog.rules.factory.IlrPropertyList;
import ilog.rules.factory.IlrReflect;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.session.ruleset.IlrRuleInformation;
import ilog.rules.res.session.ruleset.IlrTaskInformation;
import ilog.rules.res.xu.cci.ruleset.impl.IlrRuleInformationImpl;
import ilog.rules.res.xu.cci.ruleset.impl.IlrTaskInformationImpl;
import ilog.rules.res.xu.ruleset.archive.internal.IlrXURulesetArchiveInformation;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationImpl;
import ilog.rules.res.xu.ruleset.trace.internal.IlrBusinessNameConverter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public final class CRERulesetImpl
extends XURulesetImpl {
    private final IlrRuleset creRuleset;
    private IlrReflect reflect;

    public CRERulesetImpl(IlrRuleset creRuleset, String canonicalRulesetPath, IlrRulesetArchiveProperties archiveProps, ClassLoader xomClassLoader, IlrXURulesetArchiveInformation archive, Collection<String> warnings, LogHandler logger, IlrRulesetUsageInformationImpl usage) {
        super(canonicalRulesetPath, archiveProps, xomClassLoader, archive, warnings, logger, usage);
        this.creRuleset = creRuleset;
    }

    @Override
    protected final Object getRootObject() {
        return this.creRuleset;
    }

    @Override
    protected final Map<String, IlrRuleInformation> retrieveAllRules() {
        IlrRule[] rules = this.creRuleset.getAllRules();
        HashMap<String, IlrRuleInformation> allRules = new HashMap<String, IlrRuleInformation>(rules.length);
        for (IlrRule r : rules) {
            String name = r.getName();
            IlrPropertyList props = r.getProperties();
            Map<String, Serializable> ruleProps = SerializableUtil.toSerializableMap(props);
            String bname = IlrBusinessNameConverter.toBusinessName(name, props);
            IlrRuleInformationImpl rule = new IlrRuleInformationImpl(name, bname, ruleProps, null);
            allRules.put(rule.getName(), rule);
        }
        return allRules;
    }

    @Override
    public final Map<String, IlrTaskInformation> retrieveAllTasks() {
        IlrTask[] tasks = this.creRuleset.getAllTasks();
        HashMap<String, IlrTaskInformation> result = new HashMap<String, IlrTaskInformation>(tasks.length);
        for (IlrTask r : tasks) {
            String name = r.getName();
            IlrPropertyList props = r.getProperties();
            HashMap<String, Object> ruleProps = new HashMap<String, Object>(props.size());
            Enumeration enumeration = props.elements();
            while (enumeration.hasMoreElements()) {
                IlrPropertyList.Entry entry = (IlrPropertyList.Entry)enumeration.nextElement();
                ruleProps.put(entry.getKey(), entry.getValue());
            }
            String bname = IlrBusinessNameConverter.toBusinessName(name, props);
            IlrTaskInformationImpl task = new IlrTaskInformationImpl(name, bname, ruleProps);
            result.put(task.getName(), task);
        }
        return result;
    }

    @Override
    protected final XURulesetParameter[] retrieveRulesetParameters() {
        IlrRulesetParameter[] sig = this.creRuleset.getRulesetSignature();
        XURulesetParameter[] result = new XURulesetParameter[sig.length];
        int i = 0;
        for (IlrRulesetParameter param : sig) {
            byte dir;
            int kind = param.getKind();
            int modifier = param.getModifier();
            switch (modifier) {
                case 2: {
                    dir = 1;
                    break;
                }
                case 4: {
                    dir = 2;
                    break;
                }
                case 6: {
                    dir = 4;
                    break;
                }
                default: {
                    dir = 0;
                }
            }
            result[i++] = CRERulesetImpl.createRulesetParameter(param.getName(), (byte)kind, dir, param.getType(), param.getType().getFullyQualifiedName(), null);
        }
        return result;
    }

    @Override
    public IlrRuleset getCRERuleset() {
        return this.creRuleset;
    }

    @Override
    public synchronized IlrReflect getBOMReflect() throws XUException {
        if (this.reflect == null) {
            this.reflect = CREEngine.getBOMReflect(this.creRuleset);
        }
        return this.reflect;
    }
}

