/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.ruleset.internal;

import com.ibm.rules.engine.connector.DataConnectorException;
import com.ibm.rules.engine.connector.DataConnectorFactory;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.rules.res.xu.engine.xml.internal.XMLObjectService;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import ilog.rules.bom.IlrType;
import ilog.rules.factory.IlrReflect;
import ilog.rules.factory.IlrXomClass;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.mprofiler.IlrMemoryInstrumentation;
import ilog.rules.res.mprofiler.IlrMemoryProfiler;
import ilog.rules.res.mprofiler.IlrObjectInfoImpl;
import ilog.rules.res.mprofiler.IlrProfilerException;
import ilog.rules.res.session.ruleset.IlrRuleInformation;
import ilog.rules.res.session.ruleset.IlrTaskInformation;
import ilog.rules.res.xu.dataconnector.internal.IlrDataConnectorHelper;
import ilog.rules.res.xu.ruleset.IlrXURuleset;
import ilog.rules.res.xu.ruleset.archive.internal.IlrXURulesetArchiveInformation;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationImpl;
import ilog.rules.xml.binding.IlrXmlClassDriver;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class XURulesetImpl
implements IlrXURuleset {
    private final ClassLoader xomClassLoader;
    private final IlrXURulesetArchiveInformation archive;
    private Object dcFactory;
    private XURulesetParameter[] parameters;
    private Map<String, XURulesetParameter> parametersMap;
    private final String canonicalPath;
    private final Collection<String> warnings;
    private final XMLObjectService xmlObjectService;
    private final IlrRulesetArchiveProperties archiveProps;
    protected final LogHandler logger;
    private Map<String, IlrRuleInformation> allRules;
    private long estimatedMemorySize = -1L;
    private Map<String, IlrTaskInformation> allTasks;
    private final IlrRulesetUsageInformationImpl usage;

    public XURulesetImpl(String canonicalRulesetPath, IlrRulesetArchiveProperties archiveProps, ClassLoader xomClassLoader, IlrXURulesetArchiveInformation archive, Collection<String> warnings, LogHandler logger, IlrRulesetUsageInformationImpl usage) {
        this.canonicalPath = canonicalRulesetPath;
        this.archiveProps = archiveProps;
        this.xomClassLoader = xomClassLoader;
        this.warnings = warnings;
        this.logger = logger;
        this.archive = archive;
        this.usage = usage;
        this.xmlObjectService = this.createXMLObjectService();
    }

    public final IlrRulesetUsageInformationImpl getRulesetUsageInformation() {
        return this.usage;
    }

    public final IlrXURulesetArchiveInformation getArchive() {
        return this.archive;
    }

    public final synchronized long getRulesetEstimatedMemorySize() throws IlrProfilerException {
        if (this.estimatedMemorySize <= 0L) {
            IlrMemoryProfiler profiler = IlrMemoryInstrumentation.getMemoryProfiler();
            if (profiler == null) {
                return -1L;
            }
            Object rootObject = this.getRootObject();
            IlrObjectInfoImpl info = profiler.getObjectInfo(rootObject);
            this.estimatedMemorySize = info.getTotalSize();
        }
        return this.estimatedMemorySize;
    }

    protected abstract Object getRootObject();

    @Override
    public final IlrRulesetArchiveProperties getRulesetArchiveProperties() {
        return this.archiveProps;
    }

    @Override
    public final String getCanonicalRulesetPath() {
        return this.canonicalPath;
    }

    public final ClassLoader getManagedXOMClassLoader() {
        return this.archive.getManagedXOMClassLoader();
    }

    @Override
    public final ClassLoader getXOMClassLoader() {
        return this.xomClassLoader;
    }

    public final ClassLoader getRulesetXOMClassLoader() {
        ClassLoader cl = this.getManagedXOMClassLoader();
        if (cl == null) {
            return this.xomClassLoader;
        }
        return cl;
    }

    public final Collection<String> getWarnings() {
        return this.warnings;
    }

    private XMLObjectService createXMLObjectService() {
        int max = this.archiveProps.getXMLDocumentDriverPoolMaxSize();
        long timeout = this.archiveProps.getXMLDocumentDriverPoolReserveTimeout();
        XMLObjectService srv = new XMLObjectService(this, max, timeout, this.logger);
        return srv;
    }

    public final XMLObjectService getXMLObjectService() {
        return this.xmlObjectService;
    }

    public final synchronized Map<String, IlrRuleInformation> getRules() {
        if (this.allRules == null) {
            this.allRules = this.retrieveAllRules();
        }
        return this.allRules;
    }

    protected abstract Map<String, IlrRuleInformation> retrieveAllRules();

    protected abstract Map<String, IlrTaskInformation> retrieveAllTasks();

    public final synchronized Map<String, IlrTaskInformation> getTasks() {
        if (this.allTasks == null) {
            this.allTasks = this.retrieveAllTasks();
        }
        return this.allTasks;
    }

    private final Object createDataConnectorFactory() throws DataConnectorException {
        String cname = this.archiveProps.getDataConnectorClass();
        if (cname == null) {
            return null;
        }
        DataConnectorFactory dcf = this.getManagedXOMClassLoader() == null ? IlrDataConnectorHelper.createDataConnectorFactory(cname, this.xomClassLoader) : IlrDataConnectorHelper.createDataConnectorFactory(cname, this.getManagedXOMClassLoader());
        try {
            String key = "dataconnector.factory.property.";
            Map<String, String> props = IlrDataConnectorHelper.extractProperties(key, this.archiveProps);
            dcf.initialize(props);
        }
        catch (DataConnectorException e) {
            dcf = null;
            throw e;
        }
        return dcf;
    }

    public final synchronized Object getDataConnectorFactory() throws DataConnectorException {
        if (this.dcFactory == null) {
            this.dcFactory = this.createDataConnectorFactory();
        }
        return this.dcFactory;
    }

    public final synchronized XURulesetParameter[] getRulesetParameters() {
        if (this.parameters == null) {
            this.parameters = this.retrieveRulesetParameters();
        }
        return this.parameters;
    }

    protected abstract XURulesetParameter[] retrieveRulesetParameters();

    public final synchronized Map<String, XURulesetParameter> getRulesetParametersMap() {
        if (this.parametersMap == null) {
            XURulesetParameter[] params = this.getRulesetParameters();
            this.parametersMap = new HashMap<String, XURulesetParameter>(params.length);
            for (XURulesetParameter p : params) {
                this.parametersMap.put(p.getName(), p);
            }
        }
        return this.parametersMap;
    }

    protected static XURulesetParameter createRulesetParameter(String name, byte kind, byte dir, IlrType type, String typeName, Integer arrayDimension) {
        Byte componentKind;
        boolean isArray;
        String xmlType;
        if (type != null) {
            xmlType = kind == 1 ? type.getFullyQualifiedName() : null;
            isArray = type.isArray();
            componentKind = isArray ? XURulesetImpl.getComponentKind(type) : null;
        } else {
            isArray = false;
            componentKind = null;
            xmlType = null;
        }
        return new XURulesetParameter(name, typeName, kind, dir, isArray, componentKind, arrayDimension, xmlType);
    }

    private static Byte getComponentKind(IlrType type) {
        IlrType componentType = type.getComponentType();
        if (componentType instanceof IlrXomClass && ((IlrXomClass)componentType).getDriver() instanceof IlrXmlClassDriver) {
            return (byte)1;
        }
        return (byte)0;
    }

    public abstract IlrReflect getBOMReflect() throws XUException;
}

