/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.spi.config.internal;

import com.ibm.rules.res.persistence.internal.PersistencePropertiesConverter;
import com.ibm.rules.res.xu.config.internal.PersistenceConfig;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.xu.persistence.IlrFilePersistence;
import ilog.rules.res.xu.spi.IlrManagedXUConnectionFactory;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SPIPersistenceConfigImpl
implements PersistenceConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    protected IlrManagedXUConnectionFactory factory;
    protected String type = IlrFilePersistence.class.getName();
    protected Map<String, String> props;

    public SPIPersistenceConfigImpl(IlrManagedXUConnectionFactory factory) {
        this.factory = factory;
        this.props = new HashMap<String, String>();
    }

    @Override
    public File getDirectory() throws XUException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDirectory(File file) throws XUException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putProperty(String k, String v) throws XUException {
        throw new UnsupportedOperationException();
    }

    public void setProperties(Map<String, String> props) throws XUException {
        this.props = props;
        Map<String, String> obfuscatedProps = PersistencePropertiesConverter.obfuscate(props);
        this.factory.getLogHandler().info("XU.INFO.8001", new Object[]{"persistenceProperties", obfuscatedProps});
        if (this.factory.getPersistence(false) != null) {
            this.factory.getPersistence(false).setProperties(props);
        }
        this.factory.sendPropertyChanged("persistenceProperties");
    }

    @Override
    public Map<String, String> getProperties() throws XUException {
        return this.props;
    }

    @Override
    public String getProperty(String k) throws XUException {
        return this.props.get(k);
    }

    @Override
    public void setType(String newType) throws XUException {
        this.factory.getLogHandler().info("XU.INFO.8001", new Object[]{"persistenceType", newType});
        if (newType != null) {
            newType = newType.trim();
        }
        if (this.type.equals(newType)) {
            return;
        }
        this.destroyPersistence();
        this.type = newType;
        this.factory.sendPropertyChanged("persistenceType");
    }

    @Override
    public String getType() throws XUException {
        return this.type;
    }

    protected void destroyPersistence() throws XUException {
        if (this.factory.getPersistence(false) != null) {
            this.factory.getPersistence(false).destroy();
        }
    }

    public int hashCode() {
        return ((Object)this.props).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SPIPersistenceConfigImpl) {
            try {
                return ((Object)this.props).equals(((SPIPersistenceConfigImpl)o).getProperties());
            }
            catch (XUException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isConcurrentAccessEnabled() throws XUException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setConcurrentAccessEnabled(boolean enabled) throws XUException {
        throw new UnsupportedOperationException();
    }
}

