/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.spi.config.internal;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.client.internal.jca.DescriptorException;
import com.ibm.rules.res.xu.config.internal.ConnectionPoolConfig;
import com.ibm.rules.res.xu.config.internal.PersistenceConfig;
import com.ibm.rules.res.xu.config.internal.PluginConfig;
import com.ibm.rules.res.xu.config.internal.PoolConfig;
import com.ibm.rules.res.xu.config.internal.RulesetCacheConfig;
import com.ibm.rules.res.xu.config.internal.XUConfig;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.spi.config.internal.SPIConnectionPoolConfigImpl;
import com.ibm.rules.res.xu.spi.config.internal.SPIPersistenceConfigImpl;
import com.ibm.rules.res.xu.spi.config.internal.SPIPoolConfigImpl;
import com.ibm.rules.res.xu.spi.config.internal.SPIRulesetCacheConfigImpl;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationMonitorImpl;
import ilog.rules.res.xu.spi.IlrManagedXUConnectionFactory;
import java.io.InputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public final class SPIXUConfigImpl
implements XUConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private final RulesetCacheConfig rulesetCacheConfig;
    private final IlrManagedXUConnectionFactory factory;
    private Boolean asyncRulesetParsing = Boolean.FALSE;
    private Boolean rulesetUsageMonitorEnabled = Boolean.FALSE;
    private Boolean concurrentOpenClose = Boolean.FALSE;
    private final PersistenceConfig persistenceConfig;
    private final Map<String, String> caCacheProps;
    private final SPIPoolConfigImpl docPoolConfig;
    private final SPIPoolConfigImpl trPoolConfig;
    private final SPIConnectionPoolConfigImpl connPoolConfig;

    public SPIXUConfigImpl(IlrManagedXUConnectionFactory factory) {
        this.factory = factory;
        this.rulesetCacheConfig = new SPIRulesetCacheConfigImpl();
        this.persistenceConfig = new SPIPersistenceConfigImpl(factory);
        this.caCacheProps = new HashMap<String, String>();
        this.docPoolConfig = new SPIPoolConfigImpl(0L);
        this.trPoolConfig = new SPIPoolConfigImpl(0L);
        this.connPoolConfig = new SPIConnectionPoolConfigImpl();
    }

    @Override
    public final ConnectionPoolConfig getConnectionPoolConfig() throws XUException {
        return this.connPoolConfig;
    }

    @Override
    public final PoolConfig getDocumentBuilderPoolConfig() throws XUException {
        return this.docPoolConfig;
    }

    @Override
    public final PoolConfig getTransformerPoolConfig() throws XUException {
        return this.trPoolConfig;
    }

    @Override
    public final void setLogLevel(Level lvl) throws XUException {
        this.factory.getLogHandler().info("XU.INFO.8001", new Object[]{"traceLevel", lvl.getName()});
        try {
            this.factory.getLogHandler().setLevel(lvl);
            this.factory.isFinestLoggable = this.factory.getLogHandler().isLoggable(Level.FINEST);
        }
        catch (PrivilegedActionException e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_SET_PROPERTY_FAIL, new String[]{"logLevel"}, (Throwable)e);
        }
        this.factory.sendPropertyChanged("traceLevel");
    }

    @Override
    public final Level getLogLevel() throws XUException {
        return this.factory.getLogHandler().getLevel();
    }

    @Override
    public final void setLogAutoFlush(Boolean autoFlush) throws XUException {
        this.factory.getLogHandler().info("XU.INFO.8001", new Object[]{"logAutoFlush", autoFlush});
        this.factory.getLogHandler().setAutoFlush(autoFlush);
        this.factory.sendPropertyChanged("logAutoFlush");
    }

    @Override
    public final Boolean getLogAutoFlush() throws XUException {
        return this.factory.getLogHandler().isAutoFlush();
    }

    @Override
    public final PersistenceConfig getPersistenceConfig() throws XUException {
        return this.persistenceConfig;
    }

    @Override
    public final RulesetCacheConfig getRulesetCacheConfig() throws XUException {
        return this.rulesetCacheConfig;
    }

    @Override
    public final void loadJCADescriptor(InputStream in) throws DescriptorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setPluginConfigs(List<PluginConfig> p) throws XUException {
        this.factory.setPluginConfigs(p);
    }

    @Override
    public final List<PluginConfig> getPluginConfigs() throws XUException {
        return this.factory.getPluginManager().getPluginConfigs();
    }

    @Override
    public final void setProfilingInfoLogged(boolean enable) throws XUException {
        this.factory.getLogHandler().info("XU.INFO.8001", new Object[]{"profilingEnabled", enable});
        this.factory.getProfiling().setEnabled(enable);
        this.factory.sendPropertyChanged("profilingEnabled");
    }

    @Override
    public final Boolean isProfilingInfoLogged() throws XUException {
        return this.factory.getProfiling().isEnabled();
    }

    @Override
    public final Boolean isRulesetUsageMonitorEnabled() throws XUException {
        return this.rulesetUsageMonitorEnabled;
    }

    @Override
    public final void setRulesetUsageMonitorEnabled(Boolean enable) throws XUException {
        this.factory.getLogHandler().info("XU.INFO.8001", new Object[]{"rulesetUsageMonitorEnabled", enable});
        this.rulesetUsageMonitorEnabled = enable;
        IlrRulesetUsageInformationMonitorImpl monitor = enable != false ? this.factory.getRulesetUsageMonitor() : null;
        this.factory.getPluginManager().setRulesetUsageMonitor(monitor);
        this.factory.sendPropertyChanged("rulesetUsageMonitorEnabled");
    }

    @Override
    public final Boolean isAsynchronousRulesetParsingEnabled() throws XUException {
        return this.asyncRulesetParsing;
    }

    @Override
    public final void setAsynchronousRulesetParsingEnabled(Boolean enable) throws XUException {
        this.asyncRulesetParsing = enable;
    }

    @Override
    public final Boolean isConcurrentOpenCloseEnabled() throws XUException {
        return this.concurrentOpenClose;
    }

    @Override
    public final void setConcurrentOpenCloseEnabled(Boolean enable) throws XUException {
        this.factory.getLogHandler().info("XU.INFO.8001", new Object[]{"concurrentOpenClose", enable});
        this.concurrentOpenClose = enable != false ? Boolean.TRUE : Boolean.FALSE;
        this.factory.sendPropertyChanged("concurrentOpenClose");
    }

    @Override
    public final void setCompiledArchivesCacheProperties(Map<String, String> props) throws XUException {
        this.factory.getLogHandler().info("XU.INFO.8001", new Object[]{"caCacheProps", props});
        this.caCacheProps.clear();
        this.caCacheProps.putAll(props);
    }

    @Override
    public final Map<String, String> getCompiledArchivesCacheProperties() throws XUException {
        return Collections.unmodifiableMap(this.caCacheProps);
    }

    public int hashCode() {
        return this.persistenceConfig.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SPIXUConfigImpl) {
            SPIXUConfigImpl cfg = (SPIXUConfigImpl)o;
            try {
                return this.persistenceConfig.equals(cfg.getPersistenceConfig()) && this.getLogLevel().equals(cfg.getLogLevel()) && ((Object)this.caCacheProps).equals(cfg.getCompiledArchivesCacheProperties()) && this.connPoolConfig.equals(cfg.getConnectionPoolConfig()) && this.docPoolConfig.equals(cfg.getDocumentBuilderPoolConfig()) && this.getLogAutoFlush().equals(cfg.getLogAutoFlush()) && ((Object)this.getPluginConfigs()).equals(cfg.getPluginConfigs()) && this.getRulesetCacheConfig().equals(cfg.getRulesetCacheConfig()) && this.getTransformerPoolConfig().equals(cfg.getTransformerPoolConfig()) && this.isAsynchronousRulesetParsingEnabled().equals(cfg.isAsynchronousRulesetParsingEnabled()) && this.concurrentOpenClose.equals(cfg.isConcurrentOpenCloseEnabled()) && this.isProfilingInfoLogged().equals(cfg.isProfilingInfoLogged()) && this.isRulesetUsageMonitorEnabled().equals(cfg.isRulesetUsageMonitorEnabled());
            }
            catch (XUException e) {
                return false;
            }
        }
        return false;
    }
}

