/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.spi.internal;

import com.ibm.rules.res.xu.client.internal.RulesetExecutionListener;
import com.ibm.rules.res.xu.engine.internal.EngineManager;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import java.util.HashMap;
import javax.resource.spi.work.Work;

public final class RulesetExecutionWork
implements Work {
    private final EngineManager engineManager;
    private final RulesetExecutionListener listener;
    private final LogHandler logger;

    public RulesetExecutionWork(EngineManager engineManager, RulesetExecutionListener listener, LogHandler logger) {
        this.engineManager = engineManager;
        this.listener = listener;
        this.logger = logger;
    }

    public void release() {
    }

    public void run() {
        block3: {
            this.logger.finest("Asynchronous ruleset execution work run");
            try {
                HashMap<String, Object> params = new HashMap<String, Object>();
                this.engineManager.execute(params);
                this.logFinest(".run(): asynchronous ruleset execution work finished: " + params);
                if (this.listener != null) {
                    this.listener.executionEnded(params);
                }
            }
            catch (XUException e) {
                this.logFinest(".run(): asynchronous ruleset execution work failed");
                this.logger.severe("XU.ERROR.10408", e, null, null);
                if (this.listener == null) break block3;
                this.listener.executionFailed(e);
            }
        }
    }

    private void logFinest(String msg) {
        this.logger.finest(this.getClass().getName() + msg);
    }
}

