/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.spi.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.xu.internal.LocalizedResourceException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.pool.internal.ManagedConnectionPool;
import com.ibm.rules.res.xu.spi.internal.LocalizedResourceAllocationException;
import ilog.rules.res.xu.pool.IlrPool;
import ilog.rules.res.xu.pool.IlrPoolException;
import ilog.rules.res.xu.pool.IlrPoolListener;
import ilog.rules.res.xu.spi.IlrManagedXUConnection;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.work.WorkManager;

public final class XUConnectionManager
implements ConnectionManager,
ConnectionEventListener,
IlrPoolListener<IlrManagedXUConnection>,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient IlrPool<IlrManagedXUConnection> pool;
    private Map<String, String> properties = new HashMap<String, String>();
    private final LogHandler logHandler;
    private final transient WorkManager workMgr;

    public XUConnectionManager(WorkManager workMgr, LogHandler logHandler) {
        this.logHandler = logHandler;
        this.workMgr = workMgr;
    }

    public final synchronized void setProperties(Map<String, String> properties) {
        this.logHandler.log(new XUSourceLogRecord.Entry(properties));
        this.properties = properties;
        if (this.pool != null) {
            this.logHandler.log(new XUSourceLogRecord(Level.FINEST, "Release the connection pool", new Object[0]));
            this.pool = null;
        }
        this.logHandler.log(new XUSourceLogRecord.Exit(properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object allocateConnection(ManagedConnectionFactory connFactory, ConnectionRequestInfo req) throws ResourceException {
        IlrPool<IlrManagedXUConnection> apool = null;
        IlrPool<IlrManagedXUConnection> ilrPool = apool = this.getPool();
        synchronized (apool) {
            Set<IlrManagedXUConnection> freeConns = apool.getFreeObjects();
            IlrManagedXUConnection conn = (IlrManagedXUConnection)connFactory.matchManagedConnections(freeConns, null, req);
            if (conn == null) {
                try {
                    apool.waitNotFull();
                }
                catch (UnsupportedOperationException e) {
                    LocalizedResourceAllocationException ex = new LocalizedResourceAllocationException("XU.ERROR.10200", e);
                    this.logHandler.severe("XU.ERROR.10200", (Throwable)((Object)ex), null, null);
                    throw ex;
                }
                catch (IlrPoolException e) {
                    LocalizedResourceAllocationException ex = new LocalizedResourceAllocationException("XU.ERROR.10200", e);
                    this.logHandler.severe("XU.ERROR.10200", (Throwable)((Object)ex), null, null);
                    throw ex;
                }
                if (!apool.isFull()) {
                    conn = (IlrManagedXUConnection)connFactory.createManagedConnection(null, req);
                    conn.addConnectionEventListener(this);
                    apool.add(conn);
                } else {
                    LocalizedResourceAllocationException ex = new LocalizedResourceAllocationException("XU.ERROR.10200");
                    this.logHandler.severe("XU.ERROR.10200", (Throwable)((Object)ex), null, null);
                    throw ex;
                }
            }
            Object cciConn = conn.getConnection(null, req);
            apool.use(conn);
            // ** MonitorExit[var8_4] (shouldn't be in output)
            return cciConn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connectionClosed(ConnectionEvent evt) {
        IlrManagedXUConnection conn = (IlrManagedXUConnection)evt.getSource();
        try {
            conn.cleanup();
            IlrPool<IlrManagedXUConnection> apool = null;
            IlrPool<IlrManagedXUConnection> ilrPool = apool = this.getPool();
            synchronized (apool) {
                apool.release(conn);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (ResourceException e1) {
            this.logHandler.severe("XU.ERROR.10201", e1, null, null);
            try {
                conn.destroy();
            }
            catch (ResourceException e2) {
                this.logHandler.severe("XU.ERROR.10202", e2, null, null);
            }
            this.pool.remove(conn);
        }
        {
            return;
        }
    }

    public final void connectionErrorOccurred(ConnectionEvent event) {
    }

    public final void localTransactionCommitted(ConnectionEvent event) {
    }

    public final void localTransactionRolledback(ConnectionEvent event) {
    }

    public final void localTransactionStarted(ConnectionEvent event) {
    }

    @Override
    public final void objectRemoved(IlrManagedXUConnection conn) {
        try {
            conn.destroy();
        }
        catch (ResourceException e) {
            this.logHandler.severe("XU.ERROR.10202", e, null, null);
        }
    }

    protected final synchronized IlrPool<IlrManagedXUConnection> getPool() throws ResourceException {
        if (this.pool == null) {
            this.pool = this.createPool();
            this.pool.setLogger(this.logHandler.getLogger());
            this.pool.initialize(this.properties);
            this.pool.addPoolEventListener(this);
        }
        return this.pool;
    }

    protected final IlrPool<IlrManagedXUConnection> createPool() throws ResourceException {
        String className = this.properties.get("pool.class");
        this.logHandler.finest("XUConnectionManager.createPool(): " + className);
        if (className == null || className.equals(ManagedConnectionPool.class.getName())) {
            return new ManagedConnectionPool(this.workMgr, this.logHandler);
        }
        try {
            Class<?> clazz = Class.forName(className);
            Object newPool = clazz.newInstance();
            if (newPool instanceof IlrPool) {
                return (IlrPool)newPool;
            }
            throw new LocalizedResourceException("XU.ERROR.10203");
        }
        catch (ClassNotFoundException e) {
            throw new LocalizedResourceException("XU.ERROR.10203", null, e);
        }
        catch (InstantiationException e) {
            throw new LocalizedResourceException("XU.ERROR.10203", null, e);
        }
        catch (IllegalAccessException e) {
            throw new LocalizedResourceException("XU.ERROR.10203", null, e);
        }
    }
}

