/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.util.internal;

import com.ibm.rules.res.xu.util.internal.WeakIterator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractWeakCollection<E>
implements Collection<E> {
    @Override
    public final boolean add(E o) {
        return this.getUnderlyingCollection().add(new WeakReference<E>(o));
    }

    @Override
    public final boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E object : c) {
            if (!this.add(object)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public final void clear() {
        this.getUnderlyingCollection().clear();
    }

    @Override
    public final boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Iterator<WeakReference<E>> iterator = this.getUnderlyingCollection().iterator();
        while (iterator.hasNext()) {
            WeakReference<E> reference = iterator.next();
            Object object = reference.get();
            if (object == null) {
                iterator.remove();
                continue;
            }
            if (!object.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isEmpty() {
        return this.getUnderlyingCollection().size() == 0;
    }

    @Override
    public final Iterator<E> iterator() {
        return new WeakIterator<E>(this.getUnderlyingCollection().iterator());
    }

    @Override
    public final boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        boolean result = false;
        Iterator<WeakReference<E>> iterator = this.getUnderlyingCollection().iterator();
        while (iterator.hasNext()) {
            WeakReference<E> reference = iterator.next();
            Object object = reference.get();
            if (object == null) {
                iterator.remove();
                continue;
            }
            if (!object.equals(o)) continue;
            iterator.remove();
            result = true;
        }
        return result;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        boolean result = false;
        Iterator<?> iterator = c.iterator();
        while (iterator.hasNext()) {
            if (!this.remove(iterator.next())) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        Iterator<WeakReference<E>> iterator = this.getUnderlyingCollection().iterator();
        while (iterator.hasNext()) {
            WeakReference<E> reference = iterator.next();
            Object object = reference.get();
            if (object != null) continue;
            iterator.remove();
        }
        return this.getUnderlyingCollection().size();
    }

    @Override
    public final Object[] toArray() {
        ArrayList<E> array = new ArrayList<E>();
        for (E e : this) {
            array.add(e);
        }
        return array.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        ArrayList<E> array = new ArrayList<E>();
        for (E e : this) {
            array.add(e);
        }
        return array.toArray(a);
    }

    public final void removeNullTargetReferences() {
        Iterator<WeakReference<E>> iterator = this.getUnderlyingCollection().iterator();
        while (iterator.hasNext()) {
            WeakReference<E> reference = iterator.next();
            Object object = reference.get();
            if (object != null) continue;
            iterator.remove();
        }
    }

    public abstract Collection<WeakReference<E>> getUnderlyingCollection();
}

