/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.util.internal;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class BOMParameterXMLFilter {
    public final void filter(Document doc, List<String> filters) {
        NodeList nodes = doc.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            this.filterRecursive(nodes.item(i), filters);
        }
    }

    private void filterRecursive(Node n, List<String> filters) {
        String nodePath = this.computePath(n);
        for (String filter : filters) {
            if (!nodePath.equalsIgnoreCase(filter)) {
                NodeList childs = n.getChildNodes();
                for (int i = 0; i < childs.getLength(); ++i) {
                    this.filterRecursive(childs.item(i), filters);
                }
                continue;
            }
            n.getParentNode().removeChild(n);
        }
    }

    private String computePath(Node n) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node curNode = n; curNode != null && !(curNode instanceof Document); curNode = curNode.getParentNode()) {
            nodes.add(curNode);
        }
        nodes.remove(nodes.size() - 1);
        Collections.reverse(nodes);
        String s = "";
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            s = s + ((Node)it.next()).getNodeName();
            if (!it.hasNext()) continue;
            s = s + ".";
        }
        return s;
    }

    public final String docToString(Document document) throws Exception {
        DOMSource source = new DOMSource(document);
        StringWriter out = new StringWriter();
        StreamResult result = new StreamResult(out);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
        return out.toString();
    }
}

