/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.util.internal;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class WeakIterator<E>
implements Iterator<E> {
    private final Iterator<WeakReference<E>> underlyingIterator;
    private E next;

    public WeakIterator(Iterator<WeakReference<E>> underlyingIterator) {
        this.underlyingIterator = underlyingIterator;
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            try {
                this.next = this.next();
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public E next() {
        if (this.next == null) {
            WeakReference<E> reference = this.underlyingIterator.next();
            this.next = reference.get();
            if (this.next == null) {
                this.underlyingIterator.remove();
                this.next = this.next();
            }
            return this.next;
        }
        E result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        this.underlyingIterator.remove();
    }
}

