/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.util.internal;

import com.ibm.rules.res.xu.util.internal.EntryImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class WeakMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<K, WeakReference<V>> map = new HashMap<K, WeakReference<V>>();

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<Map.Entry<K, WeakReference<V>>> entries = this.map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<K, WeakReference<V>> entry = entries.next();
            WeakReference<V> ref = entry.getValue();
            Object object = ref.get();
            if (object == null) {
                entries.remove();
                if (value != null) continue;
                return true;
            }
            if (!value.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        WeakReference<V> ref = this.map.get(key);
        if (ref == null) {
            return null;
        }
        Object obj = ref.get();
        if (obj == null) {
            this.map.remove(key);
        }
        return (V)obj;
    }

    @Override
    public V put(K key, V value) {
        WeakReference<V> previousRef = this.map.put(key, new WeakReference<V>(value));
        if (previousRef == null) {
            return null;
        }
        return (V)previousRef.get();
    }

    @Override
    public V remove(Object key) {
        WeakReference<V> previousRef = this.map.remove(key);
        if (previousRef == null) {
            return null;
        }
        return (V)previousRef.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        Iterator<Map.Entry<K, WeakReference<V>>> entries = this.map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<K, WeakReference<V>> entry = entries.next();
            WeakReference<V> ref = entry.getValue();
            Object value = ref.get();
            if (value == null) {
                entries.remove();
                continue;
            }
            result.add(new EntryImpl(entry.getKey(), value));
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        Iterator<Map.Entry<K, WeakReference<V>>> entries = this.map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<K, WeakReference<V>> entry = entries.next();
            WeakReference<V> reference = entry.getValue();
            if (reference.get() != null) continue;
            entries.remove();
        }
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty() || this.size() == 0;
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        HashMap smap = new HashMap();
        for (Map.Entry<K, WeakReference<V>> entry : this.map.entrySet()) {
            WeakReference<V> ref = entry.getValue();
            Object object = ref.get();
            if (object == null) continue;
            smap.put(entry.getKey(), object);
        }
        stream.writeObject(smap);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = new HashMap<K, WeakReference<V>>();
        Map smap = (Map)in.readObject();
        for (Map.Entry entry : smap.entrySet()) {
            this.map.put(entry.getKey(), new WeakReference(entry.getValue()));
        }
    }

    public String toString() {
        return this.getClass().getName() + " " + this.map.toString();
    }
}

