/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.work.internal;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.security.internal.TimerPrivilegedAction;
import com.ibm.rules.res.xu.util.internal.WeakList;
import java.util.Timer;
import java.util.TimerTask;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.UnavailableException;

public final class PeriodicWorkManager {
    private WeakList<TimerTask> tasks;
    private Timer timer;
    private final BootstrapContext context;

    public PeriodicWorkManager(BootstrapContext ctx) {
        this.context = ctx;
    }

    public final synchronized void schedule(long period, TimerTask task) throws XUException {
        try {
            if (this.timer == null) {
                this.timer = this.context == null ? TimerPrivilegedAction.newTimer(true) : this.context.createTimer();
            }
            if (this.tasks == null) {
                this.tasks = new WeakList();
            }
            this.timer.schedule(task, period, period);
            this.tasks.add(task);
        }
        catch (UnavailableException e) {
            throw new XUException(XUMessageCode.ERROR_TIMER_CREATION_ERROR, e);
        }
    }

    public final synchronized void stop() {
        if (this.tasks != null) {
            for (TimerTask t : this.tasks) {
                t.cancel();
            }
            this.tasks = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

