/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.work.internal;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.xu.util.internal.WeakList;
import com.ibm.rules.res.xu.work.internal.ManagedThread;
import java.util.logging.Logger;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;

public final class WorkManagerImpl
implements WorkManager,
WorkListener {
    private WeakList<Work> works = new WeakList();
    private final WorkManager manager;
    private final Logger log = RESLogger.getLogger("com.ibm.rules.res.execution", "com.ibm.rules.res.xu.messages");

    public WorkManagerImpl(WorkManager manager) {
        this.manager = manager;
    }

    public final void doWork(Work arg0) throws WorkException {
        throw new WorkRejectedException();
    }

    public final void doWork(Work arg0, long arg1, ExecutionContext arg2, WorkListener arg3) throws WorkException {
        throw new WorkRejectedException();
    }

    public final void scheduleWork(Work arg0) throws WorkException {
        throw new WorkRejectedException();
    }

    public final void scheduleWork(Work arg0, long arg1, ExecutionContext arg2, WorkListener arg3) throws WorkException {
        throw new WorkRejectedException();
    }

    public final synchronized long startWork(Work work) throws WorkException {
        long ret;
        this.log.log(new XUSourceLogRecord.Entry(work));
        this.works.add(work);
        if (this.manager == null) {
            ManagedThread thread = new ManagedThread(work, this);
            thread.setDaemon(true);
            thread.start();
            this.workAccepted(new WorkEvent((Object)this, 1, work, null));
            ret = 0L;
        } else {
            ret = this.manager.startWork(work, Long.MAX_VALUE, null, (WorkListener)this);
        }
        this.log.log(new XUSourceLogRecord.Exit(ret));
        return ret;
    }

    public final long startWork(Work arg0, long arg1, ExecutionContext arg2, WorkListener arg3) throws WorkException {
        throw new WorkRejectedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void stop() {
        this.log.log(new XUSourceLogRecord.Entry(new Object[0]));
        WeakList<Work> weakList = this.works;
        synchronized (weakList) {
            for (Work w : this.works) {
                this.requestWorkRelease(w);
            }
        }
        this.works = null;
        this.log.log(new XUSourceLogRecord.Exit());
    }

    public void workAccepted(WorkEvent evt) {
        this.log.log(new XUSourceLogRecord.Entry(evt));
        this.log.log(new XUSourceLogRecord.Exit());
    }

    public void workCompleted(WorkEvent evt) {
        this.log.log(new XUSourceLogRecord.Entry(evt));
        this.removeWork(evt.getWork());
        this.log.log(new XUSourceLogRecord.Exit());
    }

    public void workRejected(WorkEvent evt) {
        this.log.log(new XUSourceLogRecord.Entry(evt));
        this.removeWork(evt.getWork());
        this.log.log(new XUSourceLogRecord.Exit());
    }

    public void workStarted(WorkEvent evt) {
        this.log.log(new XUSourceLogRecord.Entry(evt));
        this.log.log(new XUSourceLogRecord.Exit());
    }

    private synchronized void removeWork(Work w) {
        this.log.log(new XUSourceLogRecord.Entry(w));
        if (this.works != null) {
            this.works.remove(w);
        }
        this.log.log(new XUSourceLogRecord.Exit());
    }

    private void requestWorkRelease(Work w) {
        this.log.log(new XUSourceLogRecord.Entry(w));
        w.release();
        this.log.log(new XUSourceLogRecord.Exit());
    }
}

