/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.rest;

import com.ibm.rules.rest.Action;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocationStepChoicePoint {
    private HashMap<String, LocationStepChoicePoint> steps;
    private List<WildName> wildNames;
    private LocationStepChoicePoint wildNameStep;
    private Action defaultAction;
    private Map<String, Action> type2actions;

    public LocationStepChoicePoint nextStep(String name, Map<String, String> parameters) {
        LocationStepChoicePoint result = null;
        if (this.steps != null) {
            result = this.steps.get(name);
        }
        if (result == null) {
            if (this.wildNames == null) {
                return null;
            }
            for (WildName tmp : this.wildNames) {
                if (tmp.regexp == null || !tmp.matches(name)) continue;
                parameters.put(tmp.name, name);
                return tmp.step;
            }
            for (WildName tmp : this.wildNames) {
                if (tmp.regexp != null) continue;
                parameters.put(tmp.name, name);
            }
            return this.wildNameStep;
        }
        return result;
    }

    public LocationStepChoicePoint getWildNameStep() {
        return this.wildNameStep;
    }

    private WildName getWildNameRegexp(String regexp) {
        for (WildName tmp : this.wildNames) {
            if (tmp.regexp == null || !tmp.regexp.equals(regexp)) continue;
            return tmp;
        }
        return null;
    }

    public WildName getWildName(String name) {
        for (WildName tmp : this.wildNames) {
            if (tmp.name == null || !tmp.name.equals(name)) continue;
            return tmp;
        }
        return null;
    }

    public LocationStepChoicePoint addStep(String name, List<Action.Parameter> params) {
        LocationStepChoicePoint result = new LocationStepChoicePoint();
        if (name.startsWith("{") && name.endsWith("}")) {
            WildName tmp;
            if (this.wildNames == null) {
                this.wildNames = new ArrayList<WildName>();
            }
            WildName wildName = new WildName();
            String value = name.substring(1, name.length() - 1);
            Action.Parameter parameter = null;
            for (Action.Parameter parameter2 : params) {
                if (!parameter2.getName().equals(value)) continue;
                parameter = parameter2;
                break;
            }
            if (parameter.getRegexp() != null) {
                String regexp = parameter.getRegexp();
                WildName wildName2 = this.getWildNameRegexp(regexp);
                if (wildName2 == null) {
                    wildName.name = value;
                    wildName.regexp = regexp;
                    wildName.step = result;
                    this.wildNames.add(wildName);
                    return result;
                }
                return wildName2.step;
            }
            if (this.wildNameStep == null) {
                this.wildNameStep = result;
            }
            if ((tmp = this.getWildName(value)) == null) {
                wildName.name = value;
                this.wildNames.add(wildName);
            }
            return this.wildNameStep;
        }
        if (this.steps == null) {
            this.steps = new HashMap();
        }
        if (this.steps.get(name) == null) {
            this.steps.put(name, result);
        } else {
            result = this.steps.get(name);
        }
        return result;
    }

    public Action getAction(String contentType) {
        if (contentType == null) {
            return this.defaultAction;
        }
        if (this.type2actions == null) {
            return this.defaultAction;
        }
        Action result = this.type2actions.get(contentType);
        if (result == null) {
            return this.defaultAction;
        }
        return result;
    }

    public Map<String, Action> getActionMap() {
        return this.type2actions;
    }

    public HashMap<String, LocationStepChoicePoint> getSteps() {
        return this.steps;
    }

    public List<WildName> getWildNames() {
        return this.wildNames;
    }

    public void addAction(Action action) {
        String[] consumes = action.getConsumes();
        if (consumes == null) {
            this.defaultAction = action;
        } else {
            for (String type : consumes) {
                if (this.type2actions == null) {
                    this.type2actions = new HashMap<String, Action>();
                }
                if (this.defaultAction == null) {
                    this.defaultAction = action;
                }
                this.type2actions.put(type, action);
            }
        }
    }

    public static String displayAction(Action action) {
        StringBuffer result = new StringBuffer();
        result.append(action.getPublicName()).append('(');
        LocationStepChoicePoint.displayParameters(result, action.getParameters());
        result.append(')');
        return result.toString();
    }

    public static void displayParameters(StringBuffer result, List<Action.Parameter> params) {
        if (params == null) {
            return;
        }
        boolean first = true;
        for (Action.Parameter param : params) {
            if (!first) {
                result.append("},{");
            } else {
                result.append('{');
            }
            result.append(param.name);
            first = false;
        }
        result.append('}');
    }

    public static class WildName {
        private Pattern pattern = null;
        public String name;
        public String regexp;
        public LocationStepChoicePoint step;

        public boolean matches(String name) {
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.regexp);
            }
            Matcher m = this.pattern.matcher(name);
            return m.matches();
        }
    }
}

