/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.rest;

import com.ibm.icu.text.Collator;
import com.ibm.rules.rest.HTTPError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlTransient
public abstract class RESTCollection<T, U> {
    private boolean update = true;
    private Map<String, String> filters;
    private Map<String, Method> filterMethods;
    private final List<String> orderBys = new LinkedList<String>();
    private Collection<U> restCollection;
    private int startIndex = -1;
    private int endIndex = -1;
    private final Locale locale;

    public abstract Collection<T> getInitialCollection();

    public abstract Collection<U> getForcedRESTCollection();

    public abstract U toRESTObject(T var1, Locale var2);

    public RESTCollection(Locale locale) {
        this.locale = locale;
    }

    public RESTCollection() {
        this(Locale.ENGLISH);
    }

    public String getParam(U internalObject, String param) {
        Method m;
        if (this.filterMethods == null) {
            Method[] methods;
            this.filterMethods = new HashMap<String, Method>();
            Class<?> clazz = internalObject.getClass();
            for (Method method : methods = clazz.getMethods()) {
                XmlElement elementAnn = method.getAnnotation(XmlElement.class);
                if (elementAnn == null) continue;
                this.filterMethods.put(elementAnn.name(), method);
            }
        }
        if ((m = this.filterMethods.get(param)) == null) {
            return null;
        }
        try {
            Object o = m.invoke(internalObject, new Object[0]);
            if (o != null) {
                return o.toString();
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    @JsonIgnore
    public Collection<U> getRESTCollection() {
        return this.getRESTCollection(null);
    }

    @JsonIgnore
    private Collection<U> getRESTCollection(int[] size) {
        int count = 0;
        if (this.update) {
            this.restCollection = this.orderBys.size() == 0 ? new ArrayList<U>() : new TreeSet<U>(new Comparator<U>(){

                @Override
                public int compare(U o1, U o2) {
                    Collator collator = Collator.getInstance((Locale)RESTCollection.this.locale);
                    collator.setStrength(2);
                    for (String field : RESTCollection.this.orderBys) {
                        String value2;
                        String value1 = RESTCollection.this.getParam(o1, field);
                        int result = collator.compare(value1, value2 = RESTCollection.this.getParam(o2, field));
                        if (result == 0) continue;
                        return result;
                    }
                    return 1;
                }
            });
            Collection<T> coll = this.getInitialCollection();
            if (size != null && this.filters == null) {
                size[0] = coll.size();
                return null;
            }
            if (coll != null) {
                for (T t : coll) {
                    if (this.filters != null) {
                        boolean add = true;
                        U rest = this.toRESTObject(t, this.locale);
                        for (Map.Entry<String, String> entry : this.filters.entrySet()) {
                            String value = this.getParam(rest, entry.getKey());
                            if (entry.getValue().startsWith("exp(") && entry.getValue().endsWith(")")) {
                                try {
                                    String regex = entry.getValue().substring(4, entry.getValue().length() - 1);
                                    if (value == null || value.matches(regex)) continue;
                                    add = false;
                                    break;
                                }
                                catch (Exception e) {
                                    throw new HTTPError(412, e);
                                }
                            }
                            if (value == null || entry.getValue() == null || entry.getValue().equals(value)) continue;
                            add = false;
                            break;
                        }
                        if (!add) continue;
                        if (size != null) {
                            ++count;
                            continue;
                        }
                        this.restCollection.add(rest);
                        continue;
                    }
                    if (size != null) {
                        ++count;
                        continue;
                    }
                    this.restCollection.add(this.toRESTObject(t, this.locale));
                }
            } else {
                if (size != null) {
                    size[0] = 0;
                }
                return null;
            }
        }
        this.update = false;
        if (this.startIndex != -1 && this.endIndex != -1) {
            count = 0;
            ArrayList<U> result = new ArrayList<U>();
            Iterator<U> itColl = this.restCollection.iterator();
            int index = 0;
            while (itColl.hasNext()) {
                U item = itColl.next();
                if (index >= this.startIndex && index <= this.endIndex) {
                    if (size != null) {
                        ++count;
                    } else {
                        result.add(item);
                    }
                }
                if (index > this.endIndex) break;
                ++index;
            }
            if (size != null) {
                size[0] = count;
                return null;
            }
            return result;
        }
        if (size != null) {
            size[0] = count;
            return null;
        }
        return this.restCollection;
    }

    public void addFilter(String param, String value) {
        this.update = true;
        if (this.filters == null) {
            this.filters = new LinkedHashMap<String, String>();
        }
        this.filters.put(param, value);
    }

    public void addOrderBy(String param) {
        this.update = true;
        this.orderBys.add(param);
    }

    public void paging(int startIndex, int endIndex) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public int count() {
        int[] size = new int[]{0};
        this.getRESTCollection(size);
        return size[0];
    }
}

