/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.xu.profiling;

import com.ibm.rules.res.xu.persistence.internal.Persistence;
import ilog.rules.bres.xu.event.IlrProfilingConnectionEvent;
import ilog.rules.bres.xu.event.IlrProfilingManagedConnectionEvent;
import ilog.rules.bres.xu.event.IlrProfilingRuleEngineEvent;
import ilog.rules.bres.xu.event.IlrProfilingRulesetEvent;
import ilog.rules.bres.xu.event.IlrProfilingRulesetInformationProviderEvent;
import ilog.rules.bres.xu.measure.IlrDurationMeasure;
import ilog.rules.bres.xu.measure.IlrMeasure;
import ilog.rules.bres.xu.measure.IlrRatioMeasure;
import ilog.rules.bres.xu.measure.IlrTimeMeasure;
import ilog.rules.engine.IlrContext;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.res.xu.cci.IlrConnectionContext;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import ilog.rules.res.xu.ruleset.archive.internal.IlrXURulesetArchiveInformation;
import java.io.Serializable;

public class IlrProfilingHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean enabled = true;
    private final IlrXUEventDispatcher eventDispatcher;

    public IlrProfilingHelper(IlrXUEventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public IlrProfilingRulesetEvent startRulesetMeasure(int code, IlrXURulesetArchiveInformation rulesetArchiveInformation, IlrXUContext xuContext) {
        if (!this.enabled || this.eventDispatcher == null || !this.eventDispatcher.isEventFired(8L)) {
            return null;
        }
        IlrProfilingRulesetEvent rulesetEvent = new IlrProfilingRulesetEvent(code, rulesetArchiveInformation, rulesetArchiveInformation.getCanonicalPath().toString(), xuContext);
        IlrTimeMeasure start = new IlrTimeMeasure(1, 1);
        rulesetEvent.addMeasure(start);
        return rulesetEvent;
    }

    public void stopRulesetMeasure(IlrProfilingRulesetEvent rulesetEvent) {
        if (!this.enabled || rulesetEvent == null) {
            return;
        }
        IlrTimeMeasure start = (IlrTimeMeasure)rulesetEvent.getMeasure(1L);
        IlrTimeMeasure end = new IlrTimeMeasure(1, 1);
        IlrDurationMeasure duration = new IlrDurationMeasure(2, 1, start, end);
        rulesetEvent.addMeasure(duration);
    }

    public void sendRulesetEvent(IlrProfilingRulesetEvent rulesetEvent) {
        if (this.enabled && this.eventDispatcher != null && rulesetEvent != null) {
            this.eventDispatcher.profilingRulesetActionPerformed(rulesetEvent);
        }
    }

    public IlrProfilingRuleEngineEvent startRuleEngineMeasure(int code, IlrContext context, String canonicalRulesetPath, boolean measureNbFiredRules, IlrXUContext xuContext) {
        if (!this.enabled || this.eventDispatcher == null || !this.eventDispatcher.isEventFired(16L)) {
            return null;
        }
        IlrProfilingRuleEngineEvent ruleEngineEvent = new IlrProfilingRuleEngineEvent(code, context, canonicalRulesetPath, xuContext);
        IlrTimeMeasure start = new IlrTimeMeasure(1, 1);
        ruleEngineEvent.addMeasure(start);
        if (measureNbFiredRules) {
            int nbFiredRulesCount = context.getFiredRulesCount();
            IlrMeasure nbFiredRules = new IlrMeasure(4, 2, new Integer(nbFiredRulesCount));
            ruleEngineEvent.addMeasure(nbFiredRules);
        }
        return ruleEngineEvent;
    }

    public void stopRuleEngineMeasure(IlrProfilingRuleEngineEvent ruleEngineEvent) {
        if (!this.enabled || ruleEngineEvent == null) {
            return;
        }
        IlrTimeMeasure start = (IlrTimeMeasure)ruleEngineEvent.getMeasure(1L);
        IlrTimeMeasure end = new IlrTimeMeasure(1, 1);
        IlrDurationMeasure duration = new IlrDurationMeasure(2, 1, start, end);
        ruleEngineEvent.addMeasure(duration);
        IlrMeasure nbStart = ruleEngineEvent.getMeasure(4L);
        if (nbStart == null) {
            return;
        }
        int nbEnd = ruleEngineEvent.getContext().getFiredRulesCount();
        IlrMeasure nbFiredRules = new IlrMeasure(3, 2, new Integer(nbEnd - nbStart.getValue().intValue()));
        IlrRatioMeasure ratio = new IlrRatioMeasure(5, 3, nbFiredRules, duration);
        ruleEngineEvent.addMeasure(nbFiredRules);
        ruleEngineEvent.addMeasure(ratio);
    }

    public void sendRuleEngineEvent(IlrProfilingRuleEngineEvent ruleEngineEvent) {
        if (this.enabled && this.eventDispatcher != null && ruleEngineEvent != null) {
            this.eventDispatcher.profilingRuleEngineActionPerformed(ruleEngineEvent);
        }
    }

    public IlrProfilingConnectionEvent startConnectionMeasure(int code, IlrConnectionContext context) {
        if (!this.enabled || this.eventDispatcher == null || !this.eventDispatcher.isEventFired(64L)) {
            return null;
        }
        IlrTimeMeasure start = new IlrTimeMeasure(1, 1);
        IlrProfilingConnectionEvent event = new IlrProfilingConnectionEvent(code, (Object)this, context);
        event.addMeasure(start);
        return event;
    }

    public void stopConnectionMeasure(IlrProfilingConnectionEvent event) {
        if (!this.enabled || event == null) {
            return;
        }
        IlrTimeMeasure start = (IlrTimeMeasure)event.getMeasure(1L);
        IlrTimeMeasure end = new IlrTimeMeasure(1, 1);
        IlrDurationMeasure duration = new IlrDurationMeasure(2, 1, start, end);
        event.addMeasure(duration);
    }

    public void sendConnectionEvent(IlrProfilingConnectionEvent event) {
        if (this.enabled && this.eventDispatcher != null && event != null) {
            this.eventDispatcher.profilingConnectionActionPerformed(event);
        }
    }

    public IlrProfilingManagedConnectionEvent startManagedConnectionMeasure(int code, String canonicalRulesetPath, int nbBackupedContextManagers, int nbContextManagers, Object source, IlrXUContext context) {
        if (!this.enabled || this.eventDispatcher == null || !this.eventDispatcher.isEventFired(128L)) {
            return null;
        }
        IlrTimeMeasure start = new IlrTimeMeasure(1, 1);
        IlrMeasure nbBCM = new IlrMeasure(6, 2, new Integer(nbBackupedContextManagers));
        IlrMeasure nbCM = new IlrMeasure(7, 2, new Integer(nbContextManagers));
        IlrProfilingManagedConnectionEvent event = new IlrProfilingManagedConnectionEvent(code, source, canonicalRulesetPath, context);
        event.addMeasure(start);
        event.addMeasure(nbBCM);
        event.addMeasure(nbCM);
        return event;
    }

    public void stopManagedConnectionMeasure(IlrProfilingManagedConnectionEvent event) {
        if (!this.enabled || event == null) {
            return;
        }
        IlrTimeMeasure start = (IlrTimeMeasure)event.getMeasure(1L);
        IlrTimeMeasure end = new IlrTimeMeasure(1, 1);
        IlrDurationMeasure duration = new IlrDurationMeasure(2, 1, start, end);
        event.addMeasure(duration);
    }

    public void sendManagedConnectionEvent(IlrProfilingManagedConnectionEvent event) {
        if (this.enabled && this.eventDispatcher != null && event != null) {
            this.eventDispatcher.profilingManagedConnectionActionPerformed(event);
        }
    }

    public IlrProfilingRulesetInformationProviderEvent startRulesetInformationProviderMeasure(int code, Persistence provider, String canonicalRulesetPath, IlrXUContext xuContext) {
        if (!this.enabled || this.eventDispatcher == null || !this.eventDispatcher.isEventFired(256L)) {
            return null;
        }
        IlrTimeMeasure start = new IlrTimeMeasure(1, 1);
        IlrProfilingRulesetInformationProviderEvent event = new IlrProfilingRulesetInformationProviderEvent(code, provider, canonicalRulesetPath, xuContext);
        event.addMeasure(start);
        return event;
    }

    public void stopRulesetInformationProviderMeasure(IlrProfilingRulesetInformationProviderEvent event) {
        if (!this.enabled || event == null) {
            return;
        }
        IlrTimeMeasure start = (IlrTimeMeasure)event.getMeasure(1L);
        IlrTimeMeasure end = new IlrTimeMeasure(1, 1);
        IlrDurationMeasure duration = new IlrDurationMeasure(2, 1, start, end);
        event.addMeasure(duration);
    }

    public void sendRulesetInformationProviderEvent(IlrProfilingRulesetInformationProviderEvent event) {
        if (this.enabled && this.eventDispatcher != null && event != null) {
            this.eventDispatcher.profilingRulesetInformationProviderActionPerformed(event);
        }
    }
}

