/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.brl;

import com.ibm.rules.engine.annotations.PureFunction;
import java.util.Calendar;
import java.util.Date;

public class IlrDateUtil {
    private IlrDateUtil() {
    }

    @PureFunction
    public static int extractDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    @PureFunction
    public static Date getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    @PureFunction
    public static Date getTime(Date date) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date);
        cal2.set(1970, 0, 1);
        cal2.set(11, cal1.get(11));
        cal2.set(12, cal1.get(12));
        cal2.set(13, cal1.get(13));
        cal2.set(14, 0);
        return cal2.getTime();
    }

    @PureFunction
    public static int extractYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    @PureFunction
    public static int extractMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2);
    }

    @PureFunction
    public static Date getDateFromYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, year);
        return cal.getTime();
    }

    @PureFunction
    public static Date getDateFromMonth(int month) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2, month);
        return cal.getTime();
    }

    @PureFunction
    public static Date getDateFromDayOfWeek(int dayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(7, dayOfWeek);
        return cal.getTime();
    }

    @PureFunction
    public static Date getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        cal.clear();
        cal.set(1, year);
        return cal.getTime();
    }

    @PureFunction
    public static Date getDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(7);
        cal.clear();
        cal.set(7, year);
        return cal.getTime();
    }

    @PureFunction
    public static Date getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(2);
        cal.clear();
        cal.set(2, year);
        return cal.getTime();
    }

    @PureFunction
    public static long getLocalTime(int year, int month, int date, int hour, int minute, int second, int millisecond, int am_pm) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, date);
        cal.set(10, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, millisecond);
        cal.set(9, am_pm);
        return cal.getTime().getTime();
    }

    public static long getLocalTime(int year, int month, int date, int hour, int minute, int second, int millisecond) {
        return IlrDateUtil.getLocalTime(year, month, date, hour, minute, second, millisecond, 0);
    }
}

