/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.crypto;

import ilog.rules.crypto.IlrEncryptionServiceException;
import ilog.rules.util.IlrBase64DecoderStream;
import ilog.rules.util.IlrBase64EncoderStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class IlrOldEncryptionService {
    private static IlrOldEncryptionService instance = null;
    private static String ALGORITHM = "DES";
    private Cipher cipher;
    private SecretKey desKey;

    private IlrOldEncryptionService() throws IlrEncryptionServiceException {
        try {
            DESKeySpec ks = new DESKeySpec(new byte[]{3, 56, 38, 45, 7, 78, 12, 89});
            this.desKey = SecretKeyFactory.getInstance(ALGORITHM).generateSecret(ks);
            this.cipher = Cipher.getInstance(ALGORITHM);
        }
        catch (Exception e) {
            throw new IlrEncryptionServiceException(e);
        }
    }

    public static synchronized IlrOldEncryptionService getInstance() throws IlrEncryptionServiceException {
        if (instance == null) {
            instance = new IlrOldEncryptionService();
        }
        return instance;
    }

    public synchronized String encrypt(String message) throws IlrEncryptionServiceException {
        if (message == null) {
            return null;
        }
        try {
            this.cipher.init(1, (Key)this.desKey, this.cipher.getParameters());
            byte[] cipherText = this.cipher.doFinal(message.getBytes("UTF-8"));
            return new String(IlrBase64EncoderStream.encode(cipherText));
        }
        catch (Exception e) {
            throw new IlrEncryptionServiceException(e);
        }
    }

    public synchronized String decrypt(String message) throws IlrEncryptionServiceException {
        if (message == null) {
            return null;
        }
        try {
            this.cipher.init(2, (Key)this.desKey, this.cipher.getParameters());
            byte[] cipherText = this.cipher.doFinal(IlrBase64DecoderStream.decode(message.getBytes()));
            return new String(cipherText, "UTF-8");
        }
        catch (Exception e) {
            throw new IlrEncryptionServiceException(e);
        }
    }

    public String getAlgorithm() {
        return ALGORITHM;
    }
}

