/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.datasource;

import ilog.rules.base.IlrMutableStringMap;
import ilog.rules.base.IlrStringMap;
import ilog.rules.datasource.IlrDefaultTableModel;
import ilog.rules.datasource.IlrMutableTableDataSourceModel;
import ilog.rules.datasource.IlrTableDataSourceModel;
import ilog.rules.util.issue.IlrDefaultIssueHandler;
import ilog.rules.util.issue.IlrError;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class IlrDefaultDataSourceModel
implements IlrMutableTableDataSourceModel {
    private HashMap tableFromName = new HashMap();
    private IlrMutableStringMap properties;

    public IlrDefaultDataSourceModel() {
        this.properties = new IlrMutableStringMap();
    }

    public IlrDefaultDataSourceModel(IlrMutableStringMap properties) {
        this.properties = properties;
    }

    @Override
    public IlrMutableTableDataSourceModel.MutableTable createTable(String name) {
        return new IlrDefaultTableModel(name);
    }

    @Override
    public IlrMutableTableDataSourceModel.MutableTable getMutableTable(String name) {
        return (IlrMutableTableDataSourceModel.MutableTable)this.tableFromName.get(name);
    }

    @Override
    public IlrTableDataSourceModel.Table[] getTables() {
        Collection tableSet = this.tableFromName.values();
        IlrTableDataSourceModel.Table[] tables = new IlrTableDataSourceModel.Table[tableSet.size()];
        return tableSet.toArray(tables);
    }

    @Override
    public IlrMutableStringMap getMutableProperties() {
        return this.properties;
    }

    @Override
    public void addTable(IlrMutableTableDataSourceModel.MutableTable table) {
        this.tableFromName.put(table.getName(), table);
    }

    @Override
    public boolean removeTable(String name) {
        return this.tableFromName.remove(name) != null;
    }

    @Override
    public IlrTableDataSourceModel.Table getTable(String name) {
        return this.getMutableTable(name);
    }

    @Override
    public IlrStringMap getProperties() {
        return this.properties;
    }

    public static void checkModel(IlrTableDataSourceModel model, IlrDefaultIssueHandler errorManager) {
        IlrTableDataSourceModel.Table[] tables = model.getTables();
        HashSet<String> tableNames = new HashSet<String>();
        HashSet<String> columnNames = new HashSet<String>();
        for (int i = 0; i < tables.length; ++i) {
            IlrTableDataSourceModel.Table table = tables[i];
            if (table.getName() == null) {
                errorManager.add(new IlrError("datasource", "ERROR_DS_002", Integer.toString(i)));
            } else if (tableNames.contains(table.getName())) {
                errorManager.add(new IlrError("datasource", "ERROR_DS_004", table.getName()));
            } else {
                tableNames.add(table.getName());
            }
            columnNames.clear();
            IlrTableDataSourceModel.Column[] columns = table.getColumns();
            for (int j = 0; j < columns.length; ++j) {
                IlrTableDataSourceModel.Column column = columns[j];
                if (column.getName() == null) {
                    errorManager.add(new IlrError("datasource", "ERROR_DS_003", Integer.toString(i), table.getName()));
                } else if (columnNames.contains(column.getName())) {
                    errorManager.add(new IlrError("datasource", "ERROR_DS_005", column.getName(), table.getName()));
                } else {
                    columnNames.add(column.getName());
                }
                if (column.getType() != null) continue;
                errorManager.add(new IlrError("datasource", "ERROR_DS_006", column.getName(), table.getName()));
            }
        }
    }
}

