/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.datasource;

import ilog.rules.base.IlrMutableStringMap;
import ilog.rules.base.IlrStringMap;
import ilog.rules.datasource.IlrDefaultColumnModel;
import ilog.rules.datasource.IlrMutableTableDataSourceModel;
import ilog.rules.datasource.IlrTableDataSourceModel;
import java.util.ArrayList;

public class IlrDefaultTableModel
implements IlrMutableTableDataSourceModel.MutableTable {
    private String name;
    ArrayList columns = new ArrayList();
    IlrMutableStringMap properties;

    public IlrDefaultTableModel(String name) {
        this.name = name;
        this.properties = new IlrMutableStringMap();
    }

    public IlrDefaultTableModel(String name, IlrMutableStringMap properties) {
        this.name = name;
        this.properties = properties;
    }

    @Override
    public void addColumn(IlrMutableTableDataSourceModel.MutableColumn column) {
        this.columns.add(column);
    }

    @Override
    public IlrMutableTableDataSourceModel.MutableColumn createColumn(String name, Class type) {
        return new IlrDefaultColumnModel(name, type);
    }

    @Override
    public IlrMutableTableDataSourceModel.MutableColumn getMutableColumn(String name) {
        int s = this.columns.size();
        for (int i = 0; i < s; ++i) {
            IlrMutableTableDataSourceModel.MutableColumn c = (IlrMutableTableDataSourceModel.MutableColumn)this.columns.get(i);
            if (!name.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    @Override
    public IlrMutableStringMap getMutableProperties() {
        return this.properties;
    }

    @Override
    public void insertColumn(IlrMutableTableDataSourceModel.MutableColumn column, int index) {
        this.columns.add(index, column);
    }

    @Override
    public boolean removeColumn(String name) {
        IlrMutableTableDataSourceModel.MutableColumn c = this.getMutableColumn(name);
        if (c == null) {
            return false;
        }
        return this.columns.remove(c);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IlrTableDataSourceModel.Column getColumn(int index) {
        return (IlrTableDataSourceModel.Column)this.columns.get(index);
    }

    @Override
    public IlrTableDataSourceModel.Column getColumn(String name) {
        return this.getMutableColumn(name);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public IlrTableDataSourceModel.Column[] getColumns() {
        int s = this.columns.size();
        IlrTableDataSourceModel.Column[] cs = new IlrTableDataSourceModel.Column[s];
        for (int i = 0; i < s; ++i) {
            cs[i] = (IlrTableDataSourceModel.Column)this.columns.get(i);
        }
        return cs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IlrStringMap getProperties() {
        return this.properties;
    }
}

