/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.datasource;

import ilog.rules.base.xml.IlrXmlConverter;
import ilog.rules.base.xml.IlrXmlMarshallingContext;
import ilog.rules.base.xml.IlrXmlUnmarshallingContext;
import ilog.rules.datasource.IlrDataSource;
import ilog.rules.datasource.IlrDataSourcePool;
import ilog.rules.datasource.IlrDefaultDataSourcePool;
import ilog.rules.datasource.IlrPoolTableDataSourceProxy;
import ilog.rules.datasource.IlrXmlDSConstants;
import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrErrorException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class IlrXmlPoolConverters {

    static class DefaultDSPoolConverter
    implements IlrXmlConverter,
    IlrXmlDSConstants {
        static final Class[] supportedClass = new Class[]{IlrDefaultDataSourcePool.class};

        DefaultDSPoolConverter() {
        }

        @Override
        public Class[] getSupportedClasses() {
            return supportedClass;
        }

        @Override
        public QName getXmlElement() {
            return DEFAULT_DS_POOL_ELEMENT;
        }

        @Override
        public QName getXmlType() {
            return DEFAULT_DS_POOL_TYPE;
        }

        @Override
        public QName getSchemaLocation() {
            return SCHEMA_LOCATION_QNAME;
        }

        @Override
        public boolean isReferenceWorthy() {
            return true;
        }

        @Override
        public Object readObject(Element element, IlrXmlUnmarshallingContext context) throws IlrErrorException {
            IlrDefaultDataSourcePool dsPool = new IlrDefaultDataSourcePool();
            Element entryElement = context.getFirstElement(element, null, "entry");
            while (entryElement != null) {
                Element keyElement = context.getFirstElement(entryElement, null, null);
                Element dsElement = context.getNextElement(keyElement, null, null);
                IlrDataSourcePool.Key key = (IlrDataSourcePool.Key)context.readObject(null, keyElement, IlrDataSourcePool.Key.class);
                IlrDataSource dataSource = (IlrDataSource)context.readObject(null, dsElement, IlrDataSource.class);
                dsPool.addDataSource(key, dataSource);
                entryElement = context.getNextElement(entryElement, null, "entry");
            }
            return dsPool;
        }

        @Override
        public void writeObject(Object object, Element poolElement, IlrXmlMarshallingContext context) throws IlrErrorException {
            IlrDefaultDataSourcePool dsPool = (IlrDefaultDataSourcePool)object;
            IlrDataSource[] dss = dsPool.getDataSources();
            for (int i = 0; i < dss.length; ++i) {
                Element entryElement = context.createElement("entry");
                poolElement.appendChild(entryElement);
                IlrDataSourcePool.Key key = dsPool.getDataSourceKey(dss[i]);
                context.writeObject(key, entryElement);
                context.writeObject(dss[i], entryElement);
            }
        }
    }

    static class DSProxyConverter
    implements IlrXmlConverter,
    IlrXmlDSConstants {
        static final Class[] supportedClass = new Class[]{IlrPoolTableDataSourceProxy.class};

        DSProxyConverter() {
        }

        @Override
        public Class[] getSupportedClasses() {
            return supportedClass;
        }

        @Override
        public QName getXmlElement() {
            return TABLEDS_PROXY_ELEMENT;
        }

        @Override
        public QName getXmlType() {
            return TABLEDS_PROXY_TYPE;
        }

        @Override
        public QName getSchemaLocation() {
            return SCHEMA_LOCATION_QNAME;
        }

        @Override
        public boolean isReferenceWorthy() {
            return true;
        }

        @Override
        public Object readObject(Element element, IlrXmlUnmarshallingContext context) throws IlrErrorException {
            IlrDataSourcePool dsPool = (IlrDataSourcePool)context.getData("dataSourcePool");
            if (dsPool == null) {
                context.getErrorManager().add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_013", "dataSourcePool"));
            }
            Element keyElement = context.getFirstElement(element, null, null);
            IlrDataSourcePool.Key dsKey = (IlrDataSourcePool.Key)context.readObject(null, keyElement, IlrDataSourcePool.Key.class);
            return new IlrPoolTableDataSourceProxy(dsKey, dsPool);
        }

        @Override
        public void writeObject(Object object, Element proxyElement, IlrXmlMarshallingContext context) throws IlrErrorException {
            IlrPoolTableDataSourceProxy proxy = (IlrPoolTableDataSourceProxy)object;
            context.writeObject(proxy.getKey(), proxyElement);
        }
    }

    static class DSDefaultKeyConverter
    implements IlrXmlConverter,
    IlrXmlDSConstants {
        static final Class[] supportedClass = new Class[]{IlrDefaultDataSourcePool.DefaultKey.class};

        DSDefaultKeyConverter() {
        }

        @Override
        public Class[] getSupportedClasses() {
            return supportedClass;
        }

        @Override
        public QName getXmlElement() {
            return TABLEDS_DEFAULT_KEY_ELEMENT;
        }

        @Override
        public QName getXmlType() {
            return TABLEDS_DEFAULT_KEY_TYPE;
        }

        @Override
        public QName getSchemaLocation() {
            return SCHEMA_LOCATION_QNAME;
        }

        @Override
        public boolean isReferenceWorthy() {
            return true;
        }

        @Override
        public Object readObject(Element element, IlrXmlUnmarshallingContext context) throws IlrErrorException {
            Text t = (Text)element.getFirstChild();
            String keyValue = t.getData();
            try {
                int intValue = Integer.parseInt(keyValue);
                return new IlrDefaultDataSourcePool.DefaultKey(intValue);
            }
            catch (NumberFormatException e) {
                context.getErrorManager().add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_013", e.getClass().getName(), e.getMessage(), element.getLocalName()));
                return null;
            }
        }

        @Override
        public void writeObject(Object object, Element element, IlrXmlMarshallingContext context) throws IlrErrorException {
            IlrDefaultDataSourcePool.DefaultKey key = (IlrDefaultDataSourcePool.DefaultKey)object;
            Text t = context.getDocument().createTextNode(Integer.toString(key.value));
            element.appendChild(t);
        }
    }
}

