/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.dvs.rsi.utils;

import ilog.rules.dvs.rsi.IlrBOMTypeDescriptor;
import ilog.rules.dvs.rsi.internal.IlrDefaultBOMTypeDescriptor;
import ilog.rules.dvs.rsi.ofactory.IlrObjectFactoryParameter;
import ilog.rules.dvs.rsi.ofactory.internal.IlrObjectFactoryParameterImpl;
import ilog.rules.dvs.rsi.signature.IlrRulesetParameter;
import ilog.rules.dvs.rsi.signature.internal.IlrRulesetParameterImpl;
import ilog.rules.dvs.rsi.utils.IlrSerializationException;
import java.util.StringTokenizer;

public class IlrHRSerializationUtils {
    private static final String SERIALIZED_BOM_TYPE_DESCRIPTOR_START_TOKEN = "[";
    private static final String SERIALIZED_BOM_TYPE_DESCRIPTOR_END_TOKEN = "]";
    private static final String SERIALIZED_BOM_TYPE_DESCRIPTOR_ATTRIBUTES_SEPARATOR = ",";
    private static final String PARAMETER_ATTRIBUTES_SEPARATOR = ":";
    private static final String NAMED_PARAMETER_BOM_TYPE = "bomType";
    private static final String NAMED_PARAMETER_NAME = "name";
    private static final String OBJECT_FACTORY_PARAMETER_OPTIONAL = "optional";
    private static final String OBJECT_FACTORY_PARAMETER_VALUE = "value";

    private IlrHRSerializationUtils() {
    }

    public static String serializeObjectFactoryParameter(IlrObjectFactoryParameter theObjectFactoryParameter) {
        StringBuffer returnedValue = new StringBuffer();
        returnedValue.append(theObjectFactoryParameter.getName());
        returnedValue.append(PARAMETER_ATTRIBUTES_SEPARATOR);
        returnedValue.append(IlrHRSerializationUtils.serializeBOMTypeDescriptor(theObjectFactoryParameter.getBOMType()));
        returnedValue.append(PARAMETER_ATTRIBUTES_SEPARATOR);
        returnedValue.append(theObjectFactoryParameter.isOptional());
        return returnedValue.toString();
    }

    public static IlrObjectFactoryParameter deserializeObjectFactoryParameter(String theSerializedObjectFactoryParameter) throws IlrSerializationException {
        StringTokenizer tokenizer = new StringTokenizer(theSerializedObjectFactoryParameter, PARAMETER_ATTRIBUTES_SEPARATOR);
        if (tokenizer.countTokens() != 3) {
            throw new IlrSerializationException(IlrSerializationException.SERIALIZED_OBJECT_FACTORY_PARAMETER_FORMAT_ERROR_MESSAGE_CODE, new String[]{theSerializedObjectFactoryParameter});
        }
        IlrObjectFactoryParameterImpl returnedValue = new IlrObjectFactoryParameterImpl();
        String parameterName = tokenizer.nextToken();
        if ("".equals(parameterName.trim())) {
            throw new IlrSerializationException(IlrSerializationException.SERIALIZED_OBJECT_FACTORY_PARAMETER_NAME_ERROR_MESSAGE_CODE, new String[]{theSerializedObjectFactoryParameter});
        }
        returnedValue.setName(parameterName);
        IlrBOMTypeDescriptor parameterType = IlrHRSerializationUtils.deserializeBOMTypeDescriptor(tokenizer.nextToken());
        if (parameterType == null) {
            throw new IlrSerializationException(IlrSerializationException.SERIALIZED_OBJECT_FACTORY_PARAMETER_TYPE_ERROR_MESSAGE_CODE, new String[]{theSerializedObjectFactoryParameter});
        }
        returnedValue.setBOMType(parameterType);
        Boolean parameterIsOptional = null;
        String serializedIsOptionalValue = tokenizer.nextToken();
        if ("true".equals(serializedIsOptionalValue)) {
            parameterIsOptional = true;
        } else if ("false".equals(serializedIsOptionalValue)) {
            parameterIsOptional = false;
        } else {
            throw new IlrSerializationException(IlrSerializationException.SERIALIZED_OBJECT_FACTORY_PARAMETER_IS_OPTIONAL_ERROR_MESSAGE_CODE, new String[]{theSerializedObjectFactoryParameter});
        }
        returnedValue.setOptional(parameterIsOptional);
        return returnedValue;
    }

    public static String serializeRulesetParameter(IlrRulesetParameter theRulesetParameter) {
        StringBuffer returnedValue = new StringBuffer();
        returnedValue.append(theRulesetParameter.getName());
        returnedValue.append(PARAMETER_ATTRIBUTES_SEPARATOR);
        returnedValue.append(IlrHRSerializationUtils.serializeBOMTypeDescriptor(theRulesetParameter.getBOMType()));
        returnedValue.append(PARAMETER_ATTRIBUTES_SEPARATOR);
        returnedValue.append((Object)theRulesetParameter.getDirection());
        return returnedValue.toString();
    }

    public static IlrRulesetParameter deserializeRulesetParameter(String theSerializedRulesetParameter) throws IlrSerializationException {
        StringTokenizer tokenizer = new StringTokenizer(theSerializedRulesetParameter, PARAMETER_ATTRIBUTES_SEPARATOR);
        if (tokenizer.countTokens() != 3) {
            throw new IlrSerializationException(IlrSerializationException.SERIALIZED_RULESET_PARAMETER_FORMAT_ERROR_MESSAGE_CODE, new String[]{theSerializedRulesetParameter});
        }
        IlrRulesetParameterImpl returnedValue = new IlrRulesetParameterImpl();
        String parameterName = tokenizer.nextToken();
        if ("".equals(parameterName.trim())) {
            throw new IlrSerializationException(IlrSerializationException.SERIALIZED_RULESET_PARAMETER_NAME_ERROR_MESSAGE_CODE, new String[]{theSerializedRulesetParameter});
        }
        returnedValue.setName(parameterName);
        IlrBOMTypeDescriptor parameterType = IlrHRSerializationUtils.deserializeBOMTypeDescriptor(tokenizer.nextToken());
        if (parameterType == null) {
            throw new IlrSerializationException(IlrSerializationException.SERIALIZED_RULESET_PARAMETER_TYPE_ERROR_MESSAGE_CODE, new String[]{theSerializedRulesetParameter});
        }
        returnedValue.setBOMType(parameterType);
        IlrRulesetParameter.RulesetParameterDirection parameterDirection = null;
        try {
            parameterDirection = IlrRulesetParameter.RulesetParameterDirection.valueOf(tokenizer.nextToken());
        }
        catch (Throwable t) {
            throw new IlrSerializationException(IlrSerializationException.SERIALIZED_RULESET_PARAMETER_DIRECTION_ERROR_MESSAGE_CODE, new String[]{theSerializedRulesetParameter}, t);
        }
        returnedValue.setDirection(parameterDirection);
        return returnedValue;
    }

    public static String serializeBOMTypeDescriptor(IlrBOMTypeDescriptor theBOMTypeDescriptor) {
        StringBuffer serializedVersion = new StringBuffer();
        if (theBOMTypeDescriptor != null) {
            serializedVersion.append(SERIALIZED_BOM_TYPE_DESCRIPTOR_START_TOKEN);
            serializedVersion.append(theBOMTypeDescriptor.getFullyQualifiedName());
            IlrBOMTypeDescriptor elementsType = theBOMTypeDescriptor.getElementsType();
            if (elementsType != null) {
                serializedVersion.append(SERIALIZED_BOM_TYPE_DESCRIPTOR_ATTRIBUTES_SEPARATOR);
                serializedVersion.append(IlrHRSerializationUtils.serializeBOMTypeDescriptor(elementsType));
            }
            serializedVersion.append(SERIALIZED_BOM_TYPE_DESCRIPTOR_END_TOKEN);
        }
        return serializedVersion.toString();
    }

    public static IlrBOMTypeDescriptor deserializeBOMTypeDescriptor(String theSerializedBOMTypeDescriptor) {
        IlrDefaultBOMTypeDescriptor returnedValue = null;
        if (theSerializedBOMTypeDescriptor != null && theSerializedBOMTypeDescriptor.startsWith(SERIALIZED_BOM_TYPE_DESCRIPTOR_START_TOKEN) && theSerializedBOMTypeDescriptor.endsWith(SERIALIZED_BOM_TYPE_DESCRIPTOR_END_TOKEN)) {
            int separatorIndex = theSerializedBOMTypeDescriptor.indexOf(SERIALIZED_BOM_TYPE_DESCRIPTOR_ATTRIBUTES_SEPARATOR);
            String fqn = theSerializedBOMTypeDescriptor.substring(1, separatorIndex == -1 ? theSerializedBOMTypeDescriptor.length() - 1 : separatorIndex);
            IlrBOMTypeDescriptor elementsType = null;
            if (separatorIndex != -1) {
                elementsType = IlrHRSerializationUtils.deserializeBOMTypeDescriptor(theSerializedBOMTypeDescriptor.substring(separatorIndex + 1, theSerializedBOMTypeDescriptor.length() - 1));
            }
            returnedValue = new IlrDefaultBOMTypeDescriptor(fqn, elementsType);
        }
        return returnedValue;
    }
}

