/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.mbean.util;

import ilog.rules.res.mbean.util.IlrMBeanManagerImpl;
import ilog.rules.res.mbean.util.InvocationResult;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NamingException;

class IlrMBeanManagerImpl_weblogic9
extends IlrMBeanManagerImpl {
    private static final String JNDI_LOCAL_MBEANSERVER = "java:comp/env/jmx/runtime";
    private static final String JNDI_LOCAL_MBEANSERVER_BACKUP = "java:comp/jmx/runtime";
    private static final String JNDI_ADMIN_MBEANSERVER = "/jndi/weblogic.management.mbeanservers.domainruntime";
    private static final String SERVER_RUNTIME_QUERY = "com.bea:Type=ServerRuntime,*";
    private static final String SERVER_RUNTIME_ATTRIBUTE_PORT = "AdminServerListenPort";
    private static final String SERVER_RUNTIME_ATTRIBUTE_HOST = "AdminServerHost";
    private static final String SERVER_RUNTIME_ATTRIBUTE_LISTEN_PORT_SECURE = "AdminServerListenPortSecure";
    private static final String PROTOCOL = "t3";
    private static final String SECURE_PROTOCOL = "t3s";
    private static final String PROTOCOL_PROVIDER_PACKAGES = "weblogic.management.remote";
    private static final String OBJECTNAME_PROPERTY_LOCATION = "Location";

    public IlrMBeanManagerImpl_weblogic9(Properties props) {
        super("Type", "RES", props);
    }

    @Override
    public String getImplementationName() {
        return "WebLogic 9";
    }

    @Override
    public void initMBeanManager() throws Exception {
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws NamingException {
                InitialContext ctx = new InitialContext(IlrMBeanManagerImpl_weblogic9.this.props);
                try {
                    IlrMBeanManagerImpl_weblogic9.this.mbeanServer = (MBeanServer)ctx.lookup(IlrMBeanManagerImpl_weblogic9.JNDI_LOCAL_MBEANSERVER);
                }
                catch (NamingException e) {
                    IlrMBeanManagerImpl_weblogic9.this.mbeanServer = (MBeanServer)ctx.lookup(IlrMBeanManagerImpl_weblogic9.JNDI_LOCAL_MBEANSERVER_BACKUP);
                }
                return null;
            }
        });
    }

    @Override
    protected List<InvocationResult> invoke(final int type, final String serverInfoQuery, final ObjectName query, final String operationName, final Object[] params, final String[] signature) {
        return AccessController.doPrivileged(new PrivilegedAction<List<InvocationResult>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<InvocationResult> run() {
                ArrayList<InvocationResult> result = new ArrayList<InvocationResult>();
                JMXConnector connector = null;
                try {
                    connector = IlrMBeanManagerImpl_weblogic9.this.getJMXConnector();
                    MBeanServerConnection mbeanServerConnection = connector.getMBeanServerConnection();
                    String computedServerInfoQuery = serverInfoQuery;
                    ObjectName computedQuery = query;
                    if (query != null && query.getKeyProperty(IlrMBeanManagerImpl_weblogic9.OBJECTNAME_PROPERTY_LOCATION) != null) {
                        computedServerInfoQuery = query.getKeyProperty(IlrMBeanManagerImpl_weblogic9.OBJECTNAME_PROPERTY_LOCATION);
                        computedQuery = IlrMBeanManagerImpl_weblogic9.this.removeLocationProperty(query, computedServerInfoQuery);
                    }
                    for (ObjectName objectName : mbeanServerConnection.queryNames(computedQuery, null)) {
                        String serverInfo = objectName.getKeyProperty(IlrMBeanManagerImpl_weblogic9.OBJECTNAME_PROPERTY_LOCATION);
                        if (computedServerInfoQuery != null && !computedServerInfoQuery.equals(serverInfo)) continue;
                        result.add(IlrMBeanManagerImpl_weblogic9.this.invokeDispatcher(mbeanServerConnection, serverInfo, type, objectName, operationName, params, signature));
                    }
                    connector.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (connector != null) {
                        try {
                            connector.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return result;
            }
        });
    }

    private ObjectName removeLocationProperty(ObjectName on, String locationValue) throws MalformedObjectNameException {
        int length;
        String locationPropsStr;
        int index;
        String queryStr = on.getCanonicalName();
        if (queryStr.charAt((index = queryStr.indexOf(locationPropsStr = "Location=" + locationValue)) + (length = locationPropsStr.length())) == ',') {
            ++length;
        }
        return new ObjectName(queryStr.substring(0, index) + queryStr.substring(index + length));
    }

    private JMXConnector getJMXConnector() throws MalformedObjectNameException, IOException {
        Set<ObjectName> serverRuntimeObjectNames = this.mbeanServer.queryNames(new ObjectName(SERVER_RUNTIME_QUERY), null);
        if (serverRuntimeObjectNames.size() != 1) {
            throw new IllegalStateException();
        }
        ObjectName serverRuntimeObjectName = serverRuntimeObjectNames.iterator().next();
        Integer port = null;
        String host = null;
        Boolean isServerSecured = Boolean.FALSE;
        try {
            port = (Integer)this.mbeanServer.getAttribute(serverRuntimeObjectName, SERVER_RUNTIME_ATTRIBUTE_PORT);
            host = (String)this.mbeanServer.getAttribute(serverRuntimeObjectName, SERVER_RUNTIME_ATTRIBUTE_HOST);
            isServerSecured = (Boolean)this.mbeanServer.getAttribute(serverRuntimeObjectName, SERVER_RUNTIME_ATTRIBUTE_LISTEN_PORT_SECURE);
            if (isServerSecured == null) {
                isServerSecured = Boolean.FALSE;
            }
        }
        catch (Exception e) {
            return null;
        }
        String protocol = isServerSecured != false ? SECURE_PROTOCOL : PROTOCOL;
        JMXServiceURL serviceURL = new JMXServiceURL(protocol, host, port, JNDI_ADMIN_MBEANSERVER);
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("jmx.remote.protocol.provider.pkgs", PROTOCOL_PROVIDER_PACKAGES);
        return JMXConnectorFactory.connect(serviceURL, h);
    }
}

