/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model;

import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrRESRulesetArchiveCreationException;
import ilog.rules.res.model.internal.IlrCRERulesetArchiveImpl;
import ilog.rules.res.model.internal.IlrDERulesetArchiveImpl;
import ilog.rules.res.model.internal.IlrModelImplLocalization;
import ilog.rules.res.model.internal.IlrRESArchiveUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class IlrRESRulesetArchiveFactory {
    public static final IlrRESRulesetArchive createRESRulesetArchive(IlrEngineType type, InputStream input) throws IlrRESRulesetArchiveCreationException {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        try {
            return IlrRESArchiveUtil.getRESRulesetArchive(type, input);
        }
        catch (IOException e) {
            throw new IlrRESRulesetArchiveCreationException(IlrModelImplLocalization.RES_RULESET_ARCHIVE_CREATION_ERROR, e);
        }
    }

    public static final IlrRESRulesetArchive createRESRulesetArchive(IlrEngineType type, byte[] archive) throws IlrRESRulesetArchiveCreationException {
        if (archive == null || archive.length == 0) {
            throw new IllegalArgumentException();
        }
        if (type == IlrEngineType.DE) {
            return new IlrDERulesetArchiveImpl(archive);
        }
        if (type == IlrEngineType.CRE) {
            ByteArrayInputStream input = new ByteArrayInputStream(archive);
            try {
                IlrCRERulesetArchiveImpl ilrCRERulesetArchiveImpl = new IlrCRERulesetArchiveImpl(IlrRESArchiveUtil.getRulesetArchive(input));
                return ilrCRERulesetArchiveImpl;
            }
            catch (IOException e) {
                throw new IlrRESRulesetArchiveCreationException(IlrModelImplLocalization.RES_RULESET_ARCHIVE_CREATION_ERROR, e);
            }
            finally {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {}
            }
        }
        throw new IllegalArgumentException();
    }
}

