/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model;

import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.internal.IlrModelLocalization;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IlrVersion
implements Comparable<IlrVersion>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN = Pattern.compile("([1-9][0-9]*)\\.([0-9]+)");
    private final int major;
    private final int minor;

    public IlrVersion(int major, int minor) {
        if (major <= 0 || minor < 0) {
            throw new IllegalArgumentException();
        }
        this.major = major;
        this.minor = minor;
    }

    public static IlrVersion parseVersion(String version) throws IlrFormatException {
        int major;
        if (version == null) {
            return null;
        }
        Matcher m = PATTERN.matcher(version);
        if (!m.matches()) {
            throw new IlrFormatException("ilog.rules.res.model.messages", IlrModelLocalization.INVALID_PATH, new String[]{version});
        }
        int minor = 0;
        try {
            major = IlrVersion.parseInt(m.group(1));
        }
        catch (NumberFormatException e) {
            throw new IlrFormatException("ilog.rules.res.model.messages", IlrModelLocalization.INVALID_PATH_MAJOR_OVERFLOW, new String[]{version});
        }
        try {
            minor = IlrVersion.parseInt(m.group(2));
        }
        catch (NumberFormatException e) {
            throw new IlrFormatException("ilog.rules.res.model.messages", IlrModelLocalization.INVALID_PATH_MINOR_OVERFLOW, new String[]{version});
        }
        return new IlrVersion(major, minor);
    }

    private static int parseInt(String intAsString) {
        int length = intAsString.length();
        int result = 0;
        int max = -2147483647;
        int multmax = -214748364;
        int i = 0;
        while (i < length) {
            int curr = intAsString.charAt(i++) - 48;
            if (result < -214748364) {
                throw new NumberFormatException();
            }
            if ((result *= 10) < -2147483647 + curr) {
                throw new NumberFormatException();
            }
            result -= curr;
        }
        return -1 * result;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    @Override
    public int compareTo(IlrVersion o) {
        return this.major == o.major ? (this.minor == o.minor ? 0 : (this.minor < o.minor ? -1 : 1)) : (this.major < o.major ? -1 : 1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IlrVersion)) {
            return false;
        }
        IlrVersion version = (IlrVersion)obj;
        return this.major == version.major && this.minor == version.minor;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.major;
        result = 37 * result + this.minor;
        return result;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.major).append('.').append(this.minor);
        return buff.toString();
    }
}

