/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrRulesetParameter;
import ilog.rules.res.model.internal.IlrBaseRESRulesetArchive;
import ilog.rules.res.model.internal.IlrRESArchiveUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;

public class IlrCRERulesetArchiveImpl
extends IlrBaseRESRulesetArchive
implements IlrCRERulesetArchive {
    protected IlrRulesetArchive rulesetArchive;

    public IlrCRERulesetArchiveImpl(IlrRulesetArchive rulesetArchive) {
        this.rulesetArchive = rulesetArchive;
    }

    @Override
    public IlrRulesetArchive getRulesetArchive() {
        return this.rulesetArchive;
    }

    @Override
    public InputStream getContentStream() {
        byte[] content = this.getRulesetArchiveAsBytes();
        if (content == null) {
            return null;
        }
        return StreamUtil.toStream(content);
    }

    protected byte[] getRulesetArchiveAsBytes() {
        try {
            return IlrRESArchiveUtil.getRulesetArchiveAsBytes(this.rulesetArchive);
        }
        catch (IOException e) {
            throw new IlrResourceRuntimeException(e);
        }
    }

    @Override
    public Collection<IlrRulesetParameter> getRulesetParameters(byte direction) {
        try {
            return new IlrRESArchiveUtil().extractRulesetParametersFromRulesetArchiveXmlSignature(StreamUtil.toStream(this.rulesetArchive.getRulesetSignature().getBytes(this.rulesetArchive.getXmlEncoding())), direction);
        }
        catch (UnsupportedEncodingException e) {
            throw new IlrResourceRuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IlrCRERulesetArchive)) {
            return false;
        }
        IlrCRERulesetArchive other = (IlrCRERulesetArchive)object;
        return this.rulesetArchive.compare(other.getRulesetArchive());
    }
}

