/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import ilog.rules.res.model.IlrPath;
import java.io.Serializable;
import java.util.ResourceBundle;

public class IlrDeploymentOperation
implements Comparable<IlrDeploymentOperation>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int UPDATE = 0;
    public static final int ADD = 1;
    public static final int CHANGE_VERSION_AND_ADD = 2;
    public static final int REPLACE = 3;
    private final IlrPath path;
    private final int operationType;
    private final IlrPath result;
    private final String managedXomGeneratedProperty;

    public IlrDeploymentOperation(IlrPath path, int operationType, IlrPath result, String managedXomGeneratedProperty) {
        this.path = path;
        this.operationType = operationType;
        this.result = result;
        this.managedXomGeneratedProperty = managedXomGeneratedProperty;
    }

    public IlrPath getPath() {
        return this.path;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public IlrPath getResult() {
        return this.result;
    }

    public String getManagedXOMGeneratedProperty() {
        return this.managedXomGeneratedProperty;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IlrDeploymentOperation)) {
            return false;
        }
        IlrDeploymentOperation mo = (IlrDeploymentOperation)o;
        return this.path.toString().equals(mo.getPath().toString());
    }

    @Override
    public int compareTo(IlrDeploymentOperation o) {
        int result = this.path.getRuleAppName().compareToIgnoreCase(o.getPath().getRuleAppName());
        if (result == 0) {
            result = this.path.getRuleAppName().compareTo(o.getPath().getRuleAppName());
        }
        if (result != 0) {
            return result;
        }
        if (this.path.getRuleAppVersion() != null && o.getPath().getRuleAppVersion() != null) {
            result = this.path.getRuleAppVersion().compareTo(o.getPath().getRuleAppVersion());
        } else {
            if (this.path.getRuleAppVersion() == null && o.getPath().getRuleAppVersion() != null) {
                return -1;
            }
            if (this.path.getRuleAppVersion() != null && o.getPath().getRuleAppVersion() == null) {
                return 1;
            }
        }
        if (result != 0) {
            return result;
        }
        if (this.path.getRulesetName() != null && o.getPath().getRulesetName() != null) {
            result = this.path.getRulesetName().compareToIgnoreCase(o.getPath().getRulesetName());
            if (result == 0) {
                result = this.path.getRulesetName().compareTo(o.getPath().getRulesetName());
            }
        } else {
            if (this.path.getRulesetName() == null && o.getPath().getRulesetName() != null) {
                return -1;
            }
            if (this.path.getRulesetName() != null && o.getPath().getRulesetName() == null) {
                return 1;
            }
        }
        if (result != 0) {
            return result;
        }
        if (this.path.getRulesetVersion() != null && o.getPath().getRulesetVersion() != null) {
            result = this.path.getRulesetVersion().compareTo(o.getPath().getRulesetVersion());
        } else {
            if (this.path.getRulesetVersion() == null && o.getPath().getRulesetVersion() != null) {
                return -1;
            }
            if (this.path.getRulesetVersion() != null && o.getPath().getRulesetVersion() == null) {
                return 1;
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.path.toString());
        buffer.append(" -> ");
        buffer.append(this.result.toString());
        buffer.append(": ");
        ResourceBundle bundle = ResourceBundle.getBundle("ilog.rules.res.model.impl.text");
        switch (this.operationType) {
            case 0: {
                buffer.append(bundle.getString("deployreport.update"));
                break;
            }
            case 1: {
                buffer.append(bundle.getString("deployreport.add"));
                break;
            }
            case 2: {
                buffer.append(bundle.getString("deployreport.pathChanged"));
                break;
            }
            case 3: {
                buffer.append(bundle.getString("deployreport.replace"));
            }
        }
        return buffer.toString();
    }
}

