/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import ilog.rules.res.model.IlrAlreadyExistException;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrDeploymentReport;
import ilog.rules.res.model.internal.IlrEntityContainer;
import ilog.rules.res.model.internal.IlrModelImplLocalization;
import ilog.rules.res.model.internal.IlrMutableRuleAppInformationImpl;
import ilog.rules.res.model.internal.IlrMutableRulesetArchiveInformationImpl;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.persistence.IlrTransaction;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class IlrMutableRepositoryImpl
implements IlrMutableRepository {
    protected final IlrRepositoryFactory repositoryFactory;
    protected IlrRepositoryDAO repositoryDAO;
    protected IlrEntityContainer<IlrMutableRuleAppInformation> ruleAppsContainer = new IlrEntityContainer();

    protected IlrMutableRepositoryImpl(IlrRepositoryFactory repositoryFactory) {
        this(repositoryFactory, null, null);
    }

    protected IlrMutableRepositoryImpl(IlrRepositoryFactory repositoryFactory, IlrRepositoryDAO repositoryDAO, Set<IlrMutableRuleAppInformation> ruleApps) {
        this.repositoryFactory = repositoryFactory;
        this.repositoryDAO = repositoryDAO;
        this.ruleAppsContainer = new IlrEntityContainer();
        if (ruleApps != null) {
            for (IlrMutableRuleAppInformation ruleApp : ruleApps) {
                this.ruleAppsContainer.addEntity(ruleApp.getName(), ruleApp.getVersion(), ruleApp);
                ((IlrMutableRuleAppInformationImpl)ruleApp).linked(this, false);
            }
        }
    }

    public int getNbRuleApps() {
        return this.ruleAppsContainer.getNbEntities();
    }

    @Override
    public Set<IlrMutableRuleAppInformation> getRuleApps() {
        return Collections.unmodifiableSet(this.ruleAppsContainer.getEntities());
    }

    @Override
    public Set<IlrMutableRuleAppInformation> getRuleApps(String ruleAppName) {
        return Collections.unmodifiableSet(this.ruleAppsContainer.getEntities(ruleAppName));
    }

    @Override
    public IlrMutableRuleAppInformation getGreatestRuleApp(String ruleAppName) {
        return this.ruleAppsContainer.getGreatestEntity(ruleAppName);
    }

    @Override
    public IlrMutableRuleAppInformation getRuleApp(String ruleAppName, IlrVersion ruleAppVersion) {
        return this.ruleAppsContainer.getEntity(ruleAppName, ruleAppVersion);
    }

    @Override
    public IlrMutableRuleAppInformation addRuleApp(IlrMutableRuleAppInformation ruleApp) throws IlrAlreadyExistException, IlrResourceRuntimeException {
        if (ruleApp == null) {
            return null;
        }
        if (ruleApp.getRepository() == this || this.ruleAppsContainer.containsEntity(ruleApp.getName(), ruleApp.getVersion())) {
            throw new IlrAlreadyExistException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RULEAPP_ALREADY_EXIST, new String[]{ruleApp.toString()});
        }
        ((IlrMutableRuleAppInformationImpl)ruleApp).setRepository(this);
        this.ruleAppsContainer.addEntity(ruleApp.getName(), ruleApp.getVersion(), ruleApp);
        return ruleApp;
    }

    @Override
    public boolean removeRuleApp(IlrMutableRuleAppInformation ruleApp) throws IlrResourceRuntimeException {
        if (ruleApp == null || ruleApp.getRepository() != this) {
            return false;
        }
        IlrMutableRuleAppInformationImpl ra = (IlrMutableRuleAppInformationImpl)this.ruleAppsContainer.getEntity(ruleApp.getName(), ruleApp.getVersion());
        if (ra == null || ra != ruleApp) {
            return false;
        }
        ra.setRepository(null);
        this.ruleAppsContainer.removeEntity(ruleApp.getName(), ruleApp.getVersion());
        return true;
    }

    public IlrRepositoryDAO getDAO() {
        return this.repositoryDAO;
    }

    protected IlrDeploymentReport commit(List<EntityOperation> operations) {
        try {
            this.commitResources(operations);
        }
        catch (IlrDAOException e) {
            throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.MERGE_ERROR, e);
        }
        IlrDeploymentReport report = new IlrDeploymentReport();
        for (EntityOperation operation : operations) {
            operation.commitOnRepository(this);
            operation.commitOnReport(report);
        }
        return report;
    }

    private void commitResources(List<EntityOperation> operations) throws IlrDAOException {
        if (this.repositoryDAO == null) {
            return;
        }
        IlrTransaction transaction = this.repositoryDAO.beginTransaction();
        try {
            for (EntityOperation operation : operations) {
                operation.commitOnResourceProvider(this.repositoryDAO, transaction);
            }
            transaction.commit();
        }
        catch (IlrDAOException e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    public void update() {
        IlrMutableRuleAppInformationImpl ruleApp;
        if (this.repositoryDAO == null) {
            return;
        }
        Set<IlrMutableRuleAppInformation> ruleApps = null;
        try {
            ruleApps = this.repositoryDAO.load(this.repositoryFactory);
        }
        catch (IlrDAOException e) {
            throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.REPOSITORY_UPDATE_ERROR, e);
        }
        IlrEntityContainer<IlrMutableRuleAppInformation> newRuleAppsContainer = new IlrEntityContainer<IlrMutableRuleAppInformation>();
        for (IlrMutableRuleAppInformation ruleApp2 : ruleApps) {
            newRuleAppsContainer.addEntity(ruleApp2.getName(), ruleApp2.getVersion(), ruleApp2);
        }
        for (IlrMutableRuleAppInformation ilrMutableRuleAppInformation : this.getRuleApps()) {
            IlrMutableRulesetArchiveInformationImpl ruleset;
            ruleApp = (IlrMutableRuleAppInformationImpl)ilrMutableRuleAppInformation;
            IlrMutableRuleAppInformationImpl newRuleApp = (IlrMutableRuleAppInformationImpl)newRuleAppsContainer.removeEntity(ruleApp.getName(), ruleApp.getVersion());
            if (newRuleApp == null) {
                this.ruleAppsContainer.removeEntity(ruleApp.getName(), ruleApp.getVersion());
                ruleApp.linked(null, true);
                continue;
            }
            for (IlrMutableRulesetArchiveInformation ilrMutableRulesetArchiveInformation : ruleApp.getRulesets()) {
                ruleset = (IlrMutableRulesetArchiveInformationImpl)ilrMutableRulesetArchiveInformation;
                IlrMutableRulesetArchiveInformationImpl newRuleset = (IlrMutableRulesetArchiveInformationImpl)newRuleApp.rulesetsContainer.removeEntity(ruleset.getName(), ruleset.getVersion());
                if (newRuleset == null) {
                    ruleApp.rulesetsContainer.removeEntity(ruleset.getName(), ruleset.getVersion());
                    ruleset.linked(null, true);
                    continue;
                }
                ruleset.updateFields(newRuleset);
            }
            for (IlrMutableRulesetArchiveInformation ilrMutableRulesetArchiveInformation : newRuleApp.rulesetsContainer.getEntities()) {
                ruleset = (IlrMutableRulesetArchiveInformationImpl)ilrMutableRulesetArchiveInformation;
                ruleApp.rulesetsContainer.addEntity(ruleset.getName(), ruleset.getVersion(), ruleset);
                ruleset.linked(ruleApp, false);
            }
            ruleApp.updateFields(newRuleApp, false);
        }
        for (IlrMutableRuleAppInformation ilrMutableRuleAppInformation : newRuleAppsContainer.getEntities()) {
            ruleApp = (IlrMutableRuleAppInformationImpl)ilrMutableRuleAppInformation;
            this.ruleAppsContainer.addEntity(ruleApp.getName(), ruleApp.getVersion(), ruleApp);
            ruleApp.linked(this, false);
        }
    }

    protected static interface EntityOperation {
        public void commitOnResourceProvider(IlrRepositoryDAO var1, IlrTransaction var2) throws IlrDAOException;

        public void commitOnRepository(IlrMutableRepositoryImpl var1);

        public void commitOnReport(IlrDeploymentReport var1);
    }
}

