/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import ilog.rules.res.model.IlrAlreadyExistException;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrRepository;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrRuleAppInformation;
import ilog.rules.res.model.IlrRulesetArchiveInformation;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrModelImplLocalization;
import ilog.rules.res.model.internal.IlrMutableRepositoryImpl;
import ilog.rules.res.model.internal.IlrMutableRuleAppInformationImpl;
import ilog.rules.res.model.internal.IlrMutableRulesetArchiveInformationImpl;
import ilog.rules.res.model.internal.IlrNameValidator;
import ilog.rules.res.model.internal.IlrRepositoryImpl;
import ilog.rules.res.model.internal.IlrRuleAppInformationImpl;
import ilog.rules.res.model.internal.IlrRulesetArchiveInformationImpl;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IlrRepositoryFactoryImpl
implements IlrRepositoryFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public IlrMutableRepository createRepository() {
        return new IlrMutableRepositoryImpl(this);
    }

    public IlrMutableRepository createRepository(IlrRepositoryDAO repositoryDAO) throws IlrResourceRuntimeException, IlrIllegalArgumentRuntimeException {
        Set<IlrMutableRuleAppInformation> ruleApps = this.loadRepository(repositoryDAO);
        return new IlrMutableRepositoryImpl(this, repositoryDAO, ruleApps);
    }

    @Override
    public IlrMutableRuleAppInformation createRuleApp(String name, IlrVersion version) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        return this.createRuleApp(name, version, new Date());
    }

    @Override
    public IlrMutableRuleAppInformation createRuleApp(String name, IlrVersion version, Date creationDate) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        this.checkRuleAppParameters(name, version, creationDate);
        return new IlrMutableRuleAppInformationImpl(name, version, creationDate);
    }

    @Override
    public IlrMutableRuleAppInformation createRuleApp(IlrMutableRuleAppInformation ruleApp) throws IlrIllegalArgumentRuntimeException {
        IlrMutableRuleAppInformation newRuleApp;
        if (ruleApp == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RULEAPP_NULL_ERROR);
        }
        try {
            newRuleApp = this.createRuleApp(ruleApp.getName(), ruleApp.getVersion(), ruleApp.getCreationDate());
        }
        catch (IlrFormatException e) {
            throw new IllegalStateException();
        }
        newRuleApp.setDisplayName(ruleApp.getDisplayName());
        newRuleApp.setDescription(ruleApp.getDescription());
        for (Map.Entry entry : ruleApp.getProperties().entrySet()) {
            newRuleApp.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (IlrMutableRulesetArchiveInformation ruleset : ruleApp.getRulesets()) {
            IlrMutableRulesetArchiveInformation newRuleset = this.createRuleset(ruleset);
            try {
                newRuleApp.addRuleset(newRuleset);
            }
            catch (IlrAlreadyExistException e) {
                throw new IllegalStateException();
            }
        }
        return newRuleApp;
    }

    @Override
    public IlrMutableRulesetArchiveInformation createRuleset(String name, IlrVersion version) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        return this.createRuleset(name, version, new Date());
    }

    @Override
    public IlrMutableRulesetArchiveInformation createRuleset(String name, IlrVersion version, Date creationDate) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        this.checkRulesetParameters(name, version, creationDate);
        return new IlrMutableRulesetArchiveInformationImpl(name, version, creationDate);
    }

    @Override
    public IlrMutableRulesetArchiveInformation createRuleset(IlrMutableRulesetArchiveInformation ruleset) throws IlrIllegalArgumentRuntimeException {
        IlrMutableRulesetArchiveInformation newRuleset;
        if (ruleset == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RULESET_NULL_ERROR);
        }
        try {
            newRuleset = this.createRuleset(ruleset.getName(), ruleset.getVersion(), ruleset.getCreationDate());
        }
        catch (IlrFormatException e) {
            throw new IllegalStateException();
        }
        newRuleset.setDisplayName(ruleset.getDisplayName());
        newRuleset.setDescription(ruleset.getDescription());
        if (ruleset.getRESRulesetArchive() != null) {
            newRuleset.setRESRulesetArchive(ruleset.getProperties().getEngineType(), ruleset.getRESRulesetArchive().getContentStream());
        }
        for (Map.Entry entry : ruleset.getProperties().entrySet()) {
            newRuleset.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return newRuleset;
    }

    @Override
    public IlrRepository unmodifiableRepository(IlrMutableRepository repository) {
        if (repository == null) {
            return null;
        }
        return new IlrRepositoryImpl(this, repository);
    }

    @Override
    public IlrRuleAppInformation unmodifiableRuleApp(IlrMutableRuleAppInformation ruleApp) {
        if (ruleApp == null) {
            return null;
        }
        return new IlrRuleAppInformationImpl(this, ruleApp);
    }

    @Override
    public Set<IlrRuleAppInformation> unmodifiableRuleApps(Set<IlrMutableRuleAppInformation> ruleApps) {
        if (ruleApps == null) {
            return null;
        }
        HashSet<IlrRuleAppInformation> result = new HashSet<IlrRuleAppInformation>(ruleApps.size());
        for (IlrMutableRuleAppInformation ruleApp : ruleApps) {
            result.add(this.unmodifiableRuleApp(ruleApp));
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public IlrRulesetArchiveInformation unmodifiableRuleset(IlrMutableRulesetArchiveInformation ruleset) {
        if (ruleset == null) {
            return null;
        }
        return new IlrRulesetArchiveInformationImpl(this, ruleset);
    }

    @Override
    public Set<IlrRulesetArchiveInformation> unmodifiableRulesets(Set<IlrMutableRulesetArchiveInformation> rulesets) {
        if (rulesets == null) {
            return null;
        }
        HashSet<IlrRulesetArchiveInformation> result = new HashSet<IlrRulesetArchiveInformation>(rulesets.size());
        for (IlrMutableRulesetArchiveInformation ruleset : rulesets) {
            result.add(this.unmodifiableRuleset(ruleset));
        }
        return Collections.unmodifiableSet(result);
    }

    protected void checkRuleAppParameters(String name, IlrVersion version, Date creationDate) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        IlrNameValidator.validateRuleAppName(name);
        if (version == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.VERSION_NULL_ERROR);
        }
        if (creationDate == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.DATE_NULL_ERROR);
        }
    }

    protected void checkRulesetParameters(String name, IlrVersion version, Date creationDate) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        IlrNameValidator.validateRulesetName(name);
        if (version == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.VERSION_NULL_ERROR);
        }
        if (creationDate == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.DATE_NULL_ERROR);
        }
    }

    protected Set<IlrMutableRuleAppInformation> loadRepository(IlrRepositoryDAO repositoryDAO) throws IlrResourceRuntimeException, IlrIllegalArgumentRuntimeException {
        if (repositoryDAO == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RESOURCE_PROVIDER_NULL_ERROR);
        }
        try {
            return repositoryDAO.load(this);
        }
        catch (IlrDAOException e) {
            throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.REPOSITORY_LOAD_ERROR, e);
        }
    }
}

